/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.common.tileentity;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.api.BlockCoords;
import sonar.core.helpers.SonarHelper;
import sonar.core.network.sync.ISyncPart;
import sonar.core.network.sync.SyncTagType;
import sonar.core.network.utils.IByteBufTile;
import sonar.logistics.api.LogisticsAPI;
import sonar.logistics.api.connecting.CableType;
import sonar.logistics.api.connecting.IEntityNode;
import sonar.logistics.api.connecting.IInfoEmitter;
import sonar.logistics.api.info.ILogicInfo;
import sonar.logistics.api.render.ICableRenderer;
import sonar.logistics.common.tileentity.TileEntityChannelledCable;
import sonar.logistics.info.types.BlockCoordsInfo;

public class TileEntityEntityNode
extends TileEntityChannelledCable
implements IInfoEmitter,
ICableRenderer,
IEntityNode,
IByteBufTile {
    public SyncTagType.INT entityTarget = new SyncTagType.INT(0);
    public SyncTagType.INT entityRange = (SyncTagType.INT)new SyncTagType.INT(1).setDefault((Object)10);
    public float rotate = 0.0f;

    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            this.rotate = !(this.rotate >= 1.0f) ? (this.rotate += 0.01f) : 0.0f;
            return;
        }
    }

    @Override
    public CableType getCableType() {
        return CableType.BLOCK_CONNECTION;
    }

    @Override
    public boolean isBlocked(ForgeDirection dir) {
        return !this.canConnect(dir);
    }

    @Override
    public boolean canConnect(ForgeDirection dir) {
        return dir != ForgeDirection.UP;
    }

    @Override
    public CableType canRenderConnection(ForgeDirection dir) {
        if (dir == ForgeDirection.UP) {
            return CableType.NONE;
        }
        return LogisticsAPI.getCableHelper().canRenderConnection((TileEntity)this, dir, CableType.BLOCK_CONNECTION);
    }

    @Override
    public void addCable() {
        super.addCable();
        LogisticsAPI.getCableHelper().addConnection(this.registryID, this.getCoords());
    }

    @Override
    public void removeCable() {
        super.removeCable();
        LogisticsAPI.getCableHelper().removeConnection(this.registryID, this.getCoords());
    }

    @Override
    public ILogicInfo currentInfo() {
        return BlockCoordsInfo.createInfo("Entity Node", new BlockCoords((TileEntity)this));
    }

    @Override
    public void addConnections() {
    }

    @Override
    public void removeConnections() {
    }

    public void addSyncParts(List<ISyncPart> parts) {
        super.addSyncParts(parts);
        parts.addAll(Lists.newArrayList((Object[])new SyncTagType.INT[]{this.entityTarget, this.entityRange}));
    }

    public Entity getNearestEntity() {
        switch ((Integer)this.entityTarget.getObject()) {
            case 1: {
                return SonarHelper.getNearestEntity(EntityPlayer.class, (TileEntity)this, (int)((Integer)this.entityRange.getObject()));
            }
            case 2: {
                return SonarHelper.getNearestEntity(EntityMob.class, (TileEntity)this, (int)((Integer)this.entityRange.getObject()));
            }
            case 3: {
                return SonarHelper.getNearestEntity(EntityAnimal.class, (TileEntity)this, (int)((Integer)this.entityRange.getObject()));
            }
        }
        return SonarHelper.getNearestEntity(Entity.class, (TileEntity)this, (int)((Integer)this.entityRange.getObject()));
    }

    public void writePacket(ByteBuf buf, int id) {
        switch (id) {
            case 0: {
                buf.writeInt(((Integer)this.entityTarget.getObject()).intValue());
            }
        }
    }

    public void readPacket(ByteBuf buf, int id) {
        switch (id) {
            case 0: {
                this.entityTarget.setObject((Object)buf.readInt());
                break;
            }
            case 1: {
                if ((Integer)this.entityRange.getObject() == 64) break;
                this.entityRange.increaseBy(1);
                break;
            }
            case 2: {
                if ((Integer)this.entityRange.getObject() == 1) break;
                this.entityRange.decreaseBy(1);
            }
        }
    }

    @Override
    public List<Entity> getEntities() {
        return Arrays.asList(this.getNearestEntity());
    }
}

