/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.common.tileentity;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.SonarCore;
import sonar.core.api.BlockCoords;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.PacketTileSync;
import sonar.core.network.utils.IByteBufTile;
import sonar.logistics.api.LogisticsAPI;
import sonar.logistics.api.cache.EmptyNetworkCache;
import sonar.logistics.api.cache.INetworkCache;
import sonar.logistics.api.connecting.IChannelProvider;
import sonar.logistics.api.connecting.IInfoEmitter;
import sonar.logistics.api.info.ILogicInfo;
import sonar.logistics.api.info.LogicInfo;
import sonar.logistics.api.utils.ExternalCoords;
import sonar.logistics.api.utils.IdentifiedCoords;
import sonar.logistics.common.tileentity.TileEntityDataEmitter;
import sonar.logistics.common.tileentity.TileEntityNode;
import sonar.logistics.network.SyncIdentifiedCoords;
import sonar.logistics.registries.BlockRegistry;
import sonar.logistics.registries.EmitterRegistry;

public class TileEntityDataReceiver
extends TileEntityNode
implements IChannelProvider,
IInfoEmitter,
IByteBufTile {
    public List<IdentifiedCoords> emitters;
    public List<IdentifiedCoords> lastemitters;
    public SyncIdentifiedCoords emitter = new SyncIdentifiedCoords(0);
    public IdentifiedCoords selected;

    @Override
    public ExternalCoords getChannel() {
        if (this.emitter.getCoords() != null) {
            return new ExternalCoords(this.emitter.getCoords(), ForgeDirection.getOrientation((int)this.func_145832_p()));
        }
        return null;
    }

    @Override
    public INetworkCache getNetwork() {
        TileEntity channel;
        ExternalCoords coords = this.getChannel();
        if (coords != null && coords.blockCoords != null && (channel = coords.blockCoords.getTileEntity()) != null) {
            return LogisticsAPI.getCableHelper().getNetwork(channel, ForgeDirection.getOrientation((int)channel.func_145832_p()).getOpposite());
        }
        return new EmptyNetworkCache();
    }

    @Override
    public ILogicInfo currentInfo() {
        if (this.emitter.getCoords() != null) {
            return new LogicInfo(-1, "DEFAULT", "Connected: ", (Object)this.emitter.getCoords().blockCoords.toString());
        }
        return new LogicInfo(-1, "DEFAULT", "Connection: ", (Object)"NOT CONNECTED");
    }

    @Override
    public boolean canConnect(ForgeDirection dir) {
        return ForgeDirection.getOrientation((int)this.func_145832_p()) == dir;
    }

    public void func_145845_h() {
        TileEntity tile;
        super.func_145845_h();
        if (this.isClient()) {
            return;
        }
        if (this.emitter.getCoords() != null && (tile = this.emitter.getCoords().blockCoords.getTileEntity()) != null && tile instanceof TileEntityDataEmitter) {
            TileEntityDataEmitter dataEmitter = (TileEntityDataEmitter)tile;
            this.emitter.setCoords(new IdentifiedCoords((String)dataEmitter.clientName.getObject(), new ItemStack(BlockRegistry.dataEmitter), this.emitter.getCoords().blockCoords));
        }
    }

    public boolean maxRender() {
        return true;
    }

    public void sendAvailableData(TileEntity te, EntityPlayer player) {
        if (player != null && player instanceof EntityPlayerMP) {
            this.emitters = EmitterRegistry.getEmitters(this.playerName, (Boolean)this.isPrivate.getObject());
            NBTTagCompound syncData = new NBTTagCompound();
            this.writeData(syncData, NBTHelper.SyncType.SPECIAL);
            SonarCore.network.sendTo((IMessage)new PacketTileSync(te.field_145851_c, te.field_145848_d, te.field_145849_e, syncData, NBTHelper.SyncType.SPECIAL), (EntityPlayerMP)player);
        }
    }

    @Override
    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        NBTTagCompound compound;
        int i;
        NBTTagList list;
        super.readData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE) {
            this.emitter.readFromNBT(nbt, type);
        }
        if (type == NBTHelper.SyncType.SPECIAL) {
            this.emitter.readFromNBT(nbt, NBTHelper.SyncType.SYNC);
            if (nbt.func_74764_b("null")) {
                this.emitters = new ArrayList<IdentifiedCoords>();
                return;
            }
            list = nbt.func_150295_c("COORDS", 10);
            if (this.emitters == null) {
                this.emitters = new ArrayList<IdentifiedCoords>();
            }
            block5: for (i = 0; i < list.func_74745_c(); ++i) {
                compound = list.func_150305_b(i);
                int slot = compound.func_74762_e("Slot");
                boolean set = slot < this.emitters.size();
                switch (compound.func_74771_c("f")) {
                    case 0: {
                        if (set) {
                            this.emitters.set(slot, IdentifiedCoords.readFromNBT(compound));
                            continue block5;
                        }
                        this.emitters.add(slot, IdentifiedCoords.readFromNBT(compound));
                        continue block5;
                    }
                    case 1: {
                        String name = compound.func_74779_i("Name");
                        if (name != null) {
                            this.emitters.set(slot, new IdentifiedCoords(name, new ItemStack(BlockRegistry.dataEmitter), this.emitters.get((int)slot).blockCoords));
                            continue block5;
                        }
                        this.emitters.set(slot, null);
                        continue block5;
                    }
                    case 2: {
                        if (set) {
                            this.emitters.set(slot, null);
                            continue block5;
                        }
                        this.emitters.add(slot, null);
                    }
                }
            }
        }
        if (type == NBTHelper.SyncType.SYNC) {
            this.emitter.readFromNBT(nbt, NBTHelper.SyncType.SAVE);
            list = nbt.func_150295_c("COORDS", 10);
            this.emitters = new ArrayList<IdentifiedCoords>();
            for (i = 0; i < list.func_74745_c(); ++i) {
                compound = list.func_150305_b(i);
                this.emitters.add(IdentifiedCoords.readFromNBT(compound));
            }
        }
    }

    @Override
    public void writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        NBTTagList list;
        super.writeData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE) {
            this.emitter.writeToNBT(nbt, type);
        }
        if (type == NBTHelper.SyncType.SPECIAL) {
            this.emitter.writeToNBT(nbt, NBTHelper.SyncType.SYNC);
            if (this.emitters == null) {
                this.emitters = new ArrayList<IdentifiedCoords>();
            }
            if (this.lastemitters == null) {
                this.lastemitters = new ArrayList<IdentifiedCoords>();
            }
            if (this.emitters.size() <= 0 && this.lastemitters.size() > 0) {
                nbt.func_74757_a("null", true);
                this.lastemitters = new ArrayList<IdentifiedCoords>();
                return;
            }
            list = new NBTTagList();
            int size = Math.max(this.emitters.size(), this.lastemitters.size());
            for (int i = 0; i < size; ++i) {
                IdentifiedCoords current = null;
                IdentifiedCoords last = null;
                if (i < this.emitters.size()) {
                    current = this.emitters.get(i);
                }
                if (i < this.lastemitters.size()) {
                    last = this.lastemitters.get(i);
                }
                NBTTagCompound compound = new NBTTagCompound();
                if (current != null) {
                    if (last != null) {
                        if (!BlockCoords.equalCoords((BlockCoords)current.blockCoords, (BlockCoords)last.blockCoords)) {
                            compound.func_74774_a("f", (byte)0);
                            this.lastemitters.set(i, current);
                            IdentifiedCoords.writeToNBT(compound, this.emitters.get(i));
                        } else if (!current.coordString.equals(last.coordString)) {
                            compound.func_74774_a("f", (byte)1);
                            this.lastemitters.set(i, current);
                            compound.func_74778_a("Name", current.coordString);
                        }
                    } else {
                        compound.func_74774_a("f", (byte)0);
                        this.lastemitters.add(i, current);
                        IdentifiedCoords.writeToNBT(compound, this.emitters.get(i));
                    }
                } else if (last != null) {
                    this.lastemitters.set(i, null);
                    compound.func_74774_a("f", (byte)2);
                }
                if (compound.func_82582_d()) continue;
                compound.func_74768_a("Slot", i);
                list.func_74742_a((NBTBase)compound);
            }
            if (list.func_74745_c() != 0) {
                nbt.func_74782_a("COORDS", (NBTBase)list);
            }
        }
        if (type == NBTHelper.SyncType.SYNC) {
            this.emitter.writeToNBT(nbt, NBTHelper.SyncType.SAVE);
            list = new NBTTagList();
            if (this.emitters == null) {
                this.emitters = new ArrayList<IdentifiedCoords>();
            }
            for (int i = 0; i < this.emitters.size(); ++i) {
                if (this.emitters.get(i) == null) continue;
                NBTTagCompound compound = new NBTTagCompound();
                compound.func_74768_a("Slot", i);
                IdentifiedCoords.writeToNBT(compound, this.emitters.get(i));
                list.func_74742_a((NBTBase)compound);
            }
            nbt.func_74782_a("COORDS", (NBTBase)list);
        }
    }

    @Override
    public BlockCoords getCoords() {
        return new BlockCoords((TileEntity)this);
    }

    public void onLoaded() {
        super.onLoaded();
        if (!this.field_145850_b.field_72995_K) {
            this.addConnections();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K) {
            this.removeConnections();
        }
    }

    @Override
    public void addConnections() {
        if (!this.field_145850_b.field_72995_K) {
            LogisticsAPI.getCableHelper().addConnection((TileEntity)this, ForgeDirection.getOrientation((int)this.func_145832_p()));
        }
    }

    @Override
    public void removeConnections() {
        if (!this.field_145850_b.field_72995_K) {
            LogisticsAPI.getCableHelper().removeConnection((TileEntity)this, ForgeDirection.getOrientation((int)this.func_145832_p()));
        }
    }

    public void writePacket(ByteBuf buf, int id) {
        switch (id) {
            case 0: {
                IdentifiedCoords.writeCoords(buf, this.selected);
            }
        }
    }

    public void readPacket(ByteBuf buf, int id) {
        switch (id) {
            case 0: {
                this.emitter.setCoords(IdentifiedCoords.readCoords(buf));
            }
        }
    }
}

