/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.common.tileentity;

import io.netty.buffer.ByteBuf;
import java.text.SimpleDateFormat;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.SonarCore;
import sonar.core.api.BlockCoords;
import sonar.core.helpers.NBTHelper;
import sonar.core.integration.fmp.FMPHelper;
import sonar.core.network.sync.SyncTagType;
import sonar.core.network.utils.IByteBufTile;
import sonar.logistics.api.LogisticsAPI;
import sonar.logistics.api.info.ILogicInfo;
import sonar.logistics.common.tileentity.TileEntityConnection;
import sonar.logistics.info.types.BlockCoordsInfo;
import sonar.logistics.info.types.ProgressInfo;

public class TileEntityClock
extends TileEntityConnection
implements IByteBufTile {
    public long lastMillis;
    public long currentMillis;
    public long offset = 0L;
    public SyncTagType.LONG tickTime = new SyncTagType.LONG(0);
    public float rotation;
    public boolean isSet;
    public boolean lastSignal;
    public boolean wasStarted;
    public boolean powering;
    public long finalStopTime;

    public void func_145845_h() {
        super.func_145845_h();
        if (this.isClient()) {
            return;
        }
        this.currentMillis = this.field_145850_b.func_82737_E() * 50L;
        if ((Long)this.tickTime.getObject() >= 10L) {
            long start = this.currentMillis - this.lastMillis;
            this.rotation = start * 360L / (Long)this.tickTime.getObject();
            if (start > (Long)this.tickTime.getObject()) {
                this.lastMillis = this.currentMillis;
                this.powering = true;
                this.field_145850_b.func_147444_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
            } else if (this.powering) {
                this.powering = false;
                this.field_145850_b.func_147444_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
            }
            this.func_70296_d();
        }
        SonarCore.sendPacketAround((TileEntity)this, (int)64, (int)0);
    }

    public void checkStopwatch() {
    }

    @Override
    public ILogicInfo currentInfo() {
        if ((Long)this.tickTime.getObject() >= 10L) {
            long start = this.currentMillis - this.lastMillis;
            String timeString = new SimpleDateFormat("HH:mm:ss:SSS").format(start - 3600000L).substring(0, 11);
            return new ProgressInfo(start, (Long)this.tickTime.getObject(), timeString);
        }
        return BlockCoordsInfo.createInfo("CLOCK", new BlockCoords((TileEntity)this));
    }

    @Override
    public boolean canConnect(ForgeDirection dir) {
        return dir.equals((Object)ForgeDirection.getOrientation((int)FMPHelper.getMeta((TileEntity)this)));
    }

    public boolean maxRender() {
        return true;
    }

    @Override
    public void addConnections() {
        LogisticsAPI.getCableHelper().addConnection((TileEntity)this, ForgeDirection.getOrientation((int)FMPHelper.getMeta((TileEntity)this)));
    }

    @Override
    public void removeConnections() {
        LogisticsAPI.getCableHelper().removeConnection((TileEntity)this, ForgeDirection.getOrientation((int)FMPHelper.getMeta((TileEntity)this)));
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        this.tickTime.readFromNBT(nbt, type);
        if (type == NBTHelper.SyncType.SAVE) {
            nbt.func_74757_a("isSet", this.isSet);
            nbt.func_74757_a("lastSignal", this.lastSignal);
            nbt.func_74757_a("wasStarted", this.wasStarted);
            nbt.func_74772_a("finalStopTime", this.finalStopTime);
        }
    }

    public void writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        this.tickTime.writeToNBT(nbt, type);
        if (type == NBTHelper.SyncType.SAVE) {
            this.isSet = nbt.func_74767_n("isSet");
            this.lastSignal = nbt.func_74767_n("lastSignal");
            this.wasStarted = nbt.func_74767_n("wasStarted");
            this.finalStopTime = nbt.func_74763_f("finalStopTime");
        }
    }

    public void writePacket(ByteBuf buf, int id) {
        if (id == 0) {
            buf.writeFloat(this.rotation);
        }
        if (id == 1) {
            this.tickTime.writeToBuf(buf);
        }
    }

    public void readPacket(ByteBuf buf, int id) {
        if (id == 0) {
            this.rotation = buf.readFloat();
        }
        if (id == 1) {
            this.tickTime.readFromBuf(buf);
        }
        if (id == 2) {
            this.tickTime.increaseBy(100);
        }
        if (id == 3) {
            this.tickTime.increaseBy(-100);
        }
        if (id == 4) {
            this.tickTime.increaseBy(1000);
        }
        if (id == 5) {
            this.tickTime.increaseBy(-1000);
        }
        if (id == 6) {
            this.tickTime.increaseBy(60000);
        }
        if (id == 7) {
            this.tickTime.increaseBy(-60000);
        }
        if (id == 8) {
            this.tickTime.increaseBy(3600000);
        }
        if (id == 9) {
            this.tickTime.increaseBy(-3600000);
        }
        if ((Long)this.tickTime.getObject() < 0L) {
            this.tickTime.setObject((Object)0L);
        } else if ((Long)this.tickTime.getObject() > 86400000L) {
            this.tickTime.setObject((Object)86399999L);
        }
    }
}

