/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.common.tileentity;

import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.api.BlockCoords;
import sonar.core.common.tileentity.TileEntityHandler;
import sonar.core.integration.fmp.FMPHelper;
import sonar.core.integration.fmp.handlers.TileHandler;
import sonar.logistics.api.LogisticsAPI;
import sonar.logistics.api.connecting.CableType;
import sonar.logistics.api.connecting.IConnectionNode;
import sonar.logistics.api.connecting.IInfoEmitter;
import sonar.logistics.api.info.ILogicInfo;
import sonar.logistics.api.render.ICableRenderer;
import sonar.logistics.api.utils.ExternalCoords;
import sonar.logistics.common.handlers.ChannelSelectorHandler;
import sonar.logistics.info.types.BlockCoordsInfo;

public class TileEntityChannelSelector
extends TileEntityHandler
implements IInfoEmitter,
ICableRenderer,
IConnectionNode {
    public ChannelSelectorHandler handler = new ChannelSelectorHandler(false, (TileEntity)this);

    public TileHandler getTileHandler() {
        return this.handler;
    }

    @Override
    public boolean canConnect(ForgeDirection dir) {
        return this.handler.canConnect((TileEntity)this, dir);
    }

    @Override
    public ILogicInfo currentInfo() {
        return BlockCoordsInfo.createInfo("Channel Selector", new BlockCoords((TileEntity)this));
    }

    public boolean maxRender() {
        return true;
    }

    @Override
    public CableType canRenderConnection(ForgeDirection dir) {
        return this.handler.canRenderConnection((TileEntity)this, dir);
    }

    @Override
    public BlockCoords getCoords() {
        return new BlockCoords((TileEntity)this);
    }

    public void onLoaded() {
        super.onLoaded();
        if (!this.field_145850_b.field_72995_K) {
            this.addConnections();
        }
    }

    public void func_145843_s() {
        if (!this.field_145850_b.field_72995_K) {
            this.removeConnections();
        }
        super.func_145843_s();
    }

    @Override
    public void addConnections() {
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)i);
            if (dir == ForgeDirection.getOrientation((int)FMPHelper.getMeta((TileEntity)this)).getOpposite()) continue;
            LogisticsAPI.getCableHelper().addConnection((TileEntity)this, dir);
        }
    }

    @Override
    public void removeConnections() {
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)i);
            if (dir == ForgeDirection.getOrientation((int)FMPHelper.getMeta((TileEntity)this)).getOpposite()) continue;
            LogisticsAPI.getCableHelper().removeConnection((TileEntity)this, dir);
        }
    }

    @Override
    public void addConnections(Map<BlockCoords, ForgeDirection> connections) {
        try {
            ExternalCoords coords = this.handler.getChannel((TileEntity)this);
            connections.put(coords.blockCoords, coords.dir);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

