/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.common.tileentity;

import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.api.BlockCoords;
import sonar.core.helpers.SonarHelper;
import sonar.logistics.api.LogisticsAPI;
import sonar.logistics.api.connecting.CableType;
import sonar.logistics.api.connecting.IConnectionNode;
import sonar.logistics.api.connecting.IInfoEmitter;
import sonar.logistics.api.info.ILogicInfo;
import sonar.logistics.api.render.ICableRenderer;
import sonar.logistics.common.tileentity.TileEntityChannelledCable;
import sonar.logistics.info.types.BlockCoordsInfo;

public class TileEntityBlockNode
extends TileEntityChannelledCable
implements IInfoEmitter,
ICableRenderer,
IConnectionNode {
    @Override
    public CableType getCableType() {
        return CableType.BLOCK_CONNECTION;
    }

    @Override
    public boolean isBlocked(ForgeDirection dir) {
        return !this.canConnect(dir);
    }

    @Override
    public boolean canConnect(ForgeDirection dir) {
        return dir != ForgeDirection.getOrientation((int)SonarHelper.invertMetadata((int)this.func_145832_p())).getOpposite();
    }

    @Override
    public CableType canRenderConnection(ForgeDirection dir) {
        return LogisticsAPI.getCableHelper().canRenderConnection((TileEntity)this, dir, CableType.BLOCK_CONNECTION);
    }

    @Override
    public void addCable() {
        super.addCable();
        LogisticsAPI.getCableHelper().addConnection(this.registryID, this.getCoords());
    }

    @Override
    public void removeCable() {
        super.removeCable();
        LogisticsAPI.getCableHelper().removeConnection(this.registryID, this.getCoords());
    }

    @Override
    public ILogicInfo currentInfo() {
        return BlockCoordsInfo.createInfo("Node", new BlockCoords((TileEntity)this));
    }

    @Override
    public void addConnections(Map<BlockCoords, ForgeDirection> connections) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)SonarHelper.invertMetadata((int)this.func_145832_p())).getOpposite();
        BlockCoords tileCoords = new BlockCoords(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ, this.field_145850_b.field_73011_w.field_76574_g);
        connections.put(tileCoords, dir);
    }

    @Override
    public void addConnections() {
    }

    @Override
    public void removeConnections() {
    }
}

