/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.common.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.api.BlockCoords;
import sonar.core.common.tileentity.TileEntityHandlerInventory;
import sonar.core.integration.fmp.handlers.TileHandler;
import sonar.logistics.api.LogisticsAPI;
import sonar.logistics.api.connecting.CableType;
import sonar.logistics.api.connecting.IConnectionArray;
import sonar.logistics.api.connecting.IDataCable;
import sonar.logistics.common.handlers.ArrayHandler;

public class TileEntityArray
extends TileEntityHandlerInventory
implements IConnectionArray,
IDataCable {
    public int registryID = -1;
    public ArrayHandler handler = new ArrayHandler(false, (TileEntity)this);

    public TileHandler getTileHandler() {
        return this.handler;
    }

    @Override
    public BlockCoords getCoords() {
        return new BlockCoords((TileEntity)this);
    }

    @Override
    public boolean canConnect(ForgeDirection dir) {
        return dir != ForgeDirection.UP;
    }

    @Override
    public ItemStack[] getTransceivers() {
        return this.handler.slots;
    }

    @Override
    public void addConnections(Map<BlockCoords, ForgeDirection> connections) {
        connections.putAll(this.handler.coordList);
    }

    @Override
    public boolean isBlocked(ForgeDirection dir) {
        return dir == ForgeDirection.UP;
    }

    @Override
    public CableType canRenderConnection(ForgeDirection dir) {
        if (dir == ForgeDirection.UP) {
            return CableType.NONE;
        }
        return LogisticsAPI.getCableHelper().canRenderConnection((TileEntity)this, dir, this.getCableType());
    }

    public boolean maxRender() {
        return true;
    }

    public void onLoaded() {
        super.onLoaded();
        if (!this.field_145850_b.field_72995_K) {
            this.addCable();
        }
        this.handler.updateCoordsList();
    }

    public void func_145843_s() {
        if (!this.field_145850_b.field_72995_K) {
            this.removeCable();
        }
        super.func_145843_s();
    }

    @Override
    public void addCable() {
        LogisticsAPI.getCableHelper().addCable(this);
        LogisticsAPI.getCableHelper().addConnection(this.registryID, this.getCoords());
    }

    @Override
    public void removeCable() {
        LogisticsAPI.getCableHelper().removeCable(this);
        LogisticsAPI.getCableHelper().removeConnection(this.registryID, this.getCoords());
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaInfo(List<String> currenttip) {
        return currenttip;
    }

    @Override
    public int registryID() {
        return this.registryID;
    }

    @Override
    public void setRegistryID(int id) {
        this.registryID = id;
    }

    @Override
    public CableType getCableType() {
        return CableType.BLOCK_CONNECTION;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        super.func_70299_a(i, itemstack);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.handler.updateCoordsList();
    }

    @Override
    public void refreshConnections() {
        LogisticsAPI.getCableHelper().refreshConnections(this);
    }
}

