/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.common.handlers;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.SonarCore;
import sonar.core.api.BlockCoords;
import sonar.core.helpers.NBTHelper;
import sonar.core.helpers.SonarHelper;
import sonar.core.integration.fmp.FMPHelper;
import sonar.core.integration.fmp.handlers.TileHandler;
import sonar.core.network.sync.ISyncPart;
import sonar.core.network.sync.SyncTagType;
import sonar.core.network.utils.IByteBufTile;
import sonar.logistics.api.LogisticsAPI;
import sonar.logistics.api.cache.CacheTypes;
import sonar.logistics.api.cache.INetworkCache;
import sonar.logistics.api.render.LargeScreenSizing;
import sonar.logistics.common.handlers.DisplayScreenHandler;
import sonar.logistics.helpers.DisplayHelper;
import sonar.logistics.registries.DisplayRegistry;

public class LargeDisplayScreenHandler
extends DisplayScreenHandler
implements IByteBufTile {
    public SyncTagType.BOOLEAN isHandler = new SyncTagType.BOOLEAN(0);
    public LargeScreenSizing sizing;
    public boolean resetSizing = true;
    public boolean resetHandler = true;
    public BlockCoords connectedTile = null;
    public int registryID = -1;

    public LargeDisplayScreenHandler(boolean isMultipart, TileEntity tile) {
        super(isMultipart, tile);
    }

    @Override
    public void update(TileEntity te) {
        if (!te.func_145831_w().field_72995_K) {
            if (((Boolean)this.isHandler.getObject()).booleanValue()) {
                INetworkCache network;
                TileEntity tile;
                if (DisplayRegistry.hasChanged(this.registryID)) {
                    LargeScreenSizing lastSize = this.sizing;
                    this.sizing = DisplayHelper.getScreenSizing(te);
                    if (this.sizing == null && lastSize != null || lastSize == null || !lastSize.equals(this.sizing)) {
                        SonarCore.sendPacketAround((TileEntity)te, (int)64, (int)3);
                    }
                    DisplayRegistry.onUpdate(this.registryID);
                }
                ForgeDirection side = ForgeDirection.getOrientation((int)FMPHelper.getMeta((TileEntity)te));
                boolean updateTile = true;
                if (this.connectedTile != null && (tile = this.connectedTile.getTileEntity()) != null && (network = LogisticsAPI.getCableHelper().getNetwork(tile, side.getOpposite())) != null && !network.getConnections(CacheTypes.EMITTER, true).isEmpty()) {
                    updateTile = false;
                }
                if (updateTile) {
                    this.connectedTile = this.getConnectedTile(te, side);
                }
                if (this.connectedTile == null || this.connectedTile.getTileEntity(te.func_145831_w()) == null) {
                    this.updateData(te, te, side);
                } else {
                    this.updateData(this.connectedTile.getTileEntity(te.func_145831_w()), te, side);
                }
            }
            if (this.resetHandler) {
                SonarCore.sendPacketAround((TileEntity)te, (int)64, (int)4);
                this.resetHandler = false;
            }
        }
    }

    public LargeDisplayScreenHandler getHandler(TileEntity te) {
        ArrayList<ForgeDirection> dirs = new ArrayList<ForgeDirection>();
        ForgeDirection meta = ForgeDirection.getOrientation((int)FMPHelper.getMeta((TileEntity)te));
        for (ForgeDirection dir : ForgeDirection.values()) {
            if (dir == meta || dir == meta.getOpposite()) continue;
            dirs.add(dir);
        }
        ArrayList<BlockCoords> handlers = new ArrayList<BlockCoords>();
        return this.addCoords(te, handlers, dirs);
    }

    public LargeDisplayScreenHandler addCoords(TileEntity te, ArrayList<BlockCoords> handlers, List<ForgeDirection> dirs) {
        for (ForgeDirection side : dirs) {
            TileHandler handler;
            TileEntity tile = SonarHelper.getAdjacentTileEntity((TileEntity)te, (ForgeDirection)side);
            if (tile == null || (handler = FMPHelper.getHandler((Object)tile)) == null || !(handler instanceof LargeDisplayScreenHandler) || tile.func_145832_p() != te.func_145832_p()) continue;
            LargeDisplayScreenHandler screen = (LargeDisplayScreenHandler)handler;
            if (((Boolean)screen.isHandler.getObject()).booleanValue()) {
                return screen;
            }
            BlockCoords coords = new BlockCoords(tile);
            if (handlers.contains(coords)) continue;
            handlers.add(coords);
            return this.addCoords(tile, handlers, dirs);
        }
        return null;
    }

    public BlockCoords getConnectedTile(TileEntity te, ForgeDirection dir) {
        List<BlockCoords> displays = DisplayRegistry.getScreens(this.registryID);
        if (displays != null) {
            for (BlockCoords coords : displays) {
                INetworkCache network;
                if (coords == null || coords.getTileEntity() == null || (network = LogisticsAPI.getCableHelper().getNetwork(coords.getTileEntity(), dir.getOpposite())).getConnections(CacheTypes.EMITTER, true).isEmpty()) continue;
                return coords;
            }
        }
        return null;
    }

    @Override
    public void writePacket(ByteBuf buf, int id) {
        super.writePacket(buf, id);
        if (id == 3) {
            if (this.sizing != null) {
                buf.writeBoolean(true);
                this.sizing.writeToBuf(buf);
            } else {
                buf.writeBoolean(false);
            }
        }
        if (id == 4) {
            this.isHandler.writeToBuf(buf);
        }
    }

    @Override
    public void readPacket(ByteBuf buf, int id) {
        super.readPacket(buf, id);
        if (id == 3) {
            this.sizing = buf.readBoolean() ? LargeScreenSizing.readFromBuf(buf) : null;
        }
        if (id == 4) {
            this.isHandler.readFromBuf(buf);
        }
    }

    @Override
    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if ((type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.SYNC) && nbt.func_74764_b("mxY")) {
            this.sizing = LargeScreenSizing.readFromNBT(nbt);
        }
    }

    @Override
    public void writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if ((type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.SYNC) && this.sizing != null) {
            this.sizing.writeToNBT(nbt);
        }
    }

    public void addSyncParts(List<ISyncPart> parts) {
        super.addSyncParts(parts);
        parts.addAll(Lists.newArrayList((Object[])new SyncTagType.BOOLEAN[]{this.isHandler}));
    }
}

