/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.common.handlers;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.SonarCore;
import sonar.core.api.BlockCoords;
import sonar.core.api.SonarAPI;
import sonar.core.helpers.InventoryHelper;
import sonar.core.helpers.NBTHelper;
import sonar.core.helpers.NBTRegistryHelper;
import sonar.core.helpers.RegistryHelper;
import sonar.core.helpers.SonarHelper;
import sonar.core.integration.fmp.handlers.InventoryTileHandler;
import sonar.core.network.sync.ISyncPart;
import sonar.core.network.sync.SyncTagType;
import sonar.core.network.utils.IByteBufTile;
import sonar.logistics.Logistics;
import sonar.logistics.api.LogisticsAPI;
import sonar.logistics.api.cache.EmptyNetworkCache;
import sonar.logistics.api.cache.INetworkCache;
import sonar.logistics.api.utils.ItemFilter;
import sonar.logistics.info.filters.items.ItemStackFilter;
import sonar.logistics.info.filters.items.OreDictionaryFilter;

public class ItemRouterHandler
extends InventoryTileHandler
implements ISidedInventory,
IByteBufTile {
    public SyncTagType.INT[] sideConfigs = new SyncTagType.INT[6];
    public SyncTagType.INT listType = new SyncTagType.INT(7);
    public SyncTagType.INT side = new SyncTagType.INT(8);
    public SyncTagType.INT filterPos = new SyncTagType.INT(9);
    public List<ItemFilter>[] lastWhitelist = new List[6];
    public List<ItemFilter>[] whitelist = new List[6];
    public List<ItemFilter>[] lastBlacklist = new List[6];
    public List<ItemFilter>[] blacklist = new List[6];
    public int update = 0;
    public int updateTime = 20;
    public int clientClick = -1;
    public int editStack = -1;
    public int editOre = -1;
    public ItemStackFilter clientStackFilter = new ItemStackFilter();
    public OreDictionaryFilter clientOreFilter = new OreDictionaryFilter();

    public ItemRouterHandler(boolean isMultipart, TileEntity tile) {
        super(isMultipart, tile);
        this.slots = new ItemStack[9];
        for (int i = 0; i < 6; ++i) {
            this.sideConfigs[i] = new SyncTagType.INT(i + 1);
            this.lastWhitelist[i] = new ArrayList<ItemFilter>();
            this.whitelist[i] = new ArrayList<ItemFilter>();
            this.lastBlacklist[i] = new ArrayList<ItemFilter>();
            this.blacklist[i] = new ArrayList<ItemFilter>();
        }
    }

    public List<ItemFilter> getFilters() {
        return (Integer)this.listType.getObject() == 0 ? this.whitelist[(Integer)this.side.getObject()] : this.blacklist[(Integer)this.side.getObject()];
    }

    public void update(TileEntity te) {
        int config;
        if (te.func_145831_w().field_72995_K) {
            return;
        }
        this.update = this.update < this.updateTime ? ++this.update : 0;
        if (this.update < 6 && (config = ((Integer)this.sideConfigs[this.update].getObject()).intValue()) != 0) {
            ForgeDirection side = ForgeDirection.getOrientation((int)this.update);
            INetworkCache cache = LogisticsAPI.getCableHelper().getNetwork(te, side);
            if (!(cache instanceof EmptyNetworkCache)) {
                LinkedHashMap<BlockCoords, ForgeDirection> externalBlocks = cache.getExternalBlocks(true);
                for (Map.Entry<BlockCoords, ForgeDirection> entry : externalBlocks.entrySet()) {
                    if (entry.getKey() == null || entry.getKey().getTileEntity() == null) continue;
                    TileEntity tile = entry.getKey().getTileEntity();
                    this.routeInventory(te, config, tile, side, entry.getValue());
                }
            } else {
                TileEntity tile = SonarHelper.getAdjacentTileEntity((TileEntity)te, (ForgeDirection)side);
                if (tile != null) {
                    this.routeInventory(te, config, tile, side, side.getOpposite());
                }
            }
        }
    }

    public void routeInventory(TileEntity te, int config, TileEntity target, ForgeDirection side, ForgeDirection dir) {
        if (target != null && dir != null && target instanceof IInventory) {
            if (config == 1) {
                SonarAPI.getItemHelper().transferItems(target, te, dir, side, null);
            } else {
                SonarAPI.getItemHelper().transferItems(te, target, side, dir, null);
            }
        }
    }

    public void addItemFilter(ItemFilter filter) {
        if (filter == null) {
            return;
        }
        this.getFilters().add(filter);
    }

    public void replaceItemFilter(int i, ItemFilter filter) {
        List<ItemFilter> filters = this.getFilters();
        if (filter == null || filters == null || filters.isEmpty() || i > filters.size() || i == -1) {
            return;
        }
        if (filters.get(i).getID() == filter.getID()) {
            if (!filter.getFilters().isEmpty()) {
                this.getFilters().set(i, filter);
            } else {
                this.getFilters().remove(i);
            }
        }
    }

    public void resetClientStackFilter() {
        List<ItemFilter> filters;
        this.clientStackFilter = new ItemStackFilter();
        if (this.editStack != -1 && this.editStack < (filters = this.getFilters()).size() && filters.get(this.editStack) != null) {
            this.clientStackFilter = (ItemStackFilter)filters.get(this.editStack);
        }
    }

    public void resetClientOreFilter() {
        List<ItemFilter> filters;
        this.clientOreFilter = new OreDictionaryFilter();
        if (this.editOre != -1 && this.editOre < (filters = this.getFilters()).size() && filters.get(this.editOre) != null) {
            this.clientStackFilter = (ItemStackFilter)filters.get(this.editOre);
        }
    }

    public boolean canConnect(TileEntity te, ForgeDirection dir) {
        return (Integer)this.sideConfigs[dir.ordinal()].getObject() != 0;
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        int l;
        super.readData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.PACKET || type == NBTHelper.SyncType.DROP) {
            for (l = 0; l < 6; ++l) {
                this.whitelist[l] = NBTHelper.readNBTObjectList((String)("white" + l), (NBTTagCompound)nbt, (RegistryHelper)Logistics.itemFilters);
                this.blacklist[l] = NBTHelper.readNBTObjectList((String)("black" + l), (NBTTagCompound)nbt, (RegistryHelper)Logistics.itemFilters);
            }
        }
        if (type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.SYNC) {
            NBTTagList sideList = nbt.func_150295_c("Sides", 10);
            for (int i = 0; i < 6; ++i) {
                NBTTagCompound compound = sideList.func_150305_b(i);
                this.sideConfigs[i].readFromNBT(compound, type);
            }
        }
        if (type == NBTHelper.SyncType.SPECIAL) {
            for (l = 0; l < 6; ++l) {
                NBTHelper.readSyncedNBTObjectList((String)("white" + l), (NBTTagCompound)nbt, (NBTRegistryHelper)Logistics.itemFilters, this.whitelist[l]);
                NBTHelper.readSyncedNBTObjectList((String)("black" + l), (NBTTagCompound)nbt, (NBTRegistryHelper)Logistics.itemFilters, this.blacklist[l]);
            }
        }
    }

    public void writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        int l;
        super.writeData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.PACKET || type == NBTHelper.SyncType.DROP) {
            for (l = 0; l < 6; ++l) {
                NBTHelper.writeNBTObjectList((String)("white" + l), (NBTTagCompound)nbt, this.whitelist[l]);
                NBTHelper.writeNBTObjectList((String)("black" + l), (NBTTagCompound)nbt, this.blacklist[l]);
            }
        }
        if (type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.SYNC) {
            NBTTagList sideList = new NBTTagList();
            for (int i = 0; i < 6; ++i) {
                NBTTagCompound compound = new NBTTagCompound();
                this.sideConfigs[i].writeToNBT(compound, type);
                sideList.func_74742_a((NBTBase)compound);
            }
            nbt.func_74782_a("Sides", (NBTBase)sideList);
        }
        if (type == NBTHelper.SyncType.SPECIAL) {
            for (l = 0; l < 6; ++l) {
                NBTHelper.writeSyncedNBTObjectList((String)("white" + l), (NBTTagCompound)nbt, (NBTRegistryHelper)Logistics.itemFilters, this.whitelist[l], this.lastWhitelist[l]);
                NBTHelper.writeSyncedNBTObjectList((String)("black" + l), (NBTTagCompound)nbt, (NBTRegistryHelper)Logistics.itemFilters, this.blacklist[l], this.lastBlacklist[l]);
            }
        }
    }

    public void addSyncParts(List<ISyncPart> parts) {
        super.addSyncParts(parts);
        parts.addAll(Lists.newArrayList((Object[])new SyncTagType.INT[]{this.listType, this.side, this.filterPos}));
    }

    public int[] func_94128_d(int side) {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    }

    public boolean func_102007_a(int slot, ItemStack item, int side) {
        return side != -1 ? (Integer)this.sideConfigs[side].getObject() == 1 && ItemRouterHandler.matchesFilters(item, this.whitelist[side], this.blacklist[side]) : true;
    }

    public boolean func_102008_b(int slot, ItemStack item, int side) {
        return (Integer)this.sideConfigs[side].getObject() == 2 && ItemRouterHandler.matchesFilters(item, this.whitelist[side], this.blacklist[side]);
    }

    public static boolean matchesFilters(ItemStack stack, List<ItemFilter> whitelist, List<ItemFilter> blacklist) {
        if (stack == null) {
            return false;
        }
        if (blacklist != null && !blacklist.isEmpty()) {
            for (ItemFilter filter : blacklist) {
                if (filter == null || !filter.matchesFilter(stack)) continue;
                return false;
            }
        }
        if (whitelist == null || whitelist.isEmpty()) {
            return true;
        }
        for (ItemFilter filter : whitelist) {
            if (filter == null || !filter.matchesFilter(stack)) continue;
            return true;
        }
        return false;
    }

    public void writePacket(ByteBuf buf, int id) {
        switch (id) {
            case -2: {
                this.writePacket(buf, 9);
                this.clientOreFilter.writeToBuf(buf);
                break;
            }
            case -1: {
                this.writePacket(buf, 9);
                this.clientStackFilter.writeToBuf(buf);
                break;
            }
            case 0: {
                if ((Integer)this.side.getObject() + 1 < 6) {
                    this.side.increaseBy(1);
                } else {
                    this.side.setObject((Object)0);
                }
                buf.writeInt(((Integer)this.side.getObject()).intValue());
                break;
            }
            case 1: {
                if ((Integer)this.sideConfigs[(Integer)this.side.getObject()].getObject() < 2) {
                    this.sideConfigs[(Integer)this.side.getObject()].increaseBy(1);
                } else {
                    this.sideConfigs[(Integer)this.side.getObject()].setObject((Object)0);
                }
                buf.writeInt(((Integer)this.sideConfigs[(Integer)this.side.getObject()].getObject()).intValue());
                break;
            }
            case 2: {
                if ((Integer)this.listType.getObject() == 0) {
                    this.listType.setObject((Object)1);
                } else {
                    this.listType.setObject((Object)0);
                }
                buf.writeInt(((Integer)this.listType.getObject()).intValue());
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                boolean clicked = false;
                if ((Integer)this.listType.getObject() == 0 && this.clientClick != -1) {
                    if (this.clientClick < this.whitelist[(Integer)this.side.getObject()].size() && this.whitelist[(Integer)this.side.getObject()].get(this.clientClick) != null) {
                        buf.writeInt(this.clientClick);
                        clicked = true;
                    }
                } else if ((Integer)this.listType.getObject() == 1 && this.clientClick != -1 && this.clientClick < this.blacklist[(Integer)this.side.getObject()].size() && this.blacklist[(Integer)this.side.getObject()].get(this.clientClick) != null) {
                    buf.writeInt(this.clientClick);
                    clicked = true;
                }
                if (!clicked) {
                    buf.writeInt(-1);
                }
                this.filterPos.setObject((Object)this.clientClick);
                break;
            }
            case 9: {
                this.writePacket(buf, 8);
                buf.writeInt(this.editStack);
                buf.writeInt(this.editOre);
            }
        }
    }

    public void readPacket(ByteBuf buf, int id) {
        switch (id) {
            case -2: {
                this.readPacket(buf, 9);
                this.clientOreFilter = new OreDictionaryFilter();
                this.clientOreFilter.readFromBuf(buf);
                if (this.clientOreFilter != null) {
                    if (this.editOre == -1 && this.clientOreFilter.oreDict != null && !this.clientOreFilter.oreDict.isEmpty()) {
                        this.addItemFilter(this.clientOreFilter);
                    } else {
                        this.replaceItemFilter(this.editOre, this.clientOreFilter);
                    }
                }
                this.editOre = -1;
                break;
            }
            case -1: {
                this.readPacket(buf, 9);
                this.clientStackFilter = new ItemStackFilter();
                this.clientStackFilter.readFromBuf(buf);
                if (this.clientStackFilter != null) {
                    if (this.editStack == -1 && this.clientStackFilter.filters[0] != null) {
                        this.addItemFilter(this.clientStackFilter);
                    } else {
                        this.replaceItemFilter(this.editStack, this.clientStackFilter);
                    }
                }
                this.editStack = -1;
                break;
            }
            case 0: {
                this.side.setObject((Object)buf.readInt());
                this.filterPos.setObject((Object)-1);
                break;
            }
            case 1: {
                this.sideConfigs[(Integer)this.side.getObject()].setObject((Object)buf.readInt());
                SonarCore.sendFullSyncAround((TileEntity)this.tile, (int)64);
                break;
            }
            case 2: {
                this.listType.setObject((Object)buf.readInt());
                this.filterPos.setObject((Object)-1);
                break;
            }
            case 5: {
                if ((Integer)this.filterPos.getObject() == -1 || (Integer)this.filterPos.getObject() == 0) break;
                if ((Integer)this.listType.getObject() == 0) {
                    if ((Integer)this.filterPos.getObject() - 1 >= this.whitelist[(Integer)this.side.getObject()].size()) break;
                    Collections.swap(this.whitelist[(Integer)this.side.getObject()], (int)((Integer)this.filterPos.getObject()), (Integer)this.filterPos.getObject() - 1);
                    this.filterPos.setObject((Object)((Integer)this.filterPos.getObject() - 1));
                    break;
                }
                if ((Integer)this.filterPos.getObject() - 1 >= this.blacklist[(Integer)this.side.getObject()].size()) break;
                Collections.swap(this.whitelist[(Integer)this.side.getObject()], (int)((Integer)this.filterPos.getObject()), (Integer)this.filterPos.getObject() - 1);
                this.filterPos.setObject((Object)((Integer)this.filterPos.getObject() - 1));
                break;
            }
            case 6: {
                if ((Integer)this.filterPos.getObject() == -1) break;
                if ((Integer)this.listType.getObject() == 0) {
                    if ((Integer)this.filterPos.getObject() + 1 >= this.whitelist[(Integer)this.side.getObject()].size()) break;
                    Collections.swap(this.whitelist[(Integer)this.side.getObject()], (int)((Integer)this.filterPos.getObject()), (Integer)this.filterPos.getObject() + 1);
                    this.filterPos.setObject((Object)((Integer)this.filterPos.getObject() + 1));
                    break;
                }
                if ((Integer)this.filterPos.getObject() + 1 >= this.blacklist[(Integer)this.side.getObject()].size()) break;
                Collections.swap(this.blacklist[(Integer)this.side.getObject()], (int)((Integer)this.filterPos.getObject()), (Integer)this.filterPos.getObject() + 1);
                this.filterPos.setObject((Object)((Integer)this.filterPos.getObject() + 1));
                break;
            }
            case 7: {
                if ((Integer)this.filterPos.getObject() == -1) break;
                if ((Integer)this.listType.getObject() == 0) {
                    if ((Integer)this.filterPos.getObject() < this.whitelist[(Integer)this.side.getObject()].size()) {
                        this.whitelist[(Integer)this.side.getObject()].remove(this.whitelist[(Integer)this.side.getObject()].get((Integer)this.filterPos.getObject()));
                    }
                } else if ((Integer)this.filterPos.getObject() < this.blacklist[(Integer)this.side.getObject()].size()) {
                    this.blacklist[(Integer)this.side.getObject()].remove(this.blacklist[(Integer)this.side.getObject()].get((Integer)this.filterPos.getObject()));
                }
                this.filterPos.setObject((Object)-1);
                break;
            }
            case 8: {
                this.filterPos.setObject((Object)buf.readInt());
                break;
            }
            case 9: {
                this.readPacket(buf, 8);
                this.editStack = buf.readInt();
                this.editOre = buf.readInt();
            }
        }
    }

    public static class Filter
    implements InventoryHelper.IInventoryFilter {
        public List<ItemFilter> whitelist;
        public List<ItemFilter> blacklist;

        public Filter(List<ItemFilter> whitelist, List<ItemFilter> blacklist) {
            this.whitelist = whitelist;
        }

        public boolean allowed(ItemStack stack) {
            return ItemRouterHandler.matchesFilters(stack, this.whitelist, this.blacklist);
        }
    }
}

