/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.common.handlers;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.api.BlockCoords;
import sonar.core.api.StoredItemStack;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.NBTHelper;
import sonar.core.integration.fmp.FMPHelper;
import sonar.core.integration.fmp.handlers.InventoryTileHandler;
import sonar.core.network.sync.ISyncPart;
import sonar.core.network.sync.SyncTagType;
import sonar.core.network.utils.IByteBufTile;
import sonar.logistics.api.LogisticsAPI;
import sonar.logistics.api.cache.INetworkCache;
import sonar.logistics.api.info.ILogicInfo;
import sonar.logistics.api.info.LogicInfo;
import sonar.logistics.api.wrappers.ItemWrapper;
import sonar.logistics.helpers.ItemHelper;
import sonar.logistics.info.types.InventoryInfo;
import sonar.logistics.info.types.ProgressInfo;
import sonar.logistics.info.types.StoredStackInfo;

public class InventoryReaderHandler
extends InventoryTileHandler
implements IByteBufTile {
    public BlockCoords coords;
    public ItemWrapper.StorageItems cachedItems = ItemWrapper.StorageItems.EMPTY.copy();
    public boolean lastSync = false;
    public ItemStack current;
    public SyncTagType.INT setting = (SyncTagType.INT)new SyncTagType.INT(1).addSyncType(NBTHelper.SyncType.SPECIAL);
    public SyncTagType.INT targetSlot = (SyncTagType.INT)new SyncTagType.INT(2).addSyncType(NBTHelper.SyncType.SPECIAL);
    public SyncTagType.INT posSlot = (SyncTagType.INT)new SyncTagType.INT(3).addSyncType(NBTHelper.SyncType.SPECIAL);
    public SyncTagType.INT sortingOrder = (SyncTagType.INT)new SyncTagType.INT(4).addSyncType(NBTHelper.SyncType.SPECIAL);
    public SyncTagType.INT sortingType = (SyncTagType.INT)new SyncTagType.INT(5).addSyncType(NBTHelper.SyncType.SPECIAL);
    public int cacheID = -1;

    public InventoryReaderHandler(boolean isMultipart) {
        super(isMultipart, null);
        this.slots = new ItemStack[1];
    }

    public void update(TileEntity te) {
        if (te.func_145831_w().field_72995_K) {
            return;
        }
        INetworkCache cache = this.getNetwork(te);
        this.cacheID = cache.getNetworkID();
        this.cachedItems = LogisticsAPI.getItemHelper().getItems(cache).copy();
    }

    public INetworkCache getNetwork(TileEntity te) {
        return LogisticsAPI.getCableHelper().getNetwork(te, ForgeDirection.getOrientation((int)FMPHelper.getMeta((TileEntity)te)).getOpposite());
    }

    public boolean canConnect(TileEntity te, ForgeDirection dir) {
        return dir.equals((Object)ForgeDirection.getOrientation((int)FMPHelper.getMeta((TileEntity)te))) || dir.equals((Object)ForgeDirection.getOrientation((int)FMPHelper.getMeta((TileEntity)te)).getOpposite());
    }

    public ILogicInfo currentInfo(TileEntity te) {
        ArrayList stacks = (ArrayList)this.cachedItems.items.clone();
        switch ((Integer)this.setting.getObject()) {
            case 0: {
                if (this.slots[0] == null) break;
                if (stacks != null) {
                    for (StoredItemStack stack : stacks) {
                        if (!stack.equalStack(this.slots[0])) continue;
                        return StoredStackInfo.createInfo(stack, this.cacheID);
                    }
                }
                return StoredStackInfo.createInfo(new StoredItemStack(this.slots[0], 0L), this.cacheID);
            }
            case 1: {
                StoredItemStack stack = LogisticsAPI.getItemHelper().getStack(LogisticsAPI.getCableHelper().getNetwork(te, ForgeDirection.getOrientation((int)FMPHelper.getMeta((TileEntity)te)).getOpposite()), (Integer)this.targetSlot.getObject());
                if (stack != null) {
                    return StoredStackInfo.createInfo(stack, this.cacheID);
                }
                return new LogicInfo(-1, "ITEMREND", " ", (Object)" ");
            }
            case 2: {
                if ((Integer)this.posSlot.getObject() >= stacks.size()) break;
                return StoredStackInfo.createInfo((StoredItemStack)stacks.get((Integer)this.posSlot.getObject()), this.cacheID);
            }
            case 3: {
                if (stacks == null) break;
                return InventoryInfo.createInfo(this.cachedItems.copy(), this.cacheID, (Integer)this.sortingType.getObject(), (Integer)this.sortingOrder.getObject());
            }
            case 4: {
                return new ProgressInfo(this.cachedItems.sizing.getStoredFluids(), this.cachedItems.sizing.getMaxFluids(), FontHelper.formatStackSize((long)this.cachedItems.sizing.getStoredFluids()) + " / " + FontHelper.formatStackSize((long)this.cachedItems.sizing.getMaxFluids()));
            }
        }
        return new LogicInfo(-1, "ITEMREND", " ", (Object)"NO DATA");
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        this.setting.readFromNBT(nbt, type);
        this.targetSlot.readFromNBT(nbt, type);
        this.posSlot.readFromNBT(nbt, type);
        if (type == NBTHelper.SyncType.SAVE && nbt.func_74764_b("coords")) {
            this.coords = nbt.func_74775_l("coords").func_74767_n("hasCoords") ? BlockCoords.readFromNBT((NBTTagCompound)nbt.func_74775_l("coords")) : null;
        }
        if (type == NBTHelper.SyncType.SPECIAL || type == NBTHelper.SyncType.SYNC) {
            ItemHelper.readStorageToNBT(nbt, this.cachedItems.items, type);
            ItemHelper.sortItemList(this.cachedItems.items, ItemWrapper.SortingDirection.values()[(Integer)this.sortingOrder.getObject()], ItemWrapper.SortingType.values()[(Integer)this.sortingType.getObject()]);
        }
    }

    public void writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE) {
            NBTTagCompound coordTag = new NBTTagCompound();
            if (this.coords != null) {
                BlockCoords.writeToNBT((NBTTagCompound)coordTag, (BlockCoords)this.coords);
                coordTag.func_74757_a("hasCoords", true);
            } else {
                coordTag.func_74757_a("hasCoords", false);
            }
            nbt.func_74782_a("coords", (NBTBase)coordTag);
        }
        if (type == NBTHelper.SyncType.SPECIAL || type == NBTHelper.SyncType.SYNC) {
            this.lastSync = ItemHelper.writeStorageToNBT(nbt, this.lastSync, this.cachedItems, type);
        }
    }

    public void addSyncParts(List<ISyncPart> parts) {
        super.addSyncParts(parts);
        parts.addAll(Lists.newArrayList((Object[])new SyncTagType.INT[]{this.setting, this.targetSlot, this.posSlot, this.sortingOrder, this.sortingType}));
    }

    public void writePacket(ByteBuf buf, int id) {
        switch (id) {
            case 1: {
                this.targetSlot.writeToBuf(buf);
                break;
            }
            case 2: {
                this.posSlot.writeToBuf(buf);
                break;
            }
            case 3: {
                this.sortingOrder.writeToBuf(buf);
                break;
            }
            case 4: {
                this.sortingType.writeToBuf(buf);
            }
        }
    }

    public void readPacket(ByteBuf buf, int id) {
        switch (id) {
            case 0: {
                if ((Integer)this.setting.getObject() == 4) {
                    this.setting.setObject((Object)0);
                    break;
                }
                this.setting.increaseBy(1);
                break;
            }
            case 1: {
                this.targetSlot.readFromBuf(buf);
                break;
            }
            case 2: {
                this.posSlot.readFromBuf(buf);
                break;
            }
            case 3: {
                this.sortingOrder.readFromBuf(buf);
                break;
            }
            case 4: {
                this.sortingType.readFromBuf(buf);
            }
        }
    }
}

