/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.common.handlers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.helpers.NBTHelper;
import sonar.core.integration.IWailaInfo;
import sonar.core.integration.fmp.FMPHelper;
import sonar.core.integration.fmp.handlers.TileHandler;
import sonar.core.network.sync.ISyncPart;
import sonar.core.network.sync.SyncGeneric;
import sonar.core.utils.IBufManager;
import sonar.core.utils.IBufObject;
import sonar.logistics.Logistics;
import sonar.logistics.api.LogisticsAPI;
import sonar.logistics.api.cache.CacheTypes;
import sonar.logistics.api.cache.INetworkCache;
import sonar.logistics.api.connecting.IEntityNode;
import sonar.logistics.api.info.ILogicInfo;
import sonar.logistics.api.info.LogicInfo;
import sonar.logistics.helpers.InfoHelper;

public class InfoReaderHandler
extends TileHandler
implements IWailaInfo {
    public ArrayList<ILogicInfo> cachedInfo = new ArrayList();
    public ArrayList<ILogicInfo> lastInfo = new ArrayList();
    private int primaryUpdate = 0;
    private int secondaryUpdate = 0;
    public SyncGeneric<ILogicInfo> primaryInfo = (SyncGeneric)new SyncGeneric((IBufManager)Logistics.infoTypes, 0).addSyncType(NBTHelper.SyncType.SPECIAL);
    public SyncGeneric<ILogicInfo> secondaryInfo = (SyncGeneric)new SyncGeneric((IBufManager)Logistics.infoTypes, 1).addSyncType(NBTHelper.SyncType.SPECIAL);
    public boolean emptyPrimary = false;
    public boolean emptySecondary = false;

    public InfoReaderHandler(boolean isMultipart, TileEntity tile) {
        super(isMultipart, tile);
    }

    public void update(TileEntity te) {
        if (te.func_145831_w().field_72995_K) {
            return;
        }
        INetworkCache network = LogisticsAPI.getCableHelper().getNetwork(te, ForgeDirection.getOrientation((int)FMPHelper.getMeta((TileEntity)te)).getOpposite());
        this.lastInfo = (ArrayList)this.cachedInfo.clone();
        this.cachedInfo = (ArrayList)LogisticsAPI.getInfoHelper().getTileInfo(network).clone();
        boolean primary = false;
        boolean secondary = false;
        if (this.primaryInfo.getObject() == null || ((ILogicInfo)this.primaryInfo.getObject()).updateTicks() == 1 || this.primaryUpdate >= ((ILogicInfo)this.primaryInfo.getObject()).updateTicks()) {
            primary = true;
            this.primaryUpdate = 0;
        }
        if (this.secondaryInfo.getObject() == null || ((ILogicInfo)this.secondaryInfo.getObject()).updateTicks() == 1 || this.secondaryUpdate >= ((ILogicInfo)this.secondaryInfo.getObject()).updateTicks()) {
            secondary = true;
            this.secondaryUpdate = 0;
        }
        if (primary || secondary) {
            this.updateData(te, ForgeDirection.getOrientation((int)FMPHelper.getMeta((TileEntity)te)), primary, secondary);
        }
        ++this.primaryUpdate;
        ++this.secondaryUpdate;
    }

    public void updateData(TileEntity te, ForgeDirection dir, boolean primary, boolean secondary) {
        INetworkCache network = LogisticsAPI.getCableHelper().getNetwork(te, dir.getOpposite());
        if (!network.getExternalBlocks(true).isEmpty()) {
            if (primary) {
                this.setData(te, LogisticsAPI.getInfoHelper().getLatestTileInfo((ILogicInfo)this.primaryInfo.getObject(), network), true);
            }
            if (secondary) {
                this.setData(te, LogisticsAPI.getInfoHelper().getLatestTileInfo((ILogicInfo)this.secondaryInfo.getObject(), network), false);
            }
        } else {
            TileEntity target = network.getFirstTileEntity(CacheTypes.ENTITY_NODES);
            if (target != null && target instanceof IEntityNode) {
                ILogicInfo info;
                if (primary) {
                    info = LogisticsAPI.getInfoHelper().getLatestEntityInfo((ILogicInfo)this.primaryInfo.getObject(), (IEntityNode)target);
                    this.setData(te, info, true);
                }
                if (secondary) {
                    info = LogisticsAPI.getInfoHelper().getLatestEntityInfo((ILogicInfo)this.secondaryInfo.getObject(), (IEntityNode)target);
                    this.setData(te, info, false);
                }
            }
        }
    }

    public boolean canConnect(TileEntity te, ForgeDirection dir) {
        return dir.equals((Object)ForgeDirection.getOrientation((int)FMPHelper.getMeta((TileEntity)te))) || dir.equals((Object)ForgeDirection.getOrientation((int)FMPHelper.getMeta((TileEntity)te)).getOpposite());
    }

    public ILogicInfo currentInfo(TileEntity te) {
        if (this.secondaryInfo.getObject() == null || !te.func_145831_w().func_72864_z(te.field_145851_c, te.field_145848_d, te.field_145849_e)) {
            if (this.primaryInfo.getObject() == null || this.emptyPrimary) {
                return new LogicInfo(-1, "", "", (Object)"NO DATA");
            }
            return (ILogicInfo)this.primaryInfo.getObject();
        }
        if (this.secondaryInfo.getObject() == null || this.emptySecondary) {
            return new LogicInfo(-1, "", "", (Object)"NO DATA");
        }
        return (ILogicInfo)this.secondaryInfo.getObject();
    }

    public ILogicInfo getSecondaryInfo(TileEntity te) {
        if (this.primaryInfo.getObject() == null || !te.func_145831_w().func_72864_z(te.field_145851_c, te.field_145848_d, te.field_145849_e)) {
            if (this.secondaryInfo.getObject() == null || this.emptySecondary) {
                return new LogicInfo(-1, "", "", (Object)"NO DATA");
            }
            return (ILogicInfo)this.secondaryInfo.getObject();
        }
        if (this.primaryInfo.getObject() == null || this.emptyPrimary) {
            return new LogicInfo(-1, "", "", (Object)"NO DATA");
        }
        return (ILogicInfo)this.primaryInfo.getObject();
    }

    public void setData(TileEntity te, ILogicInfo info, boolean primary) {
        if (info != null) {
            if (primary) {
                this.primaryInfo.setObject((IBufObject)info);
                this.emptyPrimary = false;
            } else {
                this.secondaryInfo.setObject((IBufObject)info);
                this.emptySecondary = false;
            }
        } else if (primary && this.primaryInfo.getObject() != null) {
            this.emptyPrimary = true;
        } else if (!primary && this.secondaryInfo.getObject() != null) {
            this.emptySecondary = true;
        }
    }

    public void sendAvailableData(TileEntity te, EntityPlayer player) {
        if (player == null || player instanceof EntityPlayerMP) {
            // empty if block
        }
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE) {
            this.emptyPrimary = nbt.func_74767_n("emptyP");
            this.emptySecondary = nbt.func_74767_n("emptyS");
        }
        if (type == NBTHelper.SyncType.SPECIAL || type == NBTHelper.SyncType.SYNC) {
            InfoHelper.readStorageToNBT(nbt, this.cachedInfo, type);
        }
        if (type == NBTHelper.SyncType.SPECIAL) {
            // empty if block
        }
    }

    public void writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE) {
            nbt.func_74757_a("emptyP", this.emptyPrimary);
            nbt.func_74757_a("emptyS", this.emptySecondary);
        }
        if (type == NBTHelper.SyncType.SPECIAL || type == NBTHelper.SyncType.SYNC) {
            InfoHelper.writeInfoToNBT(nbt, this.cachedInfo, this.lastInfo, type);
        }
        if (type == NBTHelper.SyncType.SPECIAL) {
            // empty if block
        }
    }

    public void addSyncParts(List<ISyncPart> parts) {
        super.addSyncParts(parts);
        parts.addAll(Lists.newArrayList((Object[])new SyncGeneric[]{this.primaryInfo, this.secondaryInfo}));
    }

    public List<String> getWailaInfo(List<String> currenttip) {
        return currenttip;
    }
}

