/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.common.handlers;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import sonar.core.api.BlockCoords;
import sonar.core.api.StoredFluidStack;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.NBTHelper;
import sonar.core.integration.fmp.FMPHelper;
import sonar.core.integration.fmp.handlers.TileHandler;
import sonar.core.network.sync.ISyncPart;
import sonar.core.network.sync.SyncTagType;
import sonar.core.network.utils.IByteBufTile;
import sonar.logistics.api.LogisticsAPI;
import sonar.logistics.api.cache.INetworkCache;
import sonar.logistics.api.info.ILogicInfo;
import sonar.logistics.api.info.LogicInfo;
import sonar.logistics.api.wrappers.FluidWrapper;
import sonar.logistics.api.wrappers.ItemWrapper;
import sonar.logistics.helpers.FluidHelper;
import sonar.logistics.info.types.FluidInventoryInfo;
import sonar.logistics.info.types.FluidStackInfo;
import sonar.logistics.info.types.ProgressInfo;

public class FluidReaderHandler
extends TileHandler
implements IByteBufTile {
    public BlockCoords coords;
    public FluidWrapper.StorageFluids cachedFluids = FluidWrapper.StorageFluids.EMPTY;
    public boolean lastSync = false;
    public FluidStack current;
    public SyncTagType.INT setting = (SyncTagType.INT)new SyncTagType.INT(1).addSyncType(NBTHelper.SyncType.SPECIAL);
    public SyncTagType.INT posSlot = (SyncTagType.INT)new SyncTagType.INT(2).addSyncType(NBTHelper.SyncType.SPECIAL);
    public SyncTagType.INT sortingOrder = (SyncTagType.INT)new SyncTagType.INT(3).addSyncType(NBTHelper.SyncType.SPECIAL);
    public SyncTagType.INT sortingType = (SyncTagType.INT)new SyncTagType.INT(4).addSyncType(NBTHelper.SyncType.SPECIAL);
    public int cacheID = -1;

    public FluidReaderHandler(boolean isMultipart, TileEntity tile) {
        super(isMultipart, tile);
    }

    public void update(TileEntity te) {
        if (te.func_145831_w().field_72995_K) {
            return;
        }
        INetworkCache network = LogisticsAPI.getCableHelper().getNetwork(te, ForgeDirection.getOrientation((int)FMPHelper.getMeta((TileEntity)te)).getOpposite());
        this.cacheID = network.getNetworkID();
        this.cachedFluids = LogisticsAPI.getFluidHelper().getFluids(network).copy();
    }

    public boolean canConnect(TileEntity te, ForgeDirection dir) {
        return dir.equals((Object)ForgeDirection.getOrientation((int)FMPHelper.getMeta((TileEntity)te))) || dir.equals((Object)ForgeDirection.getOrientation((int)FMPHelper.getMeta((TileEntity)te)).getOpposite());
    }

    public void setCoords(BlockCoords coords) {
        if (!BlockCoords.equalCoords((BlockCoords)this.coords, (BlockCoords)coords)) {
            this.coords = coords;
        }
    }

    public ILogicInfo currentInfo(TileEntity te) {
        ArrayList stacks = (ArrayList)this.cachedFluids.fluids.clone();
        switch ((Integer)this.setting.getObject()) {
            case 0: {
                if (this.current == null) break;
                for (StoredFluidStack stack : stacks) {
                    if (!stack.equalStack(this.current)) continue;
                    return FluidStackInfo.createInfo(stack, this.cacheID);
                }
                return FluidStackInfo.createInfo(new StoredFluidStack(this.current, 0L), this.cacheID);
            }
            case 1: {
                if ((Integer)this.posSlot.getObject() >= stacks.size()) break;
                return FluidStackInfo.createInfo((StoredFluidStack)stacks.get((Integer)this.posSlot.getObject()), this.cacheID);
            }
            case 2: {
                return FluidInventoryInfo.createInfo(this.cachedFluids, this.cacheID, (Integer)this.sortingType.getObject(), (Integer)this.sortingOrder.getObject());
            }
            case 3: {
                return new ProgressInfo(this.cachedFluids.sizing.getStoredFluids(), this.cachedFluids.sizing.getMaxFluids(), FontHelper.formatFluidSize((long)this.cachedFluids.sizing.getStoredFluids()) + " / " + FontHelper.formatFluidSize((long)this.cachedFluids.sizing.getMaxFluids()));
            }
        }
        return new LogicInfo(-1, "ITEMREND", " ", (Object)"NO DATA");
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        this.setting.readFromNBT(nbt, type);
        this.posSlot.readFromNBT(nbt, type);
        if (nbt.func_74764_b("FluidName")) {
            this.current = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt);
        }
        if (type == NBTHelper.SyncType.SAVE && nbt.func_74764_b("coords")) {
            this.coords = nbt.func_74775_l("coords").func_74767_n("hasCoords") ? BlockCoords.readFromNBT((NBTTagCompound)nbt.func_74775_l("coords")) : null;
        }
        if (type == NBTHelper.SyncType.SPECIAL || type == NBTHelper.SyncType.SYNC) {
            FluidHelper.readStorageToNBT(nbt, this.cachedFluids.fluids, type);
            FluidHelper.sortFluidList(this.cachedFluids.fluids, ItemWrapper.SortingDirection.values()[(Integer)this.sortingOrder.getObject()], ItemWrapper.SortingType.values()[(Integer)this.sortingType.getObject()]);
        }
    }

    public void writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        this.setting.writeToNBT(nbt, type);
        this.posSlot.writeToNBT(nbt, type);
        if (this.current != null) {
            this.current.writeToNBT(nbt);
        }
        if (type == NBTHelper.SyncType.SPECIAL || type == NBTHelper.SyncType.SYNC) {
            this.lastSync = FluidHelper.writeStorageToNBT(nbt, this.lastSync, this.cachedFluids, type);
        }
    }

    public void addSyncParts(List<ISyncPart> parts) {
        super.addSyncParts(parts);
        parts.addAll(Lists.newArrayList((Object[])new SyncTagType.INT[]{this.setting, this.posSlot, this.sortingOrder, this.sortingType}));
    }

    public void writePacket(ByteBuf buf, int id) {
        if (id != 0) {
            if (id == 1) {
                this.posSlot.writeToBuf(buf);
            } else if (id == 3) {
                this.sortingOrder.writeToBuf(buf);
            } else if (id == 4) {
                this.sortingType.writeToBuf(buf);
            }
        }
    }

    public void readPacket(ByteBuf buf, int id) {
        if (id == 0) {
            if ((Integer)this.setting.getObject() == 3) {
                this.setting.setObject((Object)0);
            } else {
                this.setting.increaseBy(1);
            }
        } else if (id == 1) {
            this.posSlot.readFromBuf(buf);
        } else if (id == 3) {
            this.sortingOrder.readFromBuf(buf);
        } else if (id == 4) {
            this.sortingType.readFromBuf(buf);
        }
    }
}

