/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.common.handlers;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.helpers.NBTHelper;
import sonar.core.integration.fmp.FMPHelper;
import sonar.core.integration.fmp.handlers.TileHandler;
import sonar.core.network.sync.SyncGeneric;
import sonar.core.utils.IBufManager;
import sonar.logistics.Logistics;
import sonar.logistics.api.LogisticsAPI;
import sonar.logistics.api.cache.INetworkCache;
import sonar.logistics.api.info.ILogicInfo;
import sonar.logistics.helpers.InfoHelper;
import sonar.logistics.info.types.StoredEnergyInfo;

public class EnergyReaderHandler
extends TileHandler {
    public List<StoredEnergyInfo> stacks;
    public List<StoredEnergyInfo> lastStacks;
    public SyncGeneric<StoredEnergyInfo> primaryInfo = new SyncGeneric((IBufManager)Logistics.infoTypes, 0);

    public EnergyReaderHandler(boolean isMultipart, TileEntity tile) {
        super(isMultipart, tile);
    }

    public void update(TileEntity te) {
        if (te.func_145831_w().field_72995_K) {
            return;
        }
        INetworkCache network = LogisticsAPI.getCableHelper().getNetwork(te, ForgeDirection.getOrientation((int)FMPHelper.getMeta((TileEntity)te)).getOpposite());
        this.stacks = LogisticsAPI.getEnergyHelper().getEnergyList(network);
    }

    public boolean canConnect(TileEntity te, ForgeDirection dir) {
        return dir.equals((Object)ForgeDirection.getOrientation((int)FMPHelper.getMeta((TileEntity)te))) || dir.equals((Object)ForgeDirection.getOrientation((int)FMPHelper.getMeta((TileEntity)te)).getOpposite());
    }

    public ILogicInfo currentInfo(TileEntity te) {
        if (this.primaryInfo.getObject() != null && ((StoredEnergyInfo)this.primaryInfo.getObject()).coords != null && this.stacks != null) {
            for (StoredEnergyInfo stack : this.stacks) {
                if (stack == null || stack.coords == null || !stack.coords.equals(((StoredEnergyInfo)this.primaryInfo.getObject()).coords)) continue;
                return stack;
            }
        }
        return InfoHelper.empty;
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        NBTTagCompound compound;
        int i;
        NBTTagList list;
        super.readData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.SYNC) {
            this.primaryInfo.readFromNBT(nbt, type);
        }
        if (type == NBTHelper.SyncType.SPECIAL) {
            if (nbt.func_74764_b("null")) {
                this.stacks = new ArrayList<StoredEnergyInfo>();
                return;
            }
            list = nbt.func_150295_c("Stacks", 10);
            if (this.stacks == null) {
                this.stacks = new ArrayList<StoredEnergyInfo>();
            }
            block5: for (i = 0; i < list.func_74745_c(); ++i) {
                compound = list.func_150305_b(i);
                int slot = compound.func_74762_e("Slot");
                boolean set = slot < this.stacks.size();
                switch (compound.func_74771_c("f")) {
                    case 0: {
                        if (set) {
                            this.stacks.set(slot, (StoredEnergyInfo)Logistics.infoTypes.readFromNBT(compound));
                            continue block5;
                        }
                        this.stacks.add(slot, (StoredEnergyInfo)Logistics.infoTypes.readFromNBT(compound));
                        continue block5;
                    }
                    case 1: {
                        this.stacks.get(slot).readUpdate(compound);
                        continue block5;
                    }
                    case 2: {
                        if (set) {
                            this.stacks.set(slot, null);
                            continue block5;
                        }
                        this.stacks.add(slot, null);
                    }
                }
            }
        }
        if (type == NBTHelper.SyncType.SYNC) {
            list = nbt.func_150295_c("StoredStacks", 10);
            this.stacks = new ArrayList<StoredEnergyInfo>();
            for (i = 0; i < list.func_74745_c(); ++i) {
                compound = list.func_150305_b(i);
                this.stacks.add((StoredEnergyInfo)Logistics.infoTypes.readFromNBT(compound));
            }
        }
    }

    public void writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        NBTTagList list;
        super.writeData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.SYNC) {
            this.primaryInfo.writeToNBT(nbt, type);
        }
        if (type == NBTHelper.SyncType.SPECIAL) {
            if (this.stacks == null) {
                this.stacks = new ArrayList<StoredEnergyInfo>();
            }
            if (this.lastStacks == null) {
                this.lastStacks = new ArrayList<StoredEnergyInfo>();
            }
            if (this.stacks.size() <= 0 && this.lastStacks.size() > 0) {
                nbt.func_74757_a("null", true);
                this.lastStacks = new ArrayList<StoredEnergyInfo>();
                return;
            }
            list = new NBTTagList();
            int size = Math.max(this.stacks.size(), this.lastStacks.size());
            for (int i = 0; i < size; ++i) {
                StoredEnergyInfo current = null;
                StoredEnergyInfo last = null;
                if (i < this.stacks.size()) {
                    current = this.stacks.get(i);
                }
                if (i < this.lastStacks.size()) {
                    last = this.lastStacks.get(i);
                }
                NBTTagCompound compound = new NBTTagCompound();
                if (current != null) {
                    if (last != null) {
                        if (!last.equals(current)) {
                            this.lastStacks.set(i, current);
                            NBTTagCompound updateTag = compound;
                            last.writeUpdate(current, updateTag);
                            if (!updateTag.func_82582_d()) {
                                compound.func_74774_a("f", (byte)1);
                                compound = updateTag;
                            }
                        }
                    } else {
                        compound.func_74774_a("f", (byte)0);
                        this.lastStacks.add(i, current);
                        Logistics.infoTypes.writeToNBT(compound, this.stacks.get(i));
                    }
                } else if (last != null) {
                    this.lastStacks.set(i, null);
                    compound.func_74774_a("f", (byte)2);
                }
                if (compound.func_82582_d()) continue;
                compound.func_74768_a("Slot", i);
                list.func_74742_a((NBTBase)compound);
            }
            if (list.func_74745_c() != 0) {
                nbt.func_74782_a("Stacks", (NBTBase)list);
            }
        }
        if (type == NBTHelper.SyncType.SYNC) {
            list = new NBTTagList();
            if (this.stacks == null) {
                this.stacks = new ArrayList<StoredEnergyInfo>();
            }
            for (int i = 0; i < this.stacks.size(); ++i) {
                if (this.stacks.get(i) == null) continue;
                NBTTagCompound compound = new NBTTagCompound();
                Logistics.infoTypes.writeToNBT(compound, this.stacks.get(i));
                list.func_74742_a((NBTBase)compound);
            }
            nbt.func_74782_a("StoredStacks", (NBTBase)list);
        }
    }
}

