/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.common.handlers;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.SonarCore;
import sonar.core.api.BlockCoords;
import sonar.core.helpers.NBTHelper;
import sonar.core.integration.fmp.FMPHelper;
import sonar.core.integration.fmp.handlers.TileHandler;
import sonar.core.network.utils.IByteBufTile;
import sonar.core.utils.BlockInteraction;
import sonar.logistics.Logistics;
import sonar.logistics.api.LogisticsAPI;
import sonar.logistics.api.cache.CacheTypes;
import sonar.logistics.api.cache.INetworkCache;
import sonar.logistics.api.connecting.IInfoEmitter;
import sonar.logistics.api.connecting.IInfoReader;
import sonar.logistics.api.connecting.IInfoScreen;
import sonar.logistics.api.connecting.ILargeDisplay;
import sonar.logistics.api.info.ILogicInfo;
import sonar.logistics.api.render.InfoInteractionHandler;
import sonar.logistics.api.render.ScreenType;
import sonar.logistics.common.handlers.LargeDisplayScreenHandler;
import sonar.logistics.helpers.InfoHelper;

public class DisplayScreenHandler
extends TileHandler
implements IByteBufTile {
    public ILogicInfo[] dInfo = new ILogicInfo[]{InfoHelper.empty, InfoHelper.empty, InfoHelper.empty, InfoHelper.empty};
    public ILogicInfo[] updateDInfo = new ILogicInfo[]{InfoHelper.empty, InfoHelper.empty, InfoHelper.empty, InfoHelper.empty};
    public int updateTicks;
    public int updateTime = 20;
    public long lastClickTime;
    public UUID lastClickUUID;

    public DisplayScreenHandler(boolean isMultipart, TileEntity tile) {
        super(isMultipart, tile);
    }

    public void update(TileEntity te) {
        if (te.func_145831_w().field_72995_K) {
            return;
        }
        this.updateData(te, te, ForgeDirection.getOrientation((int)FMPHelper.getMeta((TileEntity)te)));
        this.updateTicks = this.updateTicks == this.updateTime ? 0 : ++this.updateTicks;
    }

    public void updateData(TileEntity te, TileEntity packetTile, ForgeDirection dir) {
        INetworkCache network = LogisticsAPI.getCableHelper().getNetwork(te, ForgeDirection.getOrientation((int)FMPHelper.getMeta((TileEntity)te)).getOpposite());
        if (network == null) {
            return;
        }
        ArrayList<BlockCoords> emitters = network.getConnections(CacheTypes.EMITTER, true);
        for (int i = 0; i < 4 && i < emitters.size(); ++i) {
            ILogicInfo current;
            block7: {
                Object target;
                block5: {
                    ILogicInfo[] currentInfo;
                    block6: {
                        target = FMPHelper.checkObject((Object)emitters.get(i).getTileEntity());
                        if (target == null) {
                            this.syncNewInfo(packetTile, i, null);
                            continue;
                        }
                        current = null;
                        if (!(target instanceof IInfoReader)) break block5;
                        IInfoReader infoReader = (IInfoReader)target;
                        currentInfo = infoReader.getSelectedInfo();
                        if (currentInfo[0] == null || currentInfo[1] == null) break block6;
                        current = LogisticsAPI.getInfoHelper().combineData(currentInfo[0], currentInfo[1]);
                        break block7;
                    }
                    if (currentInfo[0] == null) break block7;
                    current = currentInfo[0];
                    break block7;
                }
                if (target instanceof IInfoEmitter) {
                    IInfoEmitter infoNode = (IInfoEmitter)target;
                    current = infoNode.currentInfo();
                } else {
                    this.syncNewInfo(packetTile, i, null);
                    continue;
                }
            }
            this.syncNewInfo(packetTile, i, current);
        }
    }

    public void syncNewInfo(TileEntity te, int i, ILogicInfo current) {
        NBTHelper.SyncType type;
        DisplayScreenHandler handler = (DisplayScreenHandler)FMPHelper.getHandler((Object)te);
        if (current == null) {
            current = InfoHelper.empty;
        }
        handler.updateDInfo[i] = current;
        if (handler.dInfo[i] == null) {
            handler.dInfo[i] = handler.updateDInfo[i];
            SonarCore.sendPacketAround((TileEntity)te, (int)64, (int)(i + 10));
        } else if (handler.dInfo[i] != null && (type = handler.dInfo[i].getNextSyncType(handler.updateDInfo[i])) != null) {
            if (type == NBTHelper.SyncType.SAVE) {
                handler.dInfo[i] = handler.updateDInfo[i];
                SonarCore.sendPacketAround((TileEntity)te, (int)64, (int)(i + 10));
            } else if (type == NBTHelper.SyncType.SYNC) {
                SonarCore.sendPacketAround((TileEntity)te, (int)64, (int)(i + 20));
            }
        }
    }

    public void screenClicked(World world, EntityPlayer player, int x, int y, int z, BlockInteraction interact) {
        Object handler;
        TileEntity te = world.func_147438_o(x, y, z);
        if (interact.side != FMPHelper.getMeta((TileEntity)te)) {
            return;
        }
        ScreenType screenType = ScreenType.NORMAL;
        if (te instanceof ILargeDisplay) {
            screenType = ScreenType.LARGE;
            if (((ILargeDisplay)te).getSizing() != null) {
                screenType = ScreenType.CONNECTED;
            }
        }
        ILogicInfo screenInfo = this.dInfo[0];
        TileEntity tile = te;
        if (screenType == ScreenType.CONNECTED || screenType == ScreenType.LARGE) {
            handler = (LargeDisplayScreenHandler)this;
            if (!((Boolean)((LargeDisplayScreenHandler)((Object)handler)).isHandler.getObject()).booleanValue()) {
                LargeDisplayScreenHandler screenHandler = ((LargeDisplayScreenHandler)((Object)handler)).getHandler(te);
                if (screenHandler == null) {
                    return;
                }
                tile = screenHandler.tile;
                screenInfo = screenHandler.dInfo[0];
            }
        }
        if ((handler = Logistics.infoInteraction.getInteractionHandler(screenInfo, screenType, tile)) != null) {
            ((InfoInteractionHandler)handler).handleInteraction(screenInfo, screenType, tile, player, x, y, z, interact);
        }
    }

    public ILogicInfo[] getDisplayInfo() {
        return this.dInfo;
    }

    public IInfoScreen.ScreenLayout getScreenLayout() {
        return IInfoScreen.ScreenLayout.ONE;
    }

    public boolean canConnect(TileEntity te, ForgeDirection dir) {
        return dir.equals((Object)ForgeDirection.getOrientation((int)FMPHelper.getMeta((TileEntity)te)).getOpposite());
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaInfo(List<String> currenttip) {
        return currenttip;
    }

    public void writePacket(ByteBuf buf, int id) {
        if (id >= 10 && id < 14) {
            if (this.dInfo[id - 10] != null) {
                buf.writeBoolean(true);
                Logistics.infoTypes.writeToBuf(buf, this.dInfo[id - 10]);
            } else {
                buf.writeBoolean(false);
            }
        } else if (id > 14) {
            NBTTagCompound tag = new NBTTagCompound();
            if (this.updateDInfo[id - 20] != null) {
                this.dInfo[id - 20].writeUpdate(this.updateDInfo[id - 20], tag);
                this.dInfo[id - 20] = this.updateDInfo[id - 20];
            }
            if (!tag.func_82582_d()) {
                buf.writeBoolean(true);
                ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
            } else {
                buf.writeBoolean(false);
            }
        }
    }

    public void readPacket(ByteBuf buf, int id) {
        NBTTagCompound tag;
        if (id >= 10 && id < 14) {
            this.dInfo[id - 10] = buf.readBoolean() ? (ILogicInfo)Logistics.infoTypes.readFromBuf(buf) : null;
        } else if (id > 14 && buf.readBoolean() && (tag = ByteBufUtils.readTag((ByteBuf)buf)) != null && this.dInfo[id - 20] != null) {
            this.dInfo[id - 20].readUpdate(tag);
        }
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE) {
            for (int i = 0; i < this.dInfo.length; ++i) {
                if (nbt.func_74764_b("info" + i)) {
                    this.dInfo[i] = (ILogicInfo)Logistics.infoTypes.readFromNBT(nbt.func_74775_l("info" + i));
                }
                if (this.dInfo[i] != null) continue;
                this.dInfo[i] = InfoHelper.empty;
            }
            if (nbt.func_74764_b("currentInfo")) {
                this.dInfo[0] = (ILogicInfo)Logistics.infoTypes.readFromNBT(nbt.func_74775_l("currentInfo"));
            }
        }
    }

    public void writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE) {
            for (int i = 0; i < this.dInfo.length; ++i) {
                if (this.dInfo[i] == null) continue;
                NBTTagCompound infoTag = new NBTTagCompound();
                Logistics.infoTypes.writeToNBT(infoTag, this.dInfo[i]);
                nbt.func_74782_a("info" + i, (NBTBase)infoTag);
            }
        }
    }
}

