/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.common.handlers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.api.BlockCoords;
import sonar.core.integration.fmp.FMPHelper;
import sonar.core.integration.fmp.handlers.TileHandler;
import sonar.core.network.sync.ISyncPart;
import sonar.core.network.sync.SyncGeneric;
import sonar.core.network.sync.SyncPart;
import sonar.core.network.sync.SyncTagType;
import sonar.core.utils.IBufManager;
import sonar.core.utils.IBufObject;
import sonar.logistics.Logistics;
import sonar.logistics.api.LogisticsAPI;
import sonar.logistics.api.cache.CacheTypes;
import sonar.logistics.api.cache.INetworkCache;
import sonar.logistics.api.connecting.CableType;
import sonar.logistics.api.connecting.IInfoEmitter;
import sonar.logistics.api.info.ILogicInfo;
import sonar.logistics.api.info.LogicInfo;

public class DataModifierHandler
extends TileHandler {
    public SyncTagType.STRING subCategory = new SyncTagType.STRING(0);
    public SyncTagType.STRING prefix = new SyncTagType.STRING(1);
    public SyncTagType.STRING suffix = new SyncTagType.STRING(2);
    public SyncGeneric<ILogicInfo> info = new SyncGeneric((IBufManager)Logistics.infoTypes, "currentInfo");

    public DataModifierHandler(boolean isMultipart, TileEntity tile) {
        super(isMultipart, tile);
    }

    public void update(TileEntity te) {
        if (te.func_145831_w().field_72995_K) {
            return;
        }
        INetworkCache network = LogisticsAPI.getCableHelper().getNetwork(te, ForgeDirection.getOrientation((int)FMPHelper.getMeta((TileEntity)te)).getOpposite());
        ArrayList<BlockCoords> emitters = network.getConnections(CacheTypes.EMITTER, true);
        if (emitters.isEmpty() || emitters.get(0) == null) {
            return;
        }
        Object target = FMPHelper.getTile((Object)emitters.get(0).getTileEntity());
        if (target == null) {
            return;
        }
        if (target instanceof IInfoEmitter) {
            IInfoEmitter infoNode = (IInfoEmitter)target;
            if (infoNode.currentInfo() != null) {
                if (!infoNode.currentInfo().equals(this.info)) {
                    this.info.setDefault((IBufObject)infoNode.currentInfo());
                }
            } else if (this.info != null) {
                this.info = null;
            }
        }
    }

    public void addSyncParts(List<ISyncPart> parts) {
        super.addSyncParts(parts);
        parts.addAll(Lists.newArrayList((Object[])new SyncPart[]{this.subCategory, this.prefix, this.suffix, this.info}));
    }

    public CableType canRenderConnection(ForgeDirection dir, TileEntity te) {
        return LogisticsAPI.getCableHelper().canRenderConnection(te, dir, CableType.BLOCK_CONNECTION);
    }

    public boolean canConnect(ForgeDirection dir) {
        return true;
    }

    public ILogicInfo currentInfo() {
        if (this.info.getObject() == null) {
            return null;
        }
        if (((ILogicInfo)this.info.getObject()).getProviderID() == -1 && ((ILogicInfo)this.info.getObject()).getCategory().equals("PERCENT")) {
            return (ILogicInfo)this.info.getObject();
        }
        String currentSub = (String)this.subCategory.getObject();
        String currentPre = (String)this.prefix.getObject();
        String currentSuf = (String)this.suffix.getObject();
        String subCat = currentSub == null || currentSub.isEmpty() || currentSub.equals("") ? ((ILogicInfo)this.info.getObject()).getSubCategory() : currentSub;
        String prefix = currentPre == null || currentPre.isEmpty() || currentPre.equals("") ? "" : currentPre;
        String suffix = currentSuf == null || currentSuf.isEmpty() || currentSuf.equals("") ? "" : currentSuf;
        LogicInfo modifiedInfo = new LogicInfo(-1, ((ILogicInfo)this.info.getObject()).getCategory(), subCat, (Object)(prefix + " " + ((ILogicInfo)this.info.getObject()).getDisplayableData() + " " + suffix));
        return modifiedInfo;
    }

    public void textTyped(String string, int id) {
        String text = string == null || string.isEmpty() ? " " : string;
        switch (id) {
            case 1: {
                this.prefix.setObject((Object)string);
                break;
            }
            case 2: {
                this.suffix.setObject((Object)string);
                break;
            }
            default: {
                this.subCategory.setObject((Object)string);
            }
        }
    }
}

