/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.common.handlers;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.SonarCore;
import sonar.core.api.BlockCoords;
import sonar.core.helpers.NBTHelper;
import sonar.core.helpers.SonarHelper;
import sonar.core.integration.fmp.FMPHelper;
import sonar.core.integration.fmp.handlers.TileHandler;
import sonar.core.network.PacketTileSync;
import sonar.logistics.api.LogisticsAPI;
import sonar.logistics.api.cache.INetworkCache;
import sonar.logistics.api.connecting.CableType;
import sonar.logistics.api.utils.ExternalCoords;
import sonar.logistics.network.SyncExternalCoords;

public class ChannelSelectorHandler
extends TileHandler {
    public List<ExternalCoords> channels;
    public List<ExternalCoords> lastChannels;
    public SyncExternalCoords channel = new SyncExternalCoords(0);

    public ChannelSelectorHandler(boolean isMultipart, TileEntity tile) {
        super(isMultipart, tile);
    }

    public void update(TileEntity te) {
        if (te.func_145831_w().field_72995_K) {
            return;
        }
        INetworkCache network = LogisticsAPI.getCableHelper().getNetwork(te, ForgeDirection.getOrientation((int)FMPHelper.getMeta((TileEntity)te)).getOpposite());
        this.channels = new ArrayList<ExternalCoords>();
        for (Map.Entry<BlockCoords, ForgeDirection> entry : network.getExternalBlocks(true).entrySet()) {
            BlockCoords coords = entry.getKey();
            Block target = coords.getBlock();
            int meta = coords.getWorld().func_72805_g(coords.getX(), coords.getY(), coords.getZ());
            ItemStack stack = SonarHelper.createStackedBlock((Block)target, (int)meta);
            if (coords.getWorld().func_147437_c(coords.getX(), coords.getY(), coords.getZ())) continue;
            stack = SonarHelper.createStackedBlock((Block)coords.getBlock(coords.getWorld()), (int)meta);
            this.channels.add(new ExternalCoords(coords.toString(), stack, coords, entry.getValue()));
        }
    }

    public void sendAvailableData(TileEntity te, EntityPlayer player) {
        if (player != null && player instanceof EntityPlayerMP) {
            NBTTagCompound syncData = new NBTTagCompound();
            this.writeData(syncData, NBTHelper.SyncType.SYNC);
            SonarCore.network.sendTo((IMessage)new PacketTileSync(te.field_145851_c, te.field_145848_d, te.field_145849_e, syncData, NBTHelper.SyncType.SYNC), (EntityPlayerMP)player);
        }
    }

    public ExternalCoords getChannel(TileEntity te) {
        ExternalCoords currentCoords = this.channel.getCoords();
        if (currentCoords == null) {
            return null;
        }
        return currentCoords;
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        NBTTagCompound compound;
        int i;
        NBTTagList list;
        super.readData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE) {
            this.channel.readFromNBT(nbt, type);
        }
        if (type == NBTHelper.SyncType.SPECIAL) {
            this.channel.readFromNBT(nbt, NBTHelper.SyncType.SYNC);
            if (nbt.func_74764_b("null")) {
                this.channels = new ArrayList<ExternalCoords>();
                return;
            }
            list = nbt.func_150295_c("COORDS", 10);
            if (this.channels == null) {
                this.channels = new ArrayList<ExternalCoords>();
            }
            block4: for (i = 0; i < list.func_74745_c(); ++i) {
                compound = list.func_150305_b(i);
                byte slot = compound.func_74771_c("Slot");
                boolean set = slot < this.channels.size();
                switch (compound.func_74771_c("f")) {
                    case 0: {
                        if (set) {
                            this.channels.set(slot, ExternalCoords.readFromNBT(compound));
                            continue block4;
                        }
                        this.channels.add(slot, ExternalCoords.readFromNBT(compound));
                        continue block4;
                    }
                    case 2: {
                        if (set) {
                            this.channels.set(slot, null);
                            continue block4;
                        }
                        this.channels.add(slot, null);
                    }
                }
            }
        }
        if (type == NBTHelper.SyncType.SYNC) {
            this.channel.readFromNBT(nbt, NBTHelper.SyncType.SAVE);
            list = nbt.func_150295_c("COORDS", 10);
            this.channels = new ArrayList<ExternalCoords>();
            for (i = 0; i < list.func_74745_c(); ++i) {
                compound = list.func_150305_b(i);
                this.channels.add(ExternalCoords.readFromNBT(compound));
            }
        }
    }

    public void writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        NBTTagList list;
        super.writeData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE) {
            this.channel.writeToNBT(nbt, type);
        }
        if (type == NBTHelper.SyncType.SPECIAL) {
            this.channel.writeToNBT(nbt, NBTHelper.SyncType.SYNC);
            if (this.channels == null) {
                this.channels = new ArrayList<ExternalCoords>();
            }
            if (this.lastChannels == null) {
                this.lastChannels = new ArrayList<ExternalCoords>();
            }
            if (this.channels.size() <= 0 && this.lastChannels.size() > 0) {
                nbt.func_74757_a("null", true);
                this.lastChannels = new ArrayList<ExternalCoords>();
                return;
            }
            list = new NBTTagList();
            int size = Math.max(this.channels.size(), this.lastChannels.size());
            for (int i = 0; i < size; ++i) {
                ExternalCoords current = null;
                ExternalCoords last = null;
                if (i < this.channels.size()) {
                    current = this.channels.get(i);
                }
                if (i < this.lastChannels.size()) {
                    last = this.lastChannels.get(i);
                }
                NBTTagCompound compound = new NBTTagCompound();
                if (current != null) {
                    if (last != null) {
                        if (!(BlockCoords.equalCoords((BlockCoords)current.blockCoords, (BlockCoords)last.blockCoords) && current.coordString.equals(last.coordString) && current.block.func_77969_a(last.block))) {
                            compound.func_74774_a("f", (byte)0);
                            this.lastChannels.set(i, current);
                            ExternalCoords.writeToNBT(compound, this.channels.get(i));
                        }
                    } else {
                        compound.func_74774_a("f", (byte)0);
                        this.lastChannels.add(i, current);
                        ExternalCoords.writeToNBT(compound, this.channels.get(i));
                    }
                } else if (last != null) {
                    this.lastChannels.set(i, null);
                    compound.func_74774_a("f", (byte)2);
                }
                if (compound.func_82582_d()) continue;
                compound.func_74774_a("Slot", (byte)i);
                list.func_74742_a((NBTBase)compound);
            }
            if (list.func_74745_c() != 0) {
                nbt.func_74782_a("COORDS", (NBTBase)list);
            }
        }
        if (type == NBTHelper.SyncType.SYNC) {
            this.channel.writeToNBT(nbt, NBTHelper.SyncType.SAVE);
            list = new NBTTagList();
            if (this.channels == null) {
                this.channels = new ArrayList<ExternalCoords>();
            }
            for (int i = 0; i < this.channels.size(); ++i) {
                if (this.channels.get(i) == null) continue;
                NBTTagCompound compound = new NBTTagCompound();
                ExternalCoords.writeToNBT(compound, this.channels.get(i));
                list.func_74742_a((NBTBase)compound);
            }
            nbt.func_74782_a("COORDS", (NBTBase)list);
        }
    }

    public CableType canRenderConnection(TileEntity te, ForgeDirection dir) {
        return LogisticsAPI.getCableHelper().canRenderConnection(te, dir, CableType.BLOCK_CONNECTION);
    }

    public boolean canConnect(TileEntity te, ForgeDirection dir) {
        return true;
    }
}

