/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.common.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import sonar.core.common.block.SonarMaterials;
import sonar.logistics.Logistics;
import sonar.logistics.common.blocks.BaseNode;
import sonar.logistics.common.tileentity.TileEntityRedstoneSignaller;
import sonar.logistics.registries.BlockRegistry;

public class BlockRedstoneSignaller
extends BaseNode {
    private boolean on;

    public BlockRedstoneSignaller(boolean on) {
        super(SonarMaterials.machine);
        this.func_149676_a(0.25f, 0.25f, 0.25f, 0.75f, 0.75f, 0.75f);
        this.on = on;
    }

    @Override
    public TileEntity func_149915_a(World world, int i) {
        return new TileEntityRedstoneSignaller();
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack itemstack) {
        super.func_149689_a(world, x, y, z, entity, itemstack);
    }

    @Override
    public void openGui(World world, int x, int y, int z, EntityPlayer player) {
        if (player != null && !world.field_72995_K) {
            player.openGui((Object)Logistics.instance, 5, world, x, y, z);
        }
    }

    public boolean hasSpecialRenderer() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        if (this.on) {
            int l = world.func_72805_g(x, y, z);
            double d0 = (double)((float)x + 0.5f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
            double d1 = (double)((float)y + 0.7f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
            double d2 = (double)((float)z + 0.5f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
            double d3 = 0.22f;
            double d4 = 0.27f;
            if (l == 1) {
                world.func_72869_a("reddust", d0 - d4, d1 + d3, d2, 0.0, 0.0, 0.0);
            } else if (l == 2) {
                world.func_72869_a("reddust", d0 + d4, d1 + d3, d2, 0.0, 0.0, 0.0);
            } else if (l == 3) {
                world.func_72869_a("reddust", d0, d1 + d3, d2 - d4, 0.0, 0.0, 0.0);
            } else if (l == 4) {
                world.func_72869_a("reddust", d0, d1 + d3, d2 + d4, 0.0, 0.0, 0.0);
            } else {
                world.func_72869_a("reddust", d0, d1, d2, 0.0, 0.0, 0.0);
            }
        }
    }

    public static void updateSignallerState(boolean on, World world, int x, int y, int z) {
        int l = world.func_72805_g(x, y, z);
        TileEntity tileentity = world.func_147438_o(x, y, z);
        if (on) {
            world.func_147449_b(x, y, z, BlockRegistry.redstoneSignaller_on);
        } else {
            world.func_147449_b(x, y, z, BlockRegistry.redstoneSignaller_off);
        }
        world.func_72921_c(x, y, z, l, 2);
        if (tileentity != null) {
            tileentity.func_145829_t();
            world.func_147455_a(x, y, z, tileentity);
        }
    }

    public int func_149709_b(IBlockAccess world, int x, int y, int z, int side) {
        return this.on ? 15 : 0;
    }

    public int func_149748_c(IBlockAccess world, int x, int y, int z, int side) {
        return this.on ? 15 : 0;
    }

    public boolean hasSpecialCollisionBox() {
        return true;
    }

    public List<AxisAlignedBB> getCollisionBoxes(World world, int x, int y, int z, List<AxisAlignedBB> list) {
        this.func_149676_a(0.25f, 0.25f, 0.25f, 0.75f, 0.75f, 0.75f);
        list.add(AxisAlignedBB.func_72330_a((double)0.25, (double)0.25, (double)0.25, (double)0.75, (double)0.75, (double)0.75));
        return list;
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World world, int x, int y, int z) {
        return Item.func_150898_a((Block)BlockRegistry.redstoneSignaller_off);
    }

    public Item func_149650_a(int meta, Random rand, int fortune) {
        return Item.func_150898_a((Block)BlockRegistry.redstoneSignaller_off);
    }
}

