/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.common.blocks;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.common.block.SonarMaterials;
import sonar.core.helpers.SonarHelper;
import sonar.logistics.common.blocks.BaseNode;

public class BlockNode
extends BaseNode {
    public BlockNode() {
        super(SonarMaterials.machine);
        this.disableOrientation();
        float f = 0.0625f;
        this.func_149676_a(0.0f + f, 0.0f, 0.0f + f, 1.0f - f, 0.4f, 1.0f - f);
    }

    public boolean hasSpecialRenderer() {
        return true;
    }

    public boolean func_149707_d(World world, int x, int y, int z, int meta) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)meta).getOpposite();
        return !world.func_147437_c(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        super.func_149742_c(world, x, y, z);
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)i);
            if (world.func_147437_c(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ)) continue;
            return true;
        }
        return false;
    }

    private boolean canStayAt(World world, int x, int y, int z) {
        if (!this.func_149742_c(world, x, y, z)) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147468_f(x, y, z);
            return false;
        }
        return true;
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        int k1 = metadata & 8;
        int meta = -1;
        ForgeDirection dir = ForgeDirection.getOrientation((int)side).getOpposite();
        if (!world.func_147437_c(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ)) {
            meta = (byte)SonarHelper.invertMetadata((int)side);
        }
        return meta + k1;
    }

    public void func_149695_a(World world, int x, int y, int z, Block oldBlock) {
        if (this.canStayAt(world, x, y, z)) {
            int l = world.func_72805_g(x, y, z) & 7;
            boolean flag = false;
            if (world.func_147437_c(x - 1, y, z) && l == 1) {
                flag = true;
            }
            if (world.func_147437_c(x + 1, y, z) && l == 2) {
                flag = true;
            }
            if (world.func_147437_c(x, y, z - 1) && l == 3) {
                flag = true;
            }
            if (world.func_147437_c(x, y, z + 1) && l == 4) {
                flag = true;
            }
            if (world.func_147437_c(x, y - 1, z) && l == 5) {
                flag = true;
            }
            if (world.func_147437_c(x, y - 1, z) && l == 6) {
                flag = true;
            }
            if (world.func_147437_c(x, y + 1, z) && l == 0) {
                flag = true;
            }
            if (world.func_147437_c(x, y + 1, z) && l == 7) {
                flag = true;
            }
            if (flag) {
                this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
                world.func_147468_f(x, y, z);
            }
        }
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        int l = world.func_72805_g(x, y, z) & 7;
        float f = 0.0625f;
        if (l == 1) {
            this.func_149676_a(0.0f, f, f, 0.4f, 1.0f - f, 1.0f - f);
        } else if (l == 2) {
            this.func_149676_a(0.6f, f, f, 1.0f, 1.0f - f, 1.0f - f);
        } else if (l == 3) {
            this.func_149676_a(0.0f + f, 0.0f + f, 0.0f, 1.0f - f, 1.0f - f, 0.4f);
        } else if (l == 4) {
            this.func_149676_a(0.0f, f, 0.6f, 1.0f - f, 1.0f - f, 1.0f);
        } else if (l != 5 && l != 6) {
            if (l == 0 || l == 7) {
                this.func_149676_a(0.0f, 0.6f, f, 1.0f - f, 1.0f, 1.0f - f);
            }
        } else {
            f = 0.0625f;
            this.func_149676_a(0.0f + f, 0.0f, 0.0f + f, 1.0f - f, 0.4f, 1.0f - f);
        }
    }

    public boolean hasSpecialCollisionBox() {
        return true;
    }

    public List<AxisAlignedBB> getCollisionBoxes(World world, int x, int y, int z, List<AxisAlignedBB> list) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        list.add(AxisAlignedBB.func_72330_a((double)this.field_149759_B, (double)this.field_149760_C, (double)this.field_149754_D, (double)this.field_149755_E, (double)this.field_149756_F, (double)this.field_149757_G));
        return list;
    }
}

