/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.common.blocks;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import sonar.core.SonarCore;
import sonar.core.common.block.SonarMaterials;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.PacketTileSync;
import sonar.core.utils.BlockInteraction;
import sonar.core.utils.BlockInteractionType;
import sonar.logistics.Logistics;
import sonar.logistics.common.blocks.BaseNode;
import sonar.logistics.common.tileentity.TileEntityItemRouter;

public class BlockItemRouter
extends BaseNode {
    public BlockItemRouter() {
        super(SonarMaterials.machine);
        this.disableOrientation();
    }

    public boolean hasSpecialRenderer() {
        return true;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void openGui(World world, int x, int y, int z, EntityPlayer player) {
        if (player != null && !world.field_72995_K) {
            NBTTagCompound packetTag = new NBTTagCompound();
            ((TileEntityItemRouter)world.func_147438_o(x, y, z)).writeData(packetTag, NBTHelper.SyncType.PACKET);
            SonarCore.network.sendTo((IMessage)new PacketTileSync(x, y, z, packetTag, NBTHelper.SyncType.PACKET), (EntityPlayerMP)player);
            player.openGui((Object)Logistics.instance, 11, world, x, y, z);
        }
    }

    @Override
    public boolean operateBlock(World world, int x, int y, int z, EntityPlayer player, BlockInteraction interact) {
        TileEntity target;
        if (!world.field_72995_K && player != null && (target = world.func_147438_o(x, y, z)) instanceof TileEntityItemRouter) {
            TileEntityItemRouter router = (TileEntityItemRouter)target;
            if (interact.type == BlockInteractionType.SHIFT_RIGHT) {
                if ((Integer)router.handler.sideConfigs[interact.side].getObject() < 2) {
                    router.handler.sideConfigs[interact.side].increaseBy(1);
                } else {
                    router.handler.sideConfigs[interact.side].setObject((Object)0);
                }
                SonarCore.sendFullSyncAround((TileEntity)router, (int)64);
                return true;
            }
        }
        return super.operateBlock(world, x, y, z, player, interact);
    }

    @Override
    public TileEntity func_149915_a(World world, int i) {
        return new TileEntityItemRouter();
    }

    public boolean hasSpecialCollisionBox() {
        return false;
    }

    @Override
    public boolean dropStandard(World world, int x, int y, int z) {
        return false;
    }

    public void addSpecialToolTip(ItemStack stack, EntityPlayer player, List list) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("dropped")) {
            list.add("Configured");
        }
    }
}

