/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.common.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.common.block.SonarMaterials;
import sonar.core.integration.fmp.FMPHelper;
import sonar.core.integration.fmp.handlers.TileHandler;
import sonar.core.utils.BlockInteraction;
import sonar.core.utils.BlockInteractionType;
import sonar.logistics.common.blocks.BaseNode;
import sonar.logistics.common.handlers.DisplayScreenHandler;
import sonar.logistics.common.tileentity.TileEntityHolographicDisplay;

public class BlockHolographicDisplay
extends BaseNode {
    public BlockHolographicDisplay() {
        super(SonarMaterials.machine);
        this.func_149676_a(0.25f, 0.25f, 0.25f, 0.75f, 0.75f, 0.75f);
    }

    @Override
    public TileEntity func_149915_a(World world, int i) {
        return new TileEntityHolographicDisplay();
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        if (world.field_72995_K && this.allowLeftClick()) {
            MovingObjectPosition pos = Minecraft.func_71410_x().field_71476_x;
            float hitX = (float)(pos.field_72307_f.field_72450_a - (double)pos.field_72311_b);
            float hitY = (float)(pos.field_72307_f.field_72448_b - (double)pos.field_72312_c);
            float hitZ = (float)(pos.field_72307_f.field_72449_c - (double)pos.field_72309_d);
            this.operateBlock(world, x, y, z, player, new BlockInteraction(pos.field_72310_e, hitX, hitY, hitZ, player.func_70093_af() ? BlockInteractionType.SHIFT_LEFT : BlockInteractionType.LEFT));
        }
    }

    public boolean allowLeftClick() {
        return true;
    }

    public boolean isClickableSide(World world, int x, int y, int z, int side) {
        return side == world.func_72805_g(x, y, z);
    }

    @Override
    public boolean operateBlock(World world, int x, int y, int z, EntityPlayer player, BlockInteraction interact) {
        TileHandler target;
        if (player != null && (target = FMPHelper.getHandler((Object)world.func_147438_o(x, y, z))) != null && target instanceof DisplayScreenHandler) {
            DisplayScreenHandler handler = (DisplayScreenHandler)target;
            if (world.field_72995_K) {
                handler.screenClicked(world, player, x, y, z, interact);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    public boolean hasSpecialRenderer() {
        return true;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        boolean flag = false;
        int l = world.func_72805_g(x, y, z);
        flag = true;
        if (l == 2 && world.func_147439_a(x, y, z + 1).func_149688_o().func_76220_a()) {
            flag = false;
        }
        if (l == 3 && world.func_147439_a(x, y, z - 1).func_149688_o().func_76220_a()) {
            flag = false;
        }
        if (l == 4 && world.func_147439_a(x + 1, y, z).func_149688_o().func_76220_a()) {
            flag = false;
        }
        if (l == 5 && world.func_147439_a(x - 1, y, z).func_149688_o().func_76220_a()) {
            flag = false;
        }
        if (flag) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147468_f(x, y, z);
        }
        super.func_149695_a(world, x, y, z, block);
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        int l = world.func_72805_g(x, y, z);
        float f = 0.28125f;
        float f1 = 0.78125f;
        float f2 = 0.0f;
        float f3 = 1.0f;
        float f4 = 0.125f;
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        if (l == 2) {
            this.func_149676_a(f2, f, 1.0f - f4, f3, f1, 1.0f);
        }
        if (l == 3) {
            this.func_149676_a(f2, f, 0.0f, f3, f1, f4);
        }
        if (l == 4) {
            this.func_149676_a(1.0f - f4, f, f2, 1.0f, f1, f3);
        }
        if (l == 5) {
            this.func_149676_a(0.0f, f, f2, f4, f1, f3);
        }
    }

    public boolean hasSpecialCollisionBox() {
        return true;
    }

    public List<AxisAlignedBB> getCollisionBoxes(World world, int x, int y, int z, List<AxisAlignedBB> list) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        list.add(this.func_149668_a(world, x, y, z));
        return list;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        effectRenderer.func_78867_a(x, y, z, meta);
        effectRenderer.func_78867_a(x, y, z, ForgeDirection.OPPOSITES[meta]);
        return true;
    }
}

