/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.common.blocks;

import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import sonar.core.common.block.SonarMachineBlock;
import sonar.core.common.tileentity.TileEntitySonar;
import sonar.core.helpers.FontHelper;
import sonar.core.utils.BlockInteraction;
import sonar.logistics.common.tileentity.TileEntityBlockNode;
import sonar.logistics.common.tileentity.TileEntityNode;

public abstract class BaseNode
extends SonarMachineBlock {
    protected BaseNode(Material material) {
        super(material);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack itemstack) {
        super.func_149689_a(world, x, y, z, entity, itemstack);
        TileEntity target = world.func_147438_o(x, y, z);
        if (entity instanceof EntityPlayer && target instanceof TileEntityNode) {
            EntityPlayer player = (EntityPlayer)entity;
            TileEntityNode node = (TileEntityNode)target;
            node.playerName = player.func_146103_bH().getName();
        }
    }

    public boolean dropStandard(World world, int x, int y, int z) {
        return true;
    }

    public boolean hasGui() {
        return false;
    }

    public boolean operateBlock(World world, int x, int y, int z, EntityPlayer player, BlockInteraction interact) {
        TileEntity target;
        TileEntity tile = world.func_147438_o(x, y, z);
        if (!this.hasGui()) {
            return false;
        }
        if (player != null && (target = world.func_147438_o(x, y, z)) instanceof TileEntitySonar) {
            if (!world.field_72995_K) {
                TileEntitySonar sonar = (TileEntitySonar)target;
                if (sonar instanceof TileEntityNode) {
                    TileEntityNode node = (TileEntityNode)target;
                    if (((Boolean)node.isPrivate.getObject()).booleanValue() && !node.playerName.equals(player.func_146103_bH().getName())) {
                        FontHelper.sendMessage((String)(FontHelper.translate((String)"dataBlock.denied") + ": " + node.playerName), (World)world, (EntityPlayer)player);
                        return false;
                    }
                }
                sonar.sendSyncPacket(player);
                this.openGui(world, x, y, z, player);
            }
            return true;
        }
        return false;
    }

    public void openGui(World world, int x, int y, int z, EntityPlayer player) {
    }

    public TileEntity func_149915_a(World world, int i) {
        return new TileEntityBlockNode();
    }
}

