/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.client.renderers;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelSign;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import sonar.core.helpers.RenderHelper;
import sonar.core.integration.fmp.FMPHelper;
import sonar.core.integration.fmp.handlers.TileHandler;
import sonar.core.renderers.SonarTERender;
import sonar.logistics.api.connecting.CableType;
import sonar.logistics.api.connecting.ITransceiver;
import sonar.logistics.client.models.ModelBlockNode;
import sonar.logistics.client.models.ModelClock;
import sonar.logistics.client.models.ModelDataCable;
import sonar.logistics.client.models.ModelDataModifier;
import sonar.logistics.client.models.ModelDataReceiver;
import sonar.logistics.client.models.ModelDirectionalConnector;
import sonar.logistics.client.models.ModelEntityNode;
import sonar.logistics.client.models.ModelExpulsionPort;
import sonar.logistics.client.models.ModelHammer;
import sonar.logistics.client.models.ModelInfoCreator;
import sonar.logistics.client.models.ModelItemRouter;
import sonar.logistics.client.models.ModelRedstoneSignaller;
import sonar.logistics.client.models.ModelTransceiverArray;
import sonar.logistics.common.handlers.ArrayHandler;
import sonar.logistics.common.tileentity.TileEntityClock;
import sonar.logistics.common.tileentity.TileEntityEntityNode;
import sonar.logistics.common.tileentity.TileEntityHammer;
import sonar.logistics.common.tileentity.TileEntityItemRouter;
import sonar.logistics.registries.BlockRegistry;

public class RenderHandlers {
    public static final String modelFolder = "PracticalLogistics:textures/model/";
    public static final ModelDataCable modelCable = new ModelDataCable();
    public static final String textureCable = "PracticalLogistics:textures/model/dataCable.png";

    public static class TransceiverArray
    extends TileEntitySpecialRenderer {
        public ModelTransceiverArray model = new ModelTransceiverArray();
        public String texture = "PracticalLogistics:textures/model/transceiverArray.png";

        public void func_147500_a(TileEntity entity, double x, double y, double z, float f) {
            RenderHelper.beginRender((double)(x + 0.5), (double)(y + 1.5), (double)(z + 0.5), (int)0, (String)RenderHandlers.textureCable);
            modelCable.renderTile(entity, null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f, CableType.NONE);
            RenderHelper.finishRender();
            RenderHelper.beginRender((double)(x + 0.5), (double)(y + 1.5), (double)(z + 0.5), (int)0, (String)this.texture);
            this.model.func_78088_a(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
            if (entity != null && entity.func_145831_w() != null) {
                GL11.glRotated((double)180.0, (double)1.0, (double)0.0, (double)0.0);
                GL11.glScaled((double)0.7, (double)0.7, (double)0.7);
                GL11.glTranslated((double)-0.195, (double)-1.05, (double)-0.27);
                TileHandler handler = FMPHelper.getHandler((Object)entity);
                if (handler != null && handler instanceof ArrayHandler) {
                    ArrayHandler array = (ArrayHandler)handler;
                    ItemStack[] stacks = array.slots;
                    for (int i = 0; i < stacks.length; ++i) {
                        ItemStack stack = stacks[i];
                        if (stack == null || !(stack.func_77973_b() instanceof ITransceiver)) continue;
                        double translateX = i < 4 ? 0.0 : 0.355;
                        int translateZ = i < 4 ? i : i - 4;
                        GL11.glTranslated((double)translateX, (double)0.0, (double)((double)translateZ * 0.182));
                        RenderHelper.renderItem((World)entity.func_145831_w(), (ItemStack)stack);
                        GL11.glTranslated((double)(-translateX), (double)0.0, (double)((double)(-translateZ) * 0.182));
                    }
                }
            }
            RenderHelper.finishRender();
        }
    }

    public static class ExpulsionPort
    extends SonarTERender {
        public ExpulsionPort() {
            super((ModelBase)new ModelExpulsionPort(), "PracticalLogistics:textures/model/port.png");
        }

        public void func_147500_a(TileEntity entity, double x, double y, double z, float f) {
            RenderHelper.beginRender((double)(x + 0.5), (double)(y + 1.5), (double)(z + 0.5), (int)0, (String)RenderHandlers.textureCable);
            modelCable.renderTile(entity, null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f, CableType.NONE);
            RenderHelper.finishRender();
            RenderHelper.beginRender((double)(x + 0.5), (double)(y + 1.5), (double)(z + 0.5), (int)RenderHelper.setMetaData((TileEntity)entity), (String)this.texture);
            if (entity != null && entity.func_145831_w() != null) {
                int meta = entity.func_145832_p();
                if (meta == 5) {
                    GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
                } else if (meta != 6) {
                    if (meta == 4) {
                        GL11.glTranslated((double)-1.0, (double)1.0, (double)0.0);
                        GL11.glRotated((double)90.0, (double)0.0, (double)0.0, (double)-1.0);
                    } else if (meta == 3) {
                        GL11.glTranslated((double)0.0, (double)1.0, (double)-1.0);
                        GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                    } else if (meta == 2) {
                        GL11.glTranslated((double)1.0, (double)1.0, (double)0.0);
                        GL11.glRotated((double)90.0, (double)0.0, (double)0.0, (double)1.0);
                    } else if (meta == 1) {
                        GL11.glTranslated((double)1.0, (double)1.0, (double)0.0);
                        GL11.glRotated((double)90.0, (double)0.0, (double)0.0, (double)1.0);
                    } else if (meta == 0) {
                        GL11.glTranslated((double)0.0, (double)2.0, (double)0.0);
                        GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
                    } else if (meta == 7) {
                        GL11.glTranslated((double)0.0, (double)2.0, (double)0.0);
                        GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
                    }
                }
            }
            this.model.func_78088_a((Entity)null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
            RenderHelper.finishRender();
        }
    }

    public static class DigitalScreen
    extends TileEntitySpecialRenderer {
        public ResourceLocation tex = new ResourceLocation("PracticalLogistics:textures/model/digital_sign.png");
        private final ModelSign model = new ModelSign();

        public void func_147500_a(TileEntity te, double x, double y, double z, float par) {
            float f3;
            TileEntitySign sign = (TileEntitySign)te;
            Block block = sign.func_145838_q();
            GL11.glPushMatrix();
            float f1 = 0.6666667f;
            if (block == BlockRegistry.digitalSign_standing) {
                GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.75f * f1), (float)((float)z + 0.5f));
                float f2 = (float)(sign.func_145832_p() * 360) / 16.0f;
                GL11.glRotatef((float)(-f2), (float)0.0f, (float)1.0f, (float)0.0f);
                this.model.field_78165_b.field_78806_j = true;
            } else {
                int j = sign.func_145832_p();
                f3 = 0.0f;
                if (j == 2) {
                    f3 = 180.0f;
                }
                if (j == 4) {
                    f3 = 90.0f;
                }
                if (j == 5) {
                    f3 = -90.0f;
                }
                GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.75f * f1), (float)((float)z + 0.5f));
                GL11.glRotatef((float)(-f3), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glTranslatef((float)0.0f, (float)-0.3125f, (float)-0.4375f);
                this.model.field_78165_b.field_78806_j = false;
            }
            this.func_147499_a(this.tex);
            GL11.glPushMatrix();
            GL11.glScalef((float)f1, (float)(-f1), (float)(-f1));
            this.model.func_78164_a();
            GL11.glPopMatrix();
            FontRenderer fontrenderer = this.func_147498_b();
            f3 = 0.016666668f * f1;
            GL11.glTranslatef((float)0.0f, (float)(0.5f * f1), (float)(0.07f * f1));
            GL11.glScalef((float)f3, (float)(-f3), (float)f3);
            GL11.glDepthMask((boolean)false);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int colour = -1;
            for (int i = 0; i < sign.field_145915_a.length; ++i) {
                String s = sign.field_145915_a[i];
                if (i == sign.field_145918_i) {
                    s = "> " + s + " <";
                    fontrenderer.func_78276_b(s, -fontrenderer.func_78256_a(s) / 2, i * 10 - sign.field_145915_a.length * 5, colour);
                    continue;
                }
                fontrenderer.func_78276_b(s, -fontrenderer.func_78256_a(s) / 2, i * 10 - sign.field_145915_a.length * 5, colour);
            }
            GL11.glDepthMask((boolean)true);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
        }
    }

    public static class Clock
    extends TileEntitySpecialRenderer {
        public ModelClock model = new ModelClock();
        public String texture = "PracticalLogistics:textures/model/clock.png";

        public void func_147500_a(TileEntity entity, double x, double y, double z, float f) {
            RenderHelper.beginRender((double)(x + 0.5), (double)(y + 1.5), (double)(z + 0.5), (int)RenderHelper.setMetaData((TileEntity)entity), (String)this.texture);
            float rotation = 0.0f;
            if (entity.func_145831_w() != null) {
                TileEntityClock clock = (TileEntityClock)entity;
                rotation = clock.rotation;
            }
            this.model.render(entity, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f, rotation);
            RenderHelper.finishRender();
        }
    }

    public static class ChannelSelector
    extends DataModifier {
        public ChannelSelector() {
            this.modelTex = "PracticalLogistics:textures/model/channelSelector.png";
            this.cableTex = "PracticalLogistics:textures/model/dataMultiCable.png";
        }
    }

    public static class ItemRouter
    extends TileEntitySpecialRenderer {
        public ModelItemRouter model = new ModelItemRouter();
        public String texture = "PracticalLogistics:textures/model/itemRouter.png";
        public ResourceLocation none = new ResourceLocation("PracticalLogistics:textures/model/router_none.png");
        public ResourceLocation input = new ResourceLocation("PracticalLogistics:textures/model/router_input.png");
        public ResourceLocation output = new ResourceLocation("PracticalLogistics:textures/model/router_output.png");

        public void func_147500_a(TileEntity entity, double x, double y, double z, float f) {
            RenderHelper.beginRender((double)(x + 0.5), (double)(y + 1.5), (double)(z + 0.5), (int)0, (String)this.texture);
            this.model.func_78088_a(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
            if (entity != null && entity instanceof TileEntityItemRouter) {
                GL11.glTranslated((double)-0.5, (double)0.5, (double)-0.5);
                TileEntityItemRouter router = (TileEntityItemRouter)entity;
                int[] sides = new int[6];
                if (entity.func_145831_w() != null) {
                    for (int i = 0; i < 6; ++i) {
                        sides[i] = (Integer)router.handler.sideConfigs[i].getObject();
                    }
                }
                Tessellator tes = Tessellator.field_78398_a;
                tes.func_78382_b();
                Minecraft.func_71410_x().func_110434_K().func_110577_a(sides[1] == 0 ? this.none : (sides[1] == 1 ? this.input : this.output));
                tes.func_78374_a(0.0, 2.0E-4, 0.0, 0.0, 0.0);
                tes.func_78374_a(1.0, 2.0E-4, 0.0, 0.0, 1.0);
                tes.func_78374_a(1.0, 2.0E-4, 1.0, 1.0, 1.0);
                tes.func_78374_a(0.0, 2.0E-4, 1.0, 1.0, 0.0);
                tes.func_78374_a(0.0, 0.125, 0.0, 0.0, 0.0);
                tes.func_78374_a(0.0, 0.125, 1.0, 1.0, 0.0);
                tes.func_78374_a(1.0, 0.125, 1.0, 1.0, 1.0);
                tes.func_78374_a(1.0, 0.125, 0.0, 0.0, 1.0);
                tes.func_78381_a();
                tes.func_78382_b();
                Minecraft.func_71410_x().func_110434_K().func_110577_a(sides[0] == 0 ? this.none : (sides[0] == 1 ? this.input : this.output));
                tes.func_78374_a(0.0, 0.875, 0.0, 0.0, 0.0);
                tes.func_78374_a(1.0, 0.875, 0.0, 0.0, 1.0);
                tes.func_78374_a(1.0, 0.875, 1.0, 1.0, 1.0);
                tes.func_78374_a(0.0, 0.875, 1.0, 1.0, 0.0);
                tes.func_78374_a(0.0, 0.9998, 0.0, 0.0, 0.0);
                tes.func_78374_a(0.0, 0.9998, 1.0, 1.0, 0.0);
                tes.func_78374_a(1.0, 0.9998, 1.0, 1.0, 1.0);
                tes.func_78374_a(1.0, 0.9998, 0.0, 0.0, 1.0);
                tes.func_78381_a();
                tes.func_78382_b();
                Minecraft.func_71410_x().func_110434_K().func_110577_a(sides[3] == 0 ? this.none : (sides[3] == 1 ? this.input : this.output));
                tes.func_78374_a(0.0, 0.0, 2.0E-4, 0.0, 0.0);
                tes.func_78374_a(0.0, 1.0, 2.0E-4, 0.0, 1.0);
                tes.func_78374_a(1.0, 1.0, 2.0E-4, 1.0, 1.0);
                tes.func_78374_a(1.0, 0.0, 2.0E-4, 1.0, 0.0);
                tes.func_78374_a(0.0, 1.0, 0.125, 0.0, 1.0);
                tes.func_78374_a(0.0, 0.0, 0.125, 0.0, 0.0);
                tes.func_78374_a(1.0, 0.0, 0.125, 1.0, 0.0);
                tes.func_78374_a(1.0, 1.0, 0.125, 1.0, 1.0);
                tes.func_78381_a();
                tes.func_78382_b();
                Minecraft.func_71410_x().func_110434_K().func_110577_a(sides[2] == 0 ? this.none : (sides[2] == 1 ? this.input : this.output));
                tes.func_78374_a(0.0, 0.0, 0.875, 0.0, 0.0);
                tes.func_78374_a(0.0, 1.0, 0.875, 0.0, 1.0);
                tes.func_78374_a(1.0, 1.0, 0.875, 1.0, 1.0);
                tes.func_78374_a(1.0, 0.0, 0.875, 1.0, 0.0);
                tes.func_78374_a(0.0, 1.0, 0.9998, 0.0, 1.0);
                tes.func_78374_a(0.0, 0.0, 0.9998, 0.0, 0.0);
                tes.func_78374_a(1.0, 0.0, 0.9998, 1.0, 0.0);
                tes.func_78374_a(1.0, 1.0, 0.9998, 1.0, 1.0);
                tes.func_78381_a();
                tes.func_78382_b();
                Minecraft.func_71410_x().func_110434_K().func_110577_a(sides[4] == 0 ? this.none : (sides[4] == 1 ? this.input : this.output));
                tes.func_78374_a(2.0E-4, 0.0, 0.0, 1.0, 1.0);
                tes.func_78374_a(2.0E-4, 0.0, 1.0, 1.0, 0.0);
                tes.func_78374_a(2.0E-4, 1.0, 1.0, 0.0, 0.0);
                tes.func_78374_a(2.0E-4, 1.0, 0.0, 0.0, 1.0);
                tes.func_78374_a(0.125, 0.0, 1.0, 1.0, 0.0);
                tes.func_78374_a(0.125, 0.0, 0.0, 1.0, 1.0);
                tes.func_78374_a(0.125, 1.0, 0.0, 0.0, 1.0);
                tes.func_78374_a(0.125, 1.0, 1.0, 0.0, 0.0);
                tes.func_78381_a();
                tes.func_78382_b();
                Minecraft.func_71410_x().func_110434_K().func_110577_a(sides[5] == 0 ? this.none : (sides[5] == 1 ? this.input : this.output));
                tes.func_78374_a(0.875, 0.0, 0.0, 1.0, 1.0);
                tes.func_78374_a(0.875, 0.0, 1.0, 1.0, 0.0);
                tes.func_78374_a(0.875, 1.0, 1.0, 0.0, 0.0);
                tes.func_78374_a(0.875, 1.0, 0.0, 0.0, 1.0);
                tes.func_78374_a(0.9998, 0.0, 1.0, 1.0, 0.0);
                tes.func_78374_a(0.9998, 0.0, 0.0, 1.0, 1.0);
                tes.func_78374_a(0.9998, 1.0, 0.0, 0.0, 1.0);
                tes.func_78374_a(0.9998, 1.0, 1.0, 0.0, 0.0);
                tes.func_78381_a();
            }
            RenderHelper.finishRender();
        }
    }

    public static class EntityNode
    extends TileEntitySpecialRenderer {
        public ModelEntityNode model = new ModelEntityNode();
        public String texture = "PracticalLogistics:textures/model/entity_node.png";
        public ModelDataCable modelCable = new ModelDataCable();
        public String textureCable = "PracticalLogistics:textures/model/dataCable.png";

        public void func_147500_a(TileEntity entity, double x, double y, double z, float f) {
            RenderHelper.beginRender((double)(x + 0.5), (double)(y + 1.5), (double)(z + 0.5), (int)0, (String)this.textureCable);
            this.modelCable.renderTile(entity, null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f, CableType.NONE);
            RenderHelper.finishRender();
            RenderHelper.beginRender((double)(x + 0.5), (double)(y + 1.5), (double)(z + 0.5), (int)RenderHelper.setMetaData((TileEntity)entity), (String)this.texture);
            this.model.renderTile((TileEntityEntityNode)entity, null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
            RenderHelper.finishRender();
        }
    }

    public static class Hammer
    extends TileEntitySpecialRenderer {
        public ModelHammer model = new ModelHammer();
        public String texture = "PracticalLogistics:textures/model/hammer.png";
        public String textureNew = "PracticalLogistics:textures/model/hammer_machine.png";
        public ResourceLocation rope = new ResourceLocation("PracticalLogistics:textures/model/rope.png");

        public void func_147500_a(TileEntity entity, double x, double y, double z, float f) {
            RenderHelper.beginRender((double)(x + 0.5), (double)(y + 1.5), (double)(z + 0.5), (int)RenderHelper.setMetaData((TileEntity)entity), (String)this.textureNew);
            int progress = 0;
            boolean cooling = false;
            if (entity != null && entity.func_145831_w() != null) {
                TileEntityHammer hammer = (TileEntityHammer)entity;
                if ((Integer)hammer.coolDown.getObject() != 0) {
                    progress = (Integer)hammer.coolDown.getObject();
                    cooling = true;
                } else {
                    progress = (Integer)hammer.progress.getObject();
                }
                double move = !cooling ? (double)progress * 1.625 / (double)TileEntityHammer.speed : (double)progress * 1.625 / 200.0;
                this.model.render(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f, true, move);
            } else {
                this.model.render(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f, false, 0.0);
            }
            RenderHelper.finishRender();
            if (entity.func_145831_w() != null) {
                GL11.glTranslated((double)0.0, (double)2.75, (double)0.0);
                double height = -(!cooling ? (double)progress * 1.625 / 100.0 : (double)progress * 1.625 / 200.0);
                float width = 0.53f;
                Tessellator tessellator = Tessellator.field_78398_a;
                this.func_147499_a(this.rope);
                GL11.glTexParameterf((int)3553, (int)10242, (float)10497.0f);
                GL11.glTexParameterf((int)3553, (int)10243, (float)10497.0f);
                GL11.glTranslated((double)0.0, (double)0.7, (double)0.0);
                float f2 = 20.0f;
                float f4 = -f2 * 0.2f - (float)MathHelper.func_76141_d((float)(-f2 * 0.1f));
                boolean b0 = true;
                double d3 = (double)f2 * 0.025 * (1.0 - (double)(b0 & true) * 2.5);
                GL11.glTranslated((double)0.0, (double)-0.7, (double)0.0);
                OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                GL11.glDepthMask((boolean)true);
                tessellator.func_78382_b();
                double remain = 1.0f - width;
                double offset = 0.2;
                double d18 = height;
                double d20 = 0.0;
                double d22 = 1.0;
                double d24 = -1.0f + f4;
                double d26 = d18 + d24;
                tessellator.func_78374_a(x + remain, y + d18, z + remain, d22, d26);
                tessellator.func_78374_a(x + remain, y, z + remain, d22, d24);
                tessellator.func_78374_a(x + (double)width, y, z + remain, d20, d24);
                tessellator.func_78374_a(x + (double)width, y + d18, z + remain, d20, d26);
                tessellator.func_78374_a(x + (double)width, y + d18, z + (double)width, d22, d26);
                tessellator.func_78374_a(x + (double)width, y, z + (double)width, d22, d24);
                tessellator.func_78374_a(x + remain, y, z + (double)width, d20, d24);
                tessellator.func_78374_a(x + remain, y + d18, z + (double)width, d20, d26);
                tessellator.func_78374_a(x + (double)width, y + d18, z + remain, d22, d26);
                tessellator.func_78374_a(x + (double)width, y, z + remain, d22, d24);
                tessellator.func_78374_a(x + (double)width, y, z + (double)width, d20, d24);
                tessellator.func_78374_a(x + (double)width, y + d18, z + (double)width, d20, d26);
                tessellator.func_78374_a(x + remain, y + d18, z + (double)width, d22, d26);
                tessellator.func_78374_a(x + remain, y, z + (double)width, d22, d24);
                tessellator.func_78374_a(x + remain, y, z + remain, d20, d24);
                tessellator.func_78374_a(x + remain, y + d18, z + remain, d20, d26);
                tessellator.func_78381_a();
                GL11.glDepthMask((boolean)true);
                GL11.glTranslated((double)0.0, (double)-2.75, (double)0.0);
            }
            int[] sides = new int[6];
            GL11.glPushMatrix();
            GL11.glTranslated((double)x, (double)y, (double)z);
            if (entity != null && entity.func_145831_w() != null && entity instanceof TileEntityHammer) {
                TileEntityHammer hammer = (TileEntityHammer)entity;
                ItemStack target = null;
                if ((progress == 0 || cooling) && hammer.func_70301_a(1) != null) {
                    target = hammer.func_70301_a(1);
                } else if (!cooling) {
                    target = hammer.func_70301_a(0);
                }
                if (target != null) {
                    if (!(target.func_77973_b() instanceof ItemBlock)) {
                        GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                        GL11.glTranslated((double)0.5, (double)0.3, (double)-0.885);
                    } else {
                        GL11.glRotated((double)90.0, (double)-1.0, (double)0.0, (double)0.0);
                        GL11.glTranslated((double)0.5, (double)-0.7, (double)0.92);
                        if (!cooling && progress > 81 || cooling && progress / 2 - 10 > 81) {
                            if (cooling) {
                                progress = progress / 2 - 10;
                            }
                            GL11.glTranslated((double)0.0, (double)0.0, (double)(-((double)(progress - 81) * 0.085 / (double)(TileEntityHammer.speed - 81))));
                            GL11.glScaled((double)1.0, (double)1.0, (double)(1.0 - (double)(progress - 81) * 0.85 / (double)(TileEntityHammer.speed - 81)));
                        }
                    }
                    RenderHelper.renderItem((World)entity.func_145831_w(), (ItemStack)target);
                }
            }
            GL11.glPopMatrix();
        }
    }

    public static class RedstoneSignaller
    extends TileEntitySpecialRenderer {
        public ModelRedstoneSignaller model = new ModelRedstoneSignaller();
        public String onTex = "PracticalLogistics:textures/model/redstoneEmitter_on.png";
        public String offTex = "PracticalLogistics:textures/model/redstoneEmitter_off.png";

        public void func_147500_a(TileEntity entity, double x, double y, double z, float f) {
            Block block;
            boolean on = false;
            if (entity != null && entity.func_145831_w() != null && (block = entity.func_145838_q()) == BlockRegistry.redstoneSignaller_on) {
                on = true;
            }
            RenderHelper.beginRender((double)(x + 0.5), (double)(y + 1.5), (double)(z + 0.5), (int)RenderHelper.setMetaData((TileEntity)entity), (String)(on ? this.onTex : this.offTex));
            GL11.glTranslated((double)0.0, (double)-0.0625, (double)0.0);
            GL11.glRotated((double)180.0, (double)0.0, (double)1.0, (double)0.0);
            this.model.func_78088_a(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
            RenderHelper.finishRender();
        }
    }

    public static class DataEmitter
    extends TileEntitySpecialRenderer {
        public ModelDataReceiver model = new ModelDataReceiver();
        public String texture = "PracticalLogistics:textures/model/blockEmitter.png";

        public void func_147500_a(TileEntity entity, double x, double y, double z, float f) {
            RenderHelper.beginRender((double)(x + 0.5), (double)(y + 1.5), (double)(z + 0.5), (int)RenderHelper.setMetaData((TileEntity)entity), (String)this.texture);
            GL11.glTranslated((double)0.0, (double)-0.0625, (double)0.0);
            GL11.glRotated((double)180.0, (double)0.0, (double)1.0, (double)0.0);
            this.model.func_78088_a(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
            RenderHelper.finishRender();
        }
    }

    public static class DataReceiver
    extends TileEntitySpecialRenderer {
        public ModelDataReceiver model = new ModelDataReceiver();
        public String texture = "PracticalLogistics:textures/model/blockReceiver.png";

        public void func_147500_a(TileEntity entity, double x, double y, double z, float f) {
            RenderHelper.beginRender((double)(x + 0.5), (double)(y + 1.5), (double)(z + 0.5), (int)RenderHelper.setMetaData((TileEntity)entity), (String)this.texture);
            GL11.glTranslated((double)0.0, (double)-0.0625, (double)0.0);
            this.model.func_78088_a(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
            RenderHelper.finishRender();
        }
    }

    public static class EnergyReader
    extends InfoReader {
        public EnergyReader() {
            this.texture = "PracticalLogistics:textures/model/energyReader.png";
        }
    }

    public static class FluidReader
    extends InfoReader {
        public FluidReader() {
            this.texture = "PracticalLogistics:textures/model/fluidReader.png";
        }
    }

    public static class InventoryReader
    extends InfoReader {
        public InventoryReader() {
            this.texture = "PracticalLogistics:textures/model/inventoryReader.png";
        }
    }

    public static class InfoReader
    extends TileEntitySpecialRenderer {
        public ModelDirectionalConnector model = new ModelDirectionalConnector();
        public String texture = "PracticalLogistics:textures/model/infoNode.png";

        public void func_147500_a(TileEntity entity, double x, double y, double z, float f) {
            RenderHelper.beginRender((double)(x + 0.5), (double)(y + 1.5), (double)(z + 0.5), (int)RenderHelper.setMetaData((TileEntity)entity), (String)this.texture);
            if (entity != null && entity.func_145831_w() != null) {
                int meta = FMPHelper.getMeta((TileEntity)entity);
                if (meta == 0) {
                    GL11.glTranslated((double)0.0, (double)1.0, (double)-1.0625);
                    GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                } else if (meta == 1) {
                    GL11.glRotated((double)90.0, (double)-1.0, (double)0.0, (double)0.0);
                    GL11.glTranslated((double)0.0, (double)-1.0625, (double)1.0);
                } else {
                    GL11.glTranslated((double)0.0, (double)-0.0625, (double)0.0);
                }
            }
            this.model.func_78088_a(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
            RenderHelper.finishRender();
        }
    }

    public static class InfoCreator
    extends TileEntitySpecialRenderer {
        public ModelDataCable modelCable = new ModelDataCable();
        public String cableTex = "PracticalLogistics:textures/model/dataCable.png";
        public ModelInfoCreator model = new ModelInfoCreator();
        public String modelTex = "PracticalLogistics:textures/model/infoCreator.png";

        public void func_147500_a(TileEntity entity, double x, double y, double z, float f) {
            RenderHelper.beginRender((double)(x + 0.5), (double)(y + 1.5), (double)(z + 0.5), (int)0, (String)this.cableTex);
            this.modelCable.renderTile(entity, null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f, CableType.NONE);
            RenderHelper.finishRender();
            RenderHelper.beginRender((double)(x + 0.5), (double)(y + 1.5), (double)(z + 0.5), (int)RenderHelper.setMetaData((TileEntity)entity), (String)this.modelTex);
            GL11.glTranslated((double)0.0, (double)0.0625, (double)0.0);
            this.model.func_78088_a(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
            RenderHelper.finishRender();
        }
    }

    public static class DataModifier
    extends TileEntitySpecialRenderer {
        public ModelDataCable modelCable = new ModelDataCable();
        public String cableTex = "PracticalLogistics:textures/model/dataCable.png";
        public ModelDataModifier model = new ModelDataModifier();
        public String modelTex = "PracticalLogistics:textures/model/dataModifier.png";

        public void func_147500_a(TileEntity entity, double x, double y, double z, float f) {
            RenderHelper.beginRender((double)(x + 0.5), (double)(y + 1.5), (double)(z + 0.5), (int)0, (String)this.cableTex);
            this.modelCable.renderTile(entity, null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f, CableType.NONE);
            RenderHelper.finishRender();
            RenderHelper.beginRender((double)(x + 0.5), (double)(y + 1.5), (double)(z + 0.5), (int)RenderHelper.setMetaData((TileEntity)entity), (String)this.modelTex);
            GL11.glTranslated((double)0.0, (double)0.0625, (double)0.0);
            this.model.func_78088_a(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
            RenderHelper.finishRender();
        }
    }

    public static class ChannelledCable
    extends TileEntitySpecialRenderer {
        public ModelDataCable model = new ModelDataCable();
        public String texture = "PracticalLogistics:textures/model/dataMultiCable.png";

        public void func_147500_a(TileEntity entity, double x, double y, double z, float f) {
            RenderHelper.beginRender((double)(x + 0.5), (double)(y + 1.5), (double)(z + 0.5), (int)0, (String)this.texture);
            this.model.renderTile(entity, null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f, CableType.CHANNELLED_CABLE);
            RenderHelper.finishRender();
        }
    }

    public static class DataCable
    extends TileEntitySpecialRenderer {
        public ModelDataCable model = new ModelDataCable();
        public String texture = "PracticalLogistics:textures/model/dataCable.png";

        public void func_147500_a(TileEntity entity, double x, double y, double z, float f) {
            RenderHelper.beginRender((double)(x + 0.5), (double)(y + 1.5), (double)(z + 0.5), (int)0, (String)this.texture);
            this.model.renderTile(entity, null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f, CableType.DATA_CABLE);
            RenderHelper.finishRender();
        }
    }

    public static class BlockNode
    extends SonarTERender {
        public BlockNode() {
            super((ModelBase)new ModelBlockNode(), "PracticalLogistics:textures/model/blockNode_black.png");
        }

        public void func_147500_a(TileEntity entity, double x, double y, double z, float f) {
            RenderHelper.beginRender((double)(x + 0.5), (double)(y + 1.5), (double)(z + 0.5), (int)0, (String)RenderHandlers.textureCable);
            modelCable.renderTile(entity, null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f, CableType.NONE);
            RenderHelper.finishRender();
            RenderHelper.beginRender((double)(x + 0.5), (double)(y + 1.5), (double)(z + 0.5), (int)RenderHelper.setMetaData((TileEntity)entity), (String)this.texture);
            if (entity != null && entity.func_145831_w() != null) {
                int meta = entity.func_145832_p();
                if (meta == 5) {
                    GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
                } else if (meta != 6) {
                    if (meta == 4) {
                        GL11.glTranslated((double)-1.0, (double)1.0, (double)0.0);
                        GL11.glRotated((double)90.0, (double)0.0, (double)0.0, (double)-1.0);
                    } else if (meta == 3) {
                        GL11.glTranslated((double)0.0, (double)1.0, (double)-1.0);
                        GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                    } else if (meta == 2) {
                        GL11.glTranslated((double)1.0, (double)1.0, (double)0.0);
                        GL11.glRotated((double)90.0, (double)0.0, (double)0.0, (double)1.0);
                    } else if (meta == 1) {
                        GL11.glTranslated((double)1.0, (double)1.0, (double)0.0);
                        GL11.glRotated((double)90.0, (double)0.0, (double)0.0, (double)1.0);
                    } else if (meta == 0) {
                        GL11.glTranslated((double)0.0, (double)2.0, (double)0.0);
                        GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
                    } else if (meta == 7) {
                        GL11.glTranslated((double)0.0, (double)2.0, (double)0.0);
                        GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
                    }
                }
            }
            GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
            GL11.glTranslated((double)0.0, (double)1.5, (double)0.0);
            this.model.func_78088_a((Entity)null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
            RenderHelper.finishRender();
        }
    }
}

