/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.client.models;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.integration.fmp.FMPHelper;
import sonar.logistics.api.connecting.CableType;
import sonar.logistics.api.render.ICableRenderer;
import sonar.logistics.common.tileentity.TileEntityBlockNode;

public class ModelDataCable
extends ModelBase {
    ModelRenderer Bottom;
    ModelRenderer Centre;
    ModelRenderer Top;
    ModelRenderer Arm1;
    ModelRenderer Arm2;
    ModelRenderer Arm3;
    ModelRenderer Arm4;
    public ResourceLocation cable = new ResourceLocation("PracticalLogistics:textures/model/dataCable.png");
    public ResourceLocation multicable = new ResourceLocation("PracticalLogistics:textures/model/dataMultiCable.png");

    public ModelDataCable() {
        this.field_78090_t = 64;
        this.field_78089_u = 32;
        this.Bottom = new ModelRenderer((ModelBase)this, 0, 0);
        this.Bottom.func_78789_a(0.0f, 0.0f, 0.0f, 2, 6, 2);
        this.Bottom.func_78793_a(-1.0f, 24.0f, 1.0f);
        this.Bottom.func_78787_b(64, 32);
        this.Bottom.field_78809_i = true;
        this.setRotation(this.Bottom, 3.141593f, 0.0f, 0.0f);
        this.Centre = new ModelRenderer((ModelBase)this, 0, 8);
        this.Centre.func_78789_a(0.0f, 0.0f, 0.0f, 4, 4, 4);
        this.Centre.func_78793_a(-2.0f, 14.0f, -2.0f);
        this.Centre.func_78787_b(64, 32);
        this.Centre.field_78809_i = true;
        this.setRotation(this.Centre, 0.0f, 0.0f, 0.0f);
        this.Top = new ModelRenderer((ModelBase)this, 0, 0);
        this.Top.func_78789_a(0.0f, 0.0f, 0.0f, 2, 6, 2);
        this.Top.func_78793_a(-1.0f, 8.0f, -1.0f);
        this.Top.func_78787_b(64, 32);
        this.Top.field_78809_i = true;
        this.setRotation(this.Top, 0.0f, 0.0f, 0.0f);
        this.Arm1 = new ModelRenderer((ModelBase)this, 0, 0);
        this.Arm1.func_78789_a(0.0f, 0.0f, 0.0f, 2, 6, 2);
        this.Arm1.func_78793_a(1.0f, 15.0f, 8.0f);
        this.Arm1.func_78787_b(64, 32);
        this.Arm1.field_78809_i = true;
        this.setRotation(this.Arm1, -1.570796f, 0.0f, 1.570796f);
        this.Arm2 = new ModelRenderer((ModelBase)this, 0, 0);
        this.Arm2.func_78789_a(0.0f, 0.0f, 0.0f, 2, 6, 2);
        this.Arm2.func_78793_a(-8.0f, 17.0f, -1.0f);
        this.Arm2.func_78787_b(64, 32);
        this.Arm2.field_78809_i = true;
        this.setRotation(this.Arm2, 0.0f, 0.0f, -1.570796f);
        this.Arm3 = new ModelRenderer((ModelBase)this, 0, 0);
        this.Arm3.func_78789_a(0.0f, 0.0f, 0.0f, 2, 6, 2);
        this.Arm3.func_78793_a(-1.0f, 15.0f, -2.0f);
        this.Arm3.func_78787_b(64, 32);
        this.Arm3.field_78809_i = true;
        this.setRotation(this.Arm3, -1.570796f, 0.0f, 0.0f);
        this.Arm4 = new ModelRenderer((ModelBase)this, 0, 0);
        this.Arm4.func_78789_a(0.0f, 0.0f, 0.0f, 2, 6, 2);
        this.Arm4.func_78793_a(8.0f, 15.0f, 1.0f);
        this.Arm4.func_78787_b(64, 32);
        this.Arm4.field_78809_i = true;
        this.setRotation(this.Arm4, 0.0f, 1.570796f, 1.570796f);
    }

    public void renderTile(TileEntity tile, Entity entity, float f, float f1, float f2, float f3, float f4, float f5, CableType override) {
        super.func_78088_a(entity, f, f1, f2, f3, f4, f5);
        this.setRotationAngles(entity, f, f1, f2, f3, f4, f5);
        boolean blockNode = tile instanceof TileEntityBlockNode;
        if (!blockNode) {
            this.Centre.func_78785_a(f5);
        }
        Object object = FMPHelper.checkObject((Object)tile);
        if (tile.func_145831_w() != null && object instanceof ICableRenderer) {
            ICableRenderer cable = (ICableRenderer)object;
            boolean renderCentre = false;
            if (this.setTexture(cable, ForgeDirection.DOWN, override)) {
                this.Bottom.func_78785_a(f5);
                renderCentre = true;
            }
            if (this.setTexture(cable, ForgeDirection.UP, override)) {
                this.Top.func_78785_a(f5);
                renderCentre = true;
            }
            if (this.setTexture(cable, ForgeDirection.NORTH, override)) {
                this.Arm1.func_78785_a(f5);
                renderCentre = true;
            }
            if (this.setTexture(cable, ForgeDirection.WEST, override)) {
                this.Arm2.func_78785_a(f5);
                renderCentre = true;
            }
            if (this.setTexture(cable, ForgeDirection.SOUTH, override)) {
                this.Arm3.func_78785_a(f5);
                renderCentre = true;
            }
            if (this.setTexture(cable, ForgeDirection.EAST, override)) {
                this.Arm4.func_78785_a(f5);
                renderCentre = true;
            }
            if (blockNode && renderCentre) {
                this.Centre.func_78785_a(f5);
            }
        }
    }

    private boolean setTexture(ICableRenderer rend, ForgeDirection dir, CableType override) {
        CableType type = rend.canRenderConnection(dir);
        switch (type) {
            case DATA_CABLE: {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(override != CableType.NONE ? (override.equals((Object)CableType.CHANNELLED_CABLE) ? this.multicable : this.cable) : this.cable);
                return true;
            }
            case BLOCK_CONNECTION: 
            case CHANNELLED_CABLE: {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(override != CableType.NONE ? (override.equals((Object)CableType.DATA_CABLE) ? this.cable : this.multicable) : this.multicable);
                return true;
            }
        }
        return false;
    }

    private void setRotation(ModelRenderer model, float x, float y, float z) {
        model.field_78795_f = x;
        model.field_78796_g = y;
        model.field_78808_h = z;
    }

    public void setRotationAngles(Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
        super.func_78087_a(f, f1, f2, f3, f4, f5, entity);
    }
}

