/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import sonar.core.inventory.GuiSonar;
import sonar.core.inventory.SonarButtons;

public abstract class GuiSelectionList<T>
extends GuiSonar {
    public static final ResourceLocation bground = new ResourceLocation("PracticalLogistics:textures/gui/listSelection.png");
    public float currentScroll;
    private boolean isScrolling;
    private boolean wasClicking;
    public int scrollerLeft;
    public int scrollerStart;
    public int scrollerEnd;
    public int scrollerWidth;

    public GuiSelectionList(Container container, TileEntity entity) {
        super(container, entity);
    }

    public abstract List<T> getSelectionList();

    public abstract T getCurrentSelection();

    public abstract boolean isEqualSelection(T var1, T var2);

    public abstract void renderStrings(int var1, int var2);

    public abstract void renderSelection(T var1, boolean var2, int var3);

    public abstract void sendPacket(T var1);

    public int getSelectionSize() {
        return this.getSelectionList() == null ? 0 : this.getSelectionList().size();
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146297_k.field_71439_g.field_71070_bA = this.field_147002_h;
        this.field_146999_f = 248;
        this.field_147000_g = 166;
        this.field_147003_i = (this.field_146294_l - this.field_146999_f) / 2;
        this.field_147009_r = (this.field_146295_m - this.field_147000_g) / 2;
        this.scrollerLeft = this.field_147003_i + 164 + 72;
        this.scrollerStart = this.field_147009_r + 29;
        this.scrollerEnd = this.scrollerStart + 134;
        this.scrollerWidth = 10;
        int offsetTop = 29;
        if (this.getViewableSize() == 7) {
            offsetTop += 2;
        }
        for (int i = 0; i < this.getViewableSize(); ++i) {
            this.field_146292_n.add(new SelectionButton(i, this.field_147003_i + 7, this.field_147009_r + offsetTop + i * this.getSelectionHeight()));
        }
    }

    public int getDataPosition() {
        if (this.getSelectionList() == null) {
            return -1;
        }
        if (this.getCurrentSelection() == null) {
            return -1;
        }
        int start = (int)((float)this.getSelectionSize() * this.currentScroll);
        int finish = Math.min(start + this.getViewableSize(), this.getSelectionSize());
        for (int i = start; i < finish; ++i) {
            T info;
            if (this.getSelectionList().get(i) == null || !this.isEqualSelection(info = this.getSelectionList().get(i), this.getCurrentSelection())) continue;
            return i - start;
        }
        return -1;
    }

    public void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        this.renderStrings(x, y);
        if (this.getSelectionList() != null) {
            int start = (int)((float)this.getSelectionSize() * this.currentScroll);
            int finish = Math.min(start + this.getViewableSize(), this.getSelectionSize());
            int pos = this.getDataPosition();
            for (int i = start; i < finish; ++i) {
                T selection = this.getSelectionList().get(i);
                if (selection == null) continue;
                boolean isSelected = pos == i - start;
                this.renderSelection(selection, isSelected, i - start);
            }
        }
    }

    public void func_146274_d() {
        super.func_146274_d();
        float lastScroll = this.currentScroll;
        int i = Mouse.getEventDWheel();
        if (i != 0 && this.needsScrollBars()) {
            int j = this.getSelectionSize() + 1;
            if (i > 0) {
                i = 1;
            }
            if (i < 0) {
                i = -1;
            }
            this.currentScroll = (float)((double)this.currentScroll - (double)i / (double)j);
            if (this.currentScroll < 0.0f) {
                this.currentScroll = 0.0f;
            }
            if (this.currentScroll > 1.0f) {
                this.currentScroll = 1.0f;
            }
        }
    }

    public void func_73863_a(int x, int y, float var) {
        super.func_73863_a(x, y, var);
        float lastScroll = this.currentScroll;
        boolean flag = Mouse.isButtonDown((int)0);
        if (!this.wasClicking && flag && x >= this.scrollerLeft && y >= this.scrollerStart && x < this.scrollerLeft + this.scrollerWidth && y < this.scrollerEnd) {
            this.isScrolling = this.needsScrollBars();
        }
        if (!flag) {
            this.isScrolling = false;
        }
        this.wasClicking = flag;
        if (this.isScrolling) {
            this.currentScroll = ((float)(y - this.scrollerStart) - 7.5f) / ((float)(this.scrollerEnd - this.scrollerStart) - 15.0f);
            if (this.currentScroll < 0.0f) {
                this.currentScroll = 0.0f;
            }
            if (this.currentScroll > 1.0f) {
                this.currentScroll = 1.0f;
            }
        }
    }

    protected void func_146284_a(GuiButton button) {
        int start;
        int network;
        if (button != null && button.field_146127_k < this.getViewableSize() && this.getSelectionList() != null && (network = (start = (int)((float)this.getSelectionSize() * this.currentScroll)) + button.field_146127_k) < this.getSelectionSize() && this.getSelectionList().get(network) != null) {
            this.sendPacket(this.getSelectionList().get(network));
        }
    }

    protected void func_146976_a(float var1, int var2, int var3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.getBackground());
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        this.func_73729_b(this.scrollerLeft, this.scrollerStart + (int)((float)(this.scrollerEnd - this.scrollerStart - 17) * this.currentScroll), 248, 0, 8, 15);
        int pos = this.getDataPosition();
        int offsetTop = 29;
        if (this.getViewableSize() == 7) {
            offsetTop += 2;
        }
        for (int i = 0; i < this.getViewableSize(); ++i) {
            this.drawSelectionBackground(offsetTop, i, pos);
        }
    }

    public void drawSelectionBackground(int offsetTop, int i, int pos) {
        this.func_73729_b(this.field_147003_i + 7, this.field_147009_r + offsetTop + this.getSelectionHeight() * i, 0, i == pos ? 166 + this.getSelectionHeight() : 166, 226, this.getSelectionHeight());
    }

    public int getViewableSize() {
        return 11;
    }

    public int getSelectionHeight() {
        return 12;
    }

    private boolean needsScrollBars() {
        return this.getSelectionSize() > this.getViewableSize();
    }

    public ResourceLocation getBackground() {
        return bground;
    }

    @SideOnly(value=Side.CLIENT)
    public class SelectionButton
    extends SonarButtons.ImageButton {
        public SelectionButton(int id, int x, int y) {
            super(id, x, y, GuiSelectionList.this.getBackground(), 0, 202, 226, GuiSelectionList.this.getSelectionHeight());
        }
    }
}

