/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.client.gui;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import sonar.core.inventory.GuiSonar;

public abstract class GuiSelectionGrid<T>
extends GuiSonar {
    public static final ResourceLocation bground = new ResourceLocation("PracticalLogistics:textures/gui/gridSelection.png");
    public static final ResourceLocation sorting_icons = new ResourceLocation("PracticalLogistics:textures/gui/sorting_icons.png");
    public TileEntity tile;
    public int xCoord;
    public int yCoord;
    public int zCoord;
    public float currentScroll;
    public boolean isScrolling;
    public boolean wasClicking;
    public int scrollerLeft;
    public int scrollerStart;
    public int scrollerEnd;
    public int scrollerWidth;

    public abstract void onGridClicked(T var1, int var2, int var3, boolean var4);

    public abstract void renderSelection(T var1, int var2, int var3);

    public abstract void renderStrings(int var1, int var2);

    public abstract void renderToolTip(T var1, int var2, int var3);

    public abstract List<T> getGridList();

    public int getGridSize() {
        return this.getGridList() == null ? 0 : this.getGridList().size();
    }

    private boolean needsScrollBars() {
        return this.getGridSize() > 84;
    }

    public GuiSelectionGrid(Container container, TileEntity entity) {
        super(container, entity);
        this.xCoord = entity.field_145851_c;
        this.yCoord = entity.field_145848_d;
        this.zCoord = entity.field_145849_e;
        this.tile = entity;
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146297_k.field_71439_g.field_71070_bA = this.field_147002_h;
        this.field_146999_f = 248;
        this.field_147000_g = 256;
        this.field_147003_i = (this.field_146294_l - this.field_146999_f) / 2;
        this.field_147009_r = (this.field_146295_m - this.field_147000_g) / 2;
        this.scrollerLeft = this.field_147003_i + 164 + 68;
        this.scrollerStart = this.field_147009_r + 31;
        this.scrollerEnd = this.scrollerStart + 128;
        this.scrollerWidth = 10;
    }

    protected void func_73864_a(int x, int y, int button) {
        super.func_73864_a(x, y, button);
        if ((button == 0 || button == 1) && x - this.field_147003_i >= 13 && x - this.field_147003_i <= 229 && y - this.field_147009_r >= 32 && y - this.field_147009_r <= 158) {
            T storedStack;
            int X;
            int Y;
            int start = (int)((float)(this.getGridSize() / 12) * this.currentScroll);
            int i = start * 12 + 12 * (Y = (y - this.field_147009_r - 32) / 18) + (X = (x - this.field_147003_i - 13) / 18);
            if (i < this.getGridList().size() && (storedStack = this.getGridList().get(i)) != null) {
                this.onGridClicked(storedStack, i, button, false);
                return;
            }
            this.onGridClicked(null, i, button, true);
        }
    }

    public void func_146979_b(int x, int y) {
        int start;
        RenderHelper.func_74520_c();
        this.renderStrings(x, y);
        this.preRender();
        List<T> list = this.getGridList();
        if (list != null) {
            start = (int)((float)(this.getGridSize() / 12) * this.currentScroll);
            int i = start * 12;
            int finish = Math.min(i + 84, this.getGridSize());
            for (int Y = 0; Y < 7; ++Y) {
                for (int X = 0; X < 12; ++X) {
                    T selection;
                    if (i < finish && (selection = list.get(i)) != null) {
                        this.renderSelection(selection, X, Y);
                    }
                    ++i;
                }
            }
        }
        this.postRender();
        if (x - this.field_147003_i >= 13 && x - this.field_147003_i <= 229 && y - this.field_147009_r >= 32 && y - this.field_147009_r <= 158) {
            T selection;
            start = (int)((float)(this.getGridSize() / 12) * this.currentScroll);
            int X = (x - this.field_147003_i - 13) / 18;
            int Y = (y - this.field_147009_r - 32) / 18;
            int i = start * 12 + X + Y * 12;
            if (list != null && i < list.size() && (selection = list.get(i)) != null) {
                GL11.glDisable((int)2929);
                GL11.glDisable((int)2896);
                this.renderToolTip(selection, x - this.field_147003_i, y - this.field_147009_r);
                GL11.glEnable((int)2896);
                GL11.glEnable((int)2929);
                RenderHelper.func_74520_c();
            }
        }
        super.func_146979_b(x, y);
    }

    public void preRender() {
    }

    public void postRender() {
    }

    public void func_146274_d() {
        super.func_146274_d();
        float lastScroll = this.currentScroll;
        int i = Mouse.getEventDWheel();
        if (i != 0 && this.needsScrollBars()) {
            int j = this.getGridSize() + 1;
            if (i > 0) {
                i = 1;
            }
            if (i < 0) {
                i = -1;
            }
            this.currentScroll = (float)((double)this.currentScroll - (double)i / (double)j);
            if (this.currentScroll < 0.0f) {
                this.currentScroll = 0.0f;
            }
            if (this.currentScroll > 1.0f) {
                this.currentScroll = 1.0f;
            }
        }
    }

    public void func_73863_a(int x, int y, float var) {
        super.func_73863_a(x, y, var);
        float lastScroll = this.currentScroll;
        boolean flag = Mouse.isButtonDown((int)0);
        if (!this.wasClicking && flag && x >= this.scrollerLeft && y >= this.scrollerStart && x < this.scrollerLeft + this.scrollerWidth && y < this.scrollerEnd) {
            this.isScrolling = this.needsScrollBars();
        }
        if (!flag) {
            this.isScrolling = false;
        }
        this.wasClicking = flag;
        if (this.isScrolling) {
            this.currentScroll = ((float)(y - this.scrollerStart) - 7.5f) / ((float)(this.scrollerEnd - this.scrollerStart) - 15.0f);
            if (this.currentScroll < 0.0f) {
                this.currentScroll = 0.0f;
            }
            if (this.currentScroll > 1.0f) {
                this.currentScroll = 1.0f;
            }
        }
    }

    protected void func_146976_a(float var1, int var2, int var3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.getBackground());
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        this.func_73729_b(this.scrollerLeft, this.scrollerStart + (int)((float)(this.scrollerEnd - this.scrollerStart - 17) * this.currentScroll), 248, 0, 8, 15);
    }

    public ResourceLocation getBackground() {
        return bground;
    }
}

