/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.client.gui;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import sonar.core.SonarCore;
import sonar.core.helpers.FontHelper;
import sonar.core.inventory.GuiSonar;
import sonar.core.network.PacketByteBufServer;
import sonar.core.network.PacketTextField;
import sonar.core.network.utils.IByteBufTile;
import sonar.logistics.common.containers.ContainerEmptySync;
import sonar.logistics.common.tileentity.TileEntityRedstoneSignaller;

public abstract class GuiRedstoneSignaller
extends GuiSonar {
    public static final ResourceLocation bground = new ResourceLocation("PracticalLogistics:textures/gui/signaller.png");
    private GuiTextField stringField;
    private GuiTextField integerField;
    private int type;

    public GuiRedstoneSignaller(Container container, TileEntity entity) {
        super(container, entity);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146297_k.field_71439_g.field_71070_bA = this.field_147002_h;
        this.field_146999_f = 176;
        this.field_147000_g = 80;
        this.field_147003_i = (this.field_146294_l - this.field_146999_f) / 2;
        this.field_147009_r = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146292_n.add(new GuiButton(0, this.field_147003_i + 80, this.field_147009_r + 6, 60, 20, this.getSyncType()));
        this.type = this.getGuiType();
        if (this.type == 0) {
            this.integerField = new GuiTextField(this.field_146289_q, 96, 47, 70, 12);
            this.integerField.func_146203_f(9);
            this.integerField.func_146180_a("" + this.getInteger());
            this.field_146292_n.add(new GuiButton(1, this.field_147003_i + 68, this.field_147009_r + 43, 20, 20, this.getIntegerTypeString()));
        } else {
            this.stringField = new GuiTextField(this.field_146289_q, 6, 47, 164, 12);
            this.stringField.func_146203_f(30);
            this.stringField.func_146180_a(this.getString());
        }
    }

    public String getErrorFlagString() {
        int type = this.getErrorFlag();
        switch (type) {
            case 0: {
                return " ";
            }
            case 1: {
                return "ERROR: NO DATA";
            }
            case 2: {
                return "ERROR: INCOMPATIBLE DATA";
            }
        }
        return null;
    }

    public String getIntegerTypeString() {
        int type = this.getIntegerType();
        switch (type) {
            case 0: {
                return "==";
            }
            case 1: {
                return ">";
            }
            case 2: {
                return "<";
            }
            case 3: {
                return "!=";
            }
        }
        return null;
    }

    public String getSyncType() {
        int type = this.getGuiType();
        switch (type) {
            case 0: {
                return "NUMBER";
            }
            case 1: {
                return "WORD";
            }
        }
        return null;
    }

    public void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        FontHelper.text((String)"Data Type:", (int)26, (int)12, (int)0);
        if (this.type == 0) {
            FontHelper.textCentre((String)"Emits if", (int)this.field_146999_f, (int)32, (int)0);
            FontHelper.text((String)"INPUT DATA", (int)6, (int)49, (int)0);
            this.integerField.func_146194_f();
        } else {
            FontHelper.textCentre((String)"Emits if data equals", (int)this.field_146999_f, (int)32, (int)0);
            this.stringField.func_146194_f();
        }
        FontHelper.textCentre((String)this.getErrorFlagString(), (int)this.field_146999_f, (int)66, (int)1);
    }

    protected void func_73864_a(int i, int j, int k) {
        super.func_73864_a(i, j, k);
        if (this.type == 0) {
            this.integerField.func_146192_a(i - this.field_147003_i, j - this.field_147009_r, k);
        } else {
            this.stringField.func_146192_a(i - this.field_147003_i, j - this.field_147009_r, k);
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button != null) {
            if (button.field_146127_k == 0) {
                this.changeGuiType();
            } else if (button.field_146127_k == 1) {
                this.changeIntegerType();
            }
        }
        this.reset();
    }

    protected void func_73869_a(char c, int i) {
        if (this.type == 0 && this.integerField.func_146206_l()) {
            if (c == '\r' || c == '\u001b') {
                this.integerField.func_146195_b(false);
            } else {
                FontHelper.addDigitsToString((GuiTextField)this.integerField, (char)c, (int)i);
                String text = this.integerField.func_146179_b();
                if (text.isEmpty() || text == "" || text == null) {
                    this.setInteger("0");
                } else {
                    this.setInteger(text);
                }
            }
        } else if (this.type == 1 && this.stringField.func_146206_l()) {
            if (c == '\r' || c == '\u001b') {
                this.stringField.func_146195_b(false);
            } else {
                this.stringField.func_146201_a(c, i);
                String text = this.stringField.func_146179_b();
                if (text.isEmpty() || text == "" || text == null) {
                    this.setString("Unnamed Emitter");
                } else {
                    this.setString(text);
                }
            }
        } else {
            super.func_73869_a(c, i);
        }
    }

    public ResourceLocation getBackground() {
        return bground;
    }

    public abstract String getString();

    public abstract int getInteger();

    public abstract void setString(String var1);

    public abstract void setInteger(String var1);

    public abstract void changeGuiType();

    public abstract void changeIntegerType();

    public abstract int getGuiType();

    public abstract int getIntegerType();

    public abstract int getErrorFlag();

    public static class RedstoneSignaller
    extends GuiRedstoneSignaller {
        public TileEntityRedstoneSignaller entity;

        public RedstoneSignaller(TileEntityRedstoneSignaller entity) {
            super((Container)new ContainerEmptySync((TileEntity)entity), (TileEntity)entity);
            this.entity = entity;
        }

        @Override
        public String getString() {
            return (String)this.entity.stringName.getObject();
        }

        @Override
        public void setString(String string) {
            SonarCore.network.sendToServer((IMessage)new PacketTextField(string, this.entity.field_145851_c, this.entity.field_145848_d, this.entity.field_145849_e, 1));
            this.entity.stringName.setObject((Object)string);
        }

        @Override
        public void changeGuiType() {
            if ((Integer)this.entity.dataType.getObject() <= 0) {
                this.entity.dataType.increaseBy(1);
            } else {
                this.entity.dataType.setObject((Object)0);
            }
            SonarCore.network.sendToServer((IMessage)new PacketByteBufServer((IByteBufTile)this.entity, this.entity.field_145851_c, this.entity.field_145848_d, this.entity.field_145849_e, 0));
        }

        @Override
        public void changeIntegerType() {
            if ((Integer)this.entity.integerEmitType.getObject() <= 2) {
                this.entity.integerEmitType.increaseBy(1);
            } else {
                this.entity.integerEmitType.setObject((Object)0);
            }
            SonarCore.network.sendToServer((IMessage)new PacketByteBufServer((IByteBufTile)this.entity, this.entity.field_145851_c, this.entity.field_145848_d, this.entity.field_145849_e, 1));
        }

        @Override
        public int getGuiType() {
            return (Integer)this.entity.dataType.getObject();
        }

        @Override
        public int getInteger() {
            return (Integer)this.entity.integerTarget.getObject();
        }

        @Override
        public void setInteger(String string) {
            SonarCore.network.sendToServer((IMessage)new PacketTextField(string, this.entity.field_145851_c, this.entity.field_145848_d, this.entity.field_145849_e, 0));
            this.entity.integerTarget.setObject((Object)Integer.parseInt(string));
        }

        @Override
        public int getIntegerType() {
            return (Integer)this.entity.integerEmitType.getObject();
        }

        @Override
        public int getErrorFlag() {
            return (Integer)this.entity.errorFlag.getObject();
        }
    }
}

