/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.client.gui;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import sonar.core.SonarCore;
import sonar.core.helpers.FontHelper;
import sonar.core.inventory.GuiSonar;
import sonar.core.inventory.SonarButtons;
import sonar.core.network.PacketByteBufServer;
import sonar.core.network.utils.IByteBufTile;
import sonar.logistics.Logistics;
import sonar.logistics.api.utils.ItemFilter;
import sonar.logistics.common.containers.ContainerItemRouter;
import sonar.logistics.common.handlers.ItemRouterHandler;
import sonar.logistics.common.tileentity.TileEntityItemRouter;
import sonar.logistics.info.filters.items.ItemStackFilter;
import sonar.logistics.info.filters.items.OreDictionaryFilter;
import sonar.logistics.network.packets.PacketRouterGui;

public class GuiItemRouter
extends GuiSonar {
    public static final ResourceLocation bground = new ResourceLocation("PracticalLogistics:textures/gui/itemRouter.png");
    public static final ResourceLocation itemFilter = new ResourceLocation("PracticalLogistics:textures/gui/itemRouter_item.png");
    public static final int MAIN = 0;
    public static final int ITEM = 1;
    public static final int ORE = 2;
    public TileEntityItemRouter tile;
    public EntityPlayer player;
    public ItemRouterHandler handler;
    private float currentScroll;
    private boolean isScrolling;
    private boolean wasClicking;
    public int scrollerLeft;
    public int scrollerStart;
    public int scrollerEnd;
    public int scrollerWidth;
    public int cycle;
    private GuiButton rselectButton;
    private GuiTextField oreDictField;
    boolean switching = true;
    public int state = 0;

    public GuiItemRouter(ItemRouterHandler handler, TileEntityItemRouter entity, EntityPlayer player) {
        super((Container)new ContainerItemRouter(entity, player.field_71071_by), (TileEntity)entity);
        this.handler = handler;
        this.tile = entity;
        this.player = player;
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)false);
        this.switching = true;
        this.currentScroll = 0.0f;
        this.field_146297_k.field_71439_g.field_71070_bA = this.field_147002_h;
        if (this.state == 0) {
            this.field_146999_f = 176;
            this.field_147000_g = 233;
        }
        if (this.state == 1 || this.state == 2) {
            this.field_146999_f = 176;
            this.field_147000_g = 138;
        }
        this.field_147003_i = (this.field_146294_l - this.field_146999_f) / 2;
        this.field_147009_r = (this.field_146295_m - this.field_147000_g) / 2;
        if (this.state == 0) {
            this.scrollerLeft = this.field_147003_i + 157;
            this.scrollerStart = this.field_147009_r + 33;
            this.scrollerEnd = this.scrollerStart + 92;
            this.scrollerWidth = 10;
            this.field_146292_n.add(new SideButton(0, this.field_147003_i + 9, this.field_147009_r + 20, 47, 12, ForgeDirection.getOrientation((int)((Integer)this.handler.side.getObject())).name()));
            for (int i = 1; i < 8; ++i) {
                this.field_146292_n.add(new ListButton(i, this.field_147003_i + 57 + (i - 1) * 14, this.field_147009_r + 20));
            }
        } else if (this.state == 1) {
            for (int i = 0; i < 6; ++i) {
                this.field_146292_n.add(new FilterButton(i, this.field_147003_i + 46 + i * 22, this.field_147009_r + 23));
            }
            this.field_146292_n.add(new SideButton(6, this.field_147003_i + 6, this.field_147009_r + 6, 34, 12, "DONE"));
        } else if (this.state == 2) {
            Keyboard.enableRepeatEvents((boolean)true);
            this.oreDictField = new GuiTextField(this.field_146289_q, 44, 25, 109, 12);
            this.oreDictField.func_146203_f(20);
            this.oreDictField.func_146180_a(this.handler.clientOreFilter.oreDict);
            this.field_146292_n.add(new SideButton(12, this.field_147003_i + 6, this.field_147009_r + 6, 34, 12, "DONE"));
        }
        this.switching = false;
    }

    public int getFilterPosition() {
        List<ItemFilter> filters;
        List<ItemFilter> list = filters = (Integer)this.handler.listType.getObject() == 0 ? this.handler.whitelist[(Integer)this.handler.side.getObject()] : this.handler.blacklist[(Integer)this.handler.side.getObject()];
        if (filters == null) {
            return -1;
        }
        if ((Integer)this.handler.filterPos.getObject() == -1 || filters.get((Integer)this.handler.filterPos.getObject()) == null) {
            return -1;
        }
        int size = filters.size();
        int start = (int)((float)size * this.currentScroll);
        int finish = Math.min(start + 5, size);
        for (int i = start; i < finish; ++i) {
            ItemFilter filter;
            if (filters.get(i) == null || (filter = filters.get(i)) == null || !filter.equalFilter(filters.get((Integer)this.handler.filterPos.getObject()))) continue;
            return i - start;
        }
        return -1;
    }

    public void func_146979_b(int x, int y) {
        if (this.state == 0) {
            FontHelper.textCentre((String)StatCollector.func_74838_a((String)"tile.ItemRouter.name"), (int)this.field_146999_f, (int)7, (int)1);
            GL11.glTranslated((double)0.0, (double)0.5, (double)0.0);
            FontHelper.textOffsetCentre((String)ForgeDirection.getOrientation((int)((Integer)this.handler.side.getObject())).name(), (int)31, (int)22, (int)-1);
            GL11.glTranslated((double)0.0, (double)-0.5, (double)0.0);
            super.func_146979_b(x, y);
            List<ItemFilter> filters = this.handler.getFilters();
            if (filters != null) {
                OreDictionaryFilter oreFilter;
                ItemStackFilter stackFilter;
                int size = filters.size();
                int start = (int)((float)size * this.currentScroll);
                int finish = Math.min(start + 5, size);
                for (int i = start; i < finish; ++i) {
                    ItemFilter filter = filters.get(i);
                    if (filter == null) continue;
                    int colour = Color.white.getRGB();
                    String type = filter.getName() + " : " + i;
                    if (filter instanceof ItemStackFilter) {
                        stackFilter = (ItemStackFilter)filter;
                        FontHelper.textOffsetCentre((String)"Item Stack Filter", (int)90, (int)(38 + i * 18 - start * 18), (int)colour);
                        double scale = 0.5;
                        RenderItem.getInstance().func_82406_b(this.field_146289_q, this.field_146297_k.func_110434_K(), stackFilter.getFilters().get(0), 10, 34 + i * 18 - start * 18);
                    }
                    if (!(filter instanceof OreDictionaryFilter)) continue;
                    oreFilter = (OreDictionaryFilter)filter;
                    if (oreFilter.getFilters() != null && oreFilter.getFilters().size() != 0) {
                        RenderItem.getInstance().func_82406_b(this.field_146289_q, this.field_146297_k.func_110434_K(), oreFilter.getFilters().get(0), 10, 34 + i * 18 - start * 18);
                    }
                    FontHelper.textOffsetCentre((String)"Ore Dictionary Filter ", (int)90, (int)(38 + i * 18 - start * 18), (int)colour);
                }
                if (x - this.field_147003_i >= 13 && x - this.field_147003_i <= 152 && y - this.field_147009_r >= 32 && y - this.field_147009_r <= 158) {
                    int X = (x - this.field_147003_i - 13) / 18;
                    int Y = (y - this.field_147009_r - 32) / 18;
                    int i = start + Y;
                    if (i < filters.size() && Y < finish) {
                        ItemFilter filter = filters.get(i);
                        if (filter instanceof ItemStackFilter && (stackFilter = (ItemStackFilter)filter).getFilters().get(0) != null) {
                            ArrayList<String> list = new ArrayList<String>();
                            List itemTip = stackFilter.getFilters().get(0).func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, this.field_146297_k.field_71474_y.field_82882_x);
                            if (itemTip != null && itemTip.size() != 0) {
                                list.add(0, stackFilter.getFilters().get((int)0).func_77953_t().field_77937_e + (String)itemTip.get(0));
                            }
                            list.add(1, EnumChatFormatting.GRAY + "Use NBT: " + (stackFilter.matchNBT ? EnumChatFormatting.WHITE : "") + stackFilter.matchNBT);
                            list.add(2, EnumChatFormatting.GRAY + "Use OreDict: " + (stackFilter.matchOreDict ? EnumChatFormatting.WHITE : "") + stackFilter.matchOreDict);
                            list.add(3, EnumChatFormatting.GRAY + "Ignore Damage: " + (stackFilter.ignoreDamage ? EnumChatFormatting.WHITE : "") + stackFilter.ignoreDamage);
                            list.add(4, EnumChatFormatting.GRAY + "Use Modid: " + (stackFilter.matchModid ? EnumChatFormatting.WHITE : "") + stackFilter.matchModid);
                            FontRenderer font = stackFilter.getFilters().get(0).func_77973_b().getFontRenderer(stackFilter.getFilters().get(0));
                            this.drawSpecialToolTip(list, x, y, font);
                        }
                        if (filter instanceof OreDictionaryFilter && (oreFilter = (OreDictionaryFilter)filter).getFilters() != null && !oreFilter.getFilters().isEmpty() && oreFilter.getFilters().get(0) != null) {
                            ArrayList<String> list = new ArrayList<String>();
                            list.add(0, EnumChatFormatting.WHITE + "Ore String: " + EnumChatFormatting.AQUA + oreFilter.oreDict);
                            this.drawSpecialToolTip(list, x, y, null);
                        }
                    }
                }
            }
        } else if (this.state == 1) {
            FontHelper.textCentre((String)StatCollector.func_74838_a((String)"Create Item Filter"), (int)this.field_146999_f, (int)9, (int)1);
            super.func_146979_b(x, y);
        } else if (this.state == 2) {
            FontHelper.textCentre((String)StatCollector.func_74838_a((String)"Create Ore Filter"), (int)this.field_146999_f, (int)9, (int)1);
            this.oreDictField.func_146194_f();
            List<ItemStack> filters = this.handler.clientOreFilter.getFilters();
            if (filters != null && filters.size() != 0) {
                ItemStack stack = filters.get(0);
                RenderHelper.func_74520_c();
                RenderItem.getInstance().func_82406_b(this.field_146289_q, this.field_146297_k.func_110434_K(), stack, 23, 23);
                if (x - this.field_147003_i >= 23 && x - this.field_147003_i <= 39 && y - this.field_147009_r >= 23 && y - this.field_147009_r <= 39) {
                    this.drawNormalToolTip(stack, x, y);
                }
            }
            super.func_146979_b(x, y);
        }
    }

    public void func_146274_d() {
        super.func_146274_d();
        if (this.state == 0) {
            float lastScroll = this.currentScroll;
            int i = Mouse.getEventDWheel();
            if (i != 0 && this.needsScrollBars()) {
                List<ItemFilter> filters = this.handler.getFilters();
                int size = filters == null ? 0 : filters.size();
                int j = size + 1;
                if (i > 0) {
                    i = 1;
                }
                if (i < 0) {
                    i = -1;
                }
                this.currentScroll = (float)((double)this.currentScroll - (double)i / (double)j);
                if (this.currentScroll < 0.0f) {
                    this.currentScroll = 0.0f;
                }
                if (this.currentScroll > 1.0f) {
                    this.currentScroll = 1.0f;
                }
            }
        }
    }

    public void func_73863_a(int x, int y, float var) {
        super.func_73863_a(x, y, var);
        this.cycle = this.cycle < 40 ? ++this.cycle : 0;
        if (this.state == 0) {
            float lastScroll = this.currentScroll;
            boolean flag = Mouse.isButtonDown((int)0);
            if (!this.wasClicking && flag && x >= this.scrollerLeft && y >= this.scrollerStart && x < this.scrollerLeft + this.scrollerWidth && y < this.scrollerEnd) {
                this.isScrolling = this.needsScrollBars();
            }
            if (!flag) {
                this.isScrolling = false;
            }
            this.wasClicking = flag;
            if (this.isScrolling) {
                this.currentScroll = ((float)(y - this.scrollerStart) - 7.5f) / ((float)(this.scrollerEnd - this.scrollerStart) - 15.0f);
                if (this.currentScroll < 0.0f) {
                    this.currentScroll = 0.0f;
                }
                if (this.currentScroll > 1.0f) {
                    this.currentScroll = 1.0f;
                }
            }
        }
    }

    protected void func_73864_a(int x, int y, int button) {
        super.func_73864_a(x, y, button);
        if (this.state == 0 && !this.switching) {
            List<ItemFilter> filters;
            if ((button == 1 || button == 0) && (filters = this.handler.getFilters()) != null) {
                int size = filters.size();
                if (x - this.field_147003_i >= 13 && x - this.field_147003_i <= 152 && y - this.field_147009_r >= 32 && y - this.field_147009_r <= 158) {
                    int start = (int)((float)size * this.currentScroll);
                    int Y = (y - this.field_147009_r - 32) / 18;
                    int i = start + Y;
                    int finish = Math.min(start + 5, size);
                    if (Y < finish) {
                        if (button == 0 && !this.switching) {
                            this.handler.clientClick = i;
                            SonarCore.network.sendToServer((IMessage)new PacketByteBufServer((IByteBufTile)this.handler, this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e, 8));
                        } else if (i < filters.size() && filters.get(i) != null) {
                            this.handler.clientClick = i;
                            ItemFilter filter = filters.get(i);
                            if (filter instanceof ItemStackFilter) {
                                this.handler.editStack = i;
                                this.handler.editOre = -1;
                                SonarCore.network.sendToServer((IMessage)new PacketByteBufServer((IByteBufTile)this.handler, this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e, 9));
                                this.switchState(1);
                            } else {
                                this.handler.editStack = -1;
                                this.handler.editOre = i;
                                SonarCore.network.sendToServer((IMessage)new PacketByteBufServer((IByteBufTile)this.handler, this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e, 9));
                                this.switchState(2);
                            }
                        }
                    }
                }
            }
        } else if (this.state == 2) {
            this.oreDictField.func_146192_a(x - this.field_147003_i, y - this.field_147009_r, button);
        }
    }

    protected void func_146286_b(int x, int y, int id) {
        super.func_146286_b(x, y, id);
        if (this.rselectButton != null && id == 1) {
            this.rselectButton.func_146118_a(x, y);
            this.rselectButton = null;
        }
    }

    public void buttonPressed(GuiButton button, int buttonID) {
        if (button != null) {
            if (this.state == 0) {
                if (button.field_146127_k == 3) {
                    this.switchState(1);
                } else if (button.field_146127_k == 4) {
                    this.switchState(2);
                } else {
                    SonarCore.network.sendToServer((IMessage)new PacketByteBufServer((IByteBufTile)this.handler, this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e, button.field_146127_k));
                    if (button.field_146127_k == 0) {
                        this.currentScroll = 0.0f;
                        this.reset();
                    }
                    if (button.field_146127_k == 7 || button.field_146127_k == 2) {
                        this.currentScroll = 0.0f;
                    }
                }
            } else if (this.state == 1) {
                if (button.field_146127_k == 0) {
                    boolean bl = this.handler.clientStackFilter.matchNBT = !this.handler.clientStackFilter.matchNBT;
                }
                if (button.field_146127_k == 1) {
                    boolean bl = this.handler.clientStackFilter.matchOreDict = !this.handler.clientStackFilter.matchOreDict;
                }
                if (button.field_146127_k == 2) {
                    boolean bl = this.handler.clientStackFilter.ignoreDamage = !this.handler.clientStackFilter.ignoreDamage;
                }
                if (button.field_146127_k == 3) {
                    boolean bl = this.handler.clientStackFilter.matchModid = !this.handler.clientStackFilter.matchModid;
                }
                if (button.field_146127_k == 4) {
                    SonarCore.network.sendToServer((IMessage)new PacketByteBufServer((IByteBufTile)this.handler, this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e, 2));
                }
                if (button.field_146127_k == 6) {
                    this.switching = true;
                    SonarCore.network.sendToServer((IMessage)new PacketByteBufServer((IByteBufTile)this.handler, this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e, -1));
                    this.handler.editStack = -1;
                    this.switchState(0);
                }
            } else if (this.state == 2 && button.field_146127_k == 12) {
                this.switching = true;
                SonarCore.network.sendToServer((IMessage)new PacketByteBufServer((IByteBufTile)this.handler, this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e, -2));
                this.handler.editOre = -1;
                this.switchState(0);
            }
        }
    }

    public void switchState(int state) {
        this.switching = true;
        this.currentScroll = 0.0f;
        Logistics.network.sendToServer((IMessage)new PacketRouterGui(this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e, state));
        if (this.field_146297_k.field_71439_g.field_71070_bA instanceof ContainerItemRouter) {
            ((ContainerItemRouter)this.field_146297_k.field_71439_g.field_71070_bA).switchState(this.player.field_71071_by, this.tile, state);
        }
        this.field_147002_h = this.field_146297_k.field_71439_g.field_71070_bA;
        this.state = state;
        this.reset();
    }

    protected void func_146284_a(GuiButton button) {
        super.func_146284_a(button);
        this.buttonPressed(button, button.field_146127_k);
    }

    protected void func_73869_a(char c, int i) {
        if (this.state == 2 && this.oreDictField.func_146206_l()) {
            if (c == '\r' || c == '\u001b') {
                this.oreDictField.func_146195_b(false);
            } else {
                this.oreDictField.func_146201_a(c, i);
                String text = this.oreDictField.func_146179_b();
                this.handler.clientOreFilter.oreDict = text.isEmpty() || text == "" || text == null ? " " : text;
            }
        } else {
            super.func_73869_a(c, i);
        }
    }

    protected void func_146976_a(float var1, int var2, int var3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.getBackground());
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.state == 0) {
            List<ItemFilter> filters = this.handler.getFilters();
            if (filters != null) {
                int pos;
                int size = filters.size();
                int start = (int)((float)size * this.currentScroll);
                int finish = Math.min(start + 5, size);
                if ((Integer)this.handler.filterPos.getObject() != -1 && (pos = (Integer)this.handler.filterPos.getObject() - start) > -1 && (Integer)this.handler.filterPos.getObject() < finish && pos < filters.size() && filters.get(pos) != null) {
                    this.func_73729_b(this.field_147003_i + 9, this.field_147009_r + 33 + 18 * pos, 0, 233, 226, 18);
                }
            }
            this.func_73729_b(this.scrollerLeft, this.scrollerStart + (int)((float)(this.scrollerEnd - this.scrollerStart - 17) * this.currentScroll), 176, 0, 8, 15);
        }
    }

    private boolean needsScrollBars() {
        int size;
        List<ItemFilter> filters = this.handler.getFilters();
        int n = size = filters == null ? 0 : filters.size();
        return size > 5;
    }

    public ResourceLocation getBackground() {
        if (this.state == 0) {
            return bground;
        }
        return itemFilter;
    }

    @SideOnly(value=Side.CLIENT)
    public class SideButton
    extends GuiButton {
        public SideButton(int id, int x, int y, int width, int height, String tex) {
            super(id, x, y, width, height, tex);
        }

        public void func_146112_a(Minecraft minecraft, int x, int y) {
        }

        public void func_146111_b(int x, int y) {
            if (this.field_146126_j != null) {
                GuiItemRouter.this.func_146279_a(this.field_146126_j, x, y);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class FilterButton
    extends SonarButtons.AnimatedButton {
        public int field_146127_k;

        public FilterButton(int id, int x, int y) {
            super(id, x, y, itemFilter, 15, 15);
            this.field_146127_k = id;
        }

        public void func_146111_b(int x, int y) {
            String text = "BUTTON TEXT";
            ItemStackFilter filter = GuiItemRouter.this.handler.clientStackFilter;
            switch (this.field_146127_k) {
                case 0: {
                    text = (filter.matchNBT ? EnumChatFormatting.WHITE : EnumChatFormatting.GRAY) + "Use NBT: " + filter.matchNBT;
                    break;
                }
                case 1: {
                    text = (filter.matchOreDict ? EnumChatFormatting.WHITE : EnumChatFormatting.GRAY) + "Use OreDict: " + filter.matchOreDict;
                    break;
                }
                case 2: {
                    text = (filter.ignoreDamage ? EnumChatFormatting.WHITE : EnumChatFormatting.GRAY) + "Ignore Damage: " + filter.ignoreDamage;
                    break;
                }
                case 3: {
                    text = (filter.matchModid ? EnumChatFormatting.WHITE : EnumChatFormatting.GRAY) + "Use MODID: " + filter.matchModid;
                    break;
                }
                case 4: {
                    int listType = (Integer)GuiItemRouter.this.handler.listType.getObject();
                    text = listType == 0 ? "Whitelist" : "Blacklist";
                }
            }
            GuiItemRouter.this.func_146279_a(text, x, y);
        }

        public void onClicked() {
        }

        public int getTextureX() {
            boolean secondary = false;
            ItemStackFilter filter = GuiItemRouter.this.handler.clientStackFilter;
            switch (this.field_146127_k) {
                case 0: {
                    secondary = !filter.matchNBT;
                    break;
                }
                case 1: {
                    secondary = !filter.matchOreDict;
                    break;
                }
                case 2: {
                    secondary = !filter.ignoreDamage;
                    break;
                }
                case 3: {
                    secondary = !filter.matchModid;
                    break;
                }
                case 4: {
                    secondary = (Integer)GuiItemRouter.this.handler.listType.getObject() != 0;
                }
            }
            return !secondary ? 176 : 192;
        }

        public int getTextureY() {
            return this.field_146127_k * 16;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class ListButton
    extends SonarButtons.AnimatedButton {
        public int field_146127_k;

        public ListButton(int id, int x, int y) {
            super(id, x, y, bground, 11, 11);
            this.field_146127_k = id;
        }

        public void func_146111_b(int x, int y) {
            String text = "BUTTON TEXT";
            switch (this.field_146127_k) {
                case 1: {
                    int config = (Integer)GuiItemRouter.this.handler.sideConfigs[(Integer)GuiItemRouter.this.handler.side.getObject()].getObject();
                    String type = config == 1 ? "Input" : (config == 2 ? "Output" : "None");
                    text = "Side Config: " + type;
                    break;
                }
                case 2: {
                    int listType = (Integer)GuiItemRouter.this.handler.listType.getObject();
                    text = listType == 0 ? "Whitelist" : "Blacklist";
                    break;
                }
                case 3: {
                    text = "Item Filter";
                    break;
                }
                case 4: {
                    text = "OreDict Filter";
                    break;
                }
                case 5: {
                    text = "Move Up";
                    break;
                }
                case 6: {
                    text = "Move Down";
                    break;
                }
                case 7: {
                    text = "Delete";
                }
            }
            GuiItemRouter.this.func_146279_a(text, x, y);
        }

        public void onClicked() {
        }

        public int getTextureX() {
            if (this.field_146127_k == 1) {
                int config = (Integer)GuiItemRouter.this.handler.sideConfigs[(Integer)GuiItemRouter.this.handler.side.getObject()].getObject();
                return 176 + config * 12;
            }
            if (this.field_146127_k != 2 && this.isButtonDown) {
                return 200;
            }
            return 176;
        }

        public int getTextureY() {
            if (this.field_146127_k == 1) {
                return 15;
            }
            if (this.field_146127_k == 2) {
                int listType = (Integer)GuiItemRouter.this.handler.listType.getObject();
                return listType == 0 ? 27 : 39;
            }
            return 15 + this.field_146127_k * 12;
        }
    }
}

