/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.client.gui;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import sonar.core.api.StoredItemStack;
import sonar.core.helpers.RenderHelper;
import sonar.core.inventory.SonarButtons;
import sonar.logistics.Logistics;
import sonar.logistics.api.cache.ICacheViewer;
import sonar.logistics.client.gui.GuiSelectionGrid;
import sonar.logistics.common.containers.ContainerInventoryCache;
import sonar.logistics.network.packets.PacketInventoryReader;

public class GuiInventoryViewer
extends GuiSelectionGrid<StoredItemStack> {
    public static final ResourceLocation clearBGround = new ResourceLocation("PracticalLogistics:textures/gui/inventoryReader_clear.png");
    private GuiTextField slotField;
    private GuiTextField searchField;
    public ICacheViewer viewer;
    public InventoryPlayer inventoryPlayer;

    public GuiInventoryViewer(ICacheViewer viewer, TileEntity entity, InventoryPlayer inventoryPlayer) {
        super((Container)new ContainerInventoryCache(viewer, entity, inventoryPlayer), entity);
        this.viewer = viewer;
        this.inventoryPlayer = inventoryPlayer;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.add(new FilterButton(0, this.field_147003_i + 193, this.field_147009_r + 9));
        this.field_146292_n.add(new FilterButton(1, this.field_147003_i + 193 + 18, this.field_147009_r + 9));
        this.searchField = new GuiTextField(this.field_146289_q, 141, 9, 49, 16);
        this.searchField.func_146203_f(20);
    }

    protected void func_146284_a(GuiButton button) {
        if (button != null) {
            if (button.field_146127_k == 0) {
                this.viewer.setSortingDirection(this.viewer.getSortingDirection().switchDir());
            }
            if (button.field_146127_k == 1) {
                this.viewer.setSortingType(this.viewer.getSortingType().switchDir());
            }
        }
    }

    @Override
    public void func_146979_b(int x, int y) {
        this.searchField.func_146194_f();
        super.func_146979_b(x, y);
    }

    @Override
    protected void func_73864_a(int i, int j, int k) {
        super.func_73864_a(i, j, k);
        this.searchField.func_146192_a(i - this.field_147003_i, j - this.field_147009_r, k);
    }

    protected void func_73869_a(char c, int i) {
        if (this.searchField.func_146206_l()) {
            if (c == '\r' || c == '\u001b') {
                this.searchField.func_146195_b(false);
            } else {
                this.searchField.func_146201_a(c, i);
            }
        } else {
            super.func_73869_a(c, i);
        }
    }

    @Override
    public List<StoredItemStack> getGridList() {
        String search = this.searchField.func_146179_b();
        if (search == null || search.isEmpty() || search.equals(" ")) {
            return this.viewer.getItemStacks();
        }
        ArrayList<StoredItemStack> searchList = new ArrayList<StoredItemStack>();
        List currentList = (List)this.viewer.getItemStacks().clone();
        for (StoredItemStack stack : currentList) {
            if (stack == null || stack.item == null || !stack.item.func_82833_r().toLowerCase().contains(search.toLowerCase())) continue;
            searchList.add(stack);
        }
        return searchList;
    }

    @Override
    public void onGridClicked(StoredItemStack selection, int pos, int button, boolean empty) {
        if (Keyboard.isKeyDown((int)42)) {
            button = 2;
        }
        if (!empty) {
            Logistics.network.sendToServer((IMessage)new PacketInventoryReader(this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e, selection.item, button));
        } else {
            Logistics.network.sendToServer((IMessage)new PacketInventoryReader(this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e, null, button));
        }
    }

    @Override
    public void renderStrings(int x, int y) {
    }

    @Override
    public void renderSelection(StoredItemStack selection, int x, int y) {
        ItemStack stack = selection.item;
        stack.field_77994_a = (int)selection.stored;
        RenderItem.getInstance().func_82406_b(this.field_146289_q, this.field_146297_k.func_110434_K(), stack, 13 + x * 18, 32 + y * 18);
        RenderHelper.renderStoredItemStackOverlay((FontRenderer)this.field_146289_q, (TextureManager)this.field_146297_k.func_110434_K(), (ItemStack)stack, (long)selection.stored, (int)(13 + x * 18), (int)(32 + y * 18), null);
    }

    @Override
    public void renderToolTip(StoredItemStack selection, int x, int y) {
        List list = selection.item.func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, this.field_146297_k.field_71474_y.field_82882_x);
        list.add(1, "Stored: " + selection.stored);
        for (int k = 0; k < list.size(); ++k) {
            if (k == 0) {
                list.set(k, selection.item.func_77953_t().field_77937_e + (String)list.get(k));
                continue;
            }
            list.set(k, EnumChatFormatting.GRAY + (String)list.get(k));
        }
        FontRenderer font = selection.item.func_77973_b().getFontRenderer(selection.item);
        this.drawHoveringText(list, x, y, font == null ? this.field_146289_q : font);
    }

    @Override
    public ResourceLocation getBackground() {
        return clearBGround;
    }

    @SideOnly(value=Side.CLIENT)
    public class FilterButton
    extends SonarButtons.AnimatedButton {
        public int field_146127_k;

        public FilterButton(int id, int x, int y) {
            super(id, x, y, GuiSelectionGrid.sorting_icons, 15, 15);
            this.field_146127_k = id;
        }

        public void func_146111_b(int x, int y) {
            String text = "BUTTON TEXT";
            switch (this.field_146127_k) {
                case 0: {
                    text = "Sorting Direction";
                    break;
                }
                case 1: {
                    text = GuiInventoryViewer.this.viewer.getSortingType().getTypeName();
                }
            }
            GuiInventoryViewer.this.func_146279_a(text, x, y);
        }

        public void onClicked() {
        }

        public int getTextureX() {
            switch (this.field_146127_k) {
                case 0: {
                    return 0 + GuiInventoryViewer.this.viewer.getSortingDirection().ordinal() * 16;
                }
                case 1: {
                    return 32 + GuiInventoryViewer.this.viewer.getSortingType().ordinal() * 16;
                }
            }
            return 0;
        }

        public int getTextureY() {
            return 0;
        }
    }
}

