/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.client.gui;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import sonar.core.SonarCore;
import sonar.core.api.StoredItemStack;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.RenderHelper;
import sonar.core.inventory.SonarButtons;
import sonar.core.network.PacketByteBufServer;
import sonar.core.network.utils.IByteBufTile;
import sonar.logistics.Logistics;
import sonar.logistics.api.wrappers.ItemWrapper;
import sonar.logistics.client.gui.GuiSelectionGrid;
import sonar.logistics.common.containers.ContainerInventoryReader;
import sonar.logistics.common.handlers.InventoryReaderHandler;
import sonar.logistics.helpers.ItemHelper;
import sonar.logistics.network.packets.PacketGuiChange;
import sonar.logistics.network.packets.PacketInventoryReader;

public class GuiInventoryReader
extends GuiSelectionGrid<StoredItemStack> {
    public static final ResourceLocation stackBGround = new ResourceLocation("PracticalLogistics:textures/gui/inventoryReader_stack.png");
    public static final ResourceLocation clearBGround = new ResourceLocation("PracticalLogistics:textures/gui/inventoryReader_clear.png");
    private InventoryReaderHandler handler;
    private GuiTextField slotField;
    private GuiTextField searchField;
    public static final int STACK = 0;
    public static final int SLOT = 1;
    public static final int POS = 2;
    public static final int INV = 3;
    public static final int STORAGE = 4;
    public InventoryPlayer inventoryPlayer;

    public GuiInventoryReader(InventoryReaderHandler handler, TileEntity entity, InventoryPlayer inventoryPlayer) {
        super((Container)new ContainerInventoryReader(handler, entity, inventoryPlayer), entity);
        this.handler = handler;
        this.inventoryPlayer = inventoryPlayer;
    }

    public int getSetting() {
        return (Integer)this.handler.setting.getObject();
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.add(new GuiButton(-1, this.field_147003_i + 120 - 108, this.field_147009_r + 7, 68, 20, this.getSettingsString()));
        this.field_146292_n.add(new FilterButton(0, this.field_147003_i + 193, this.field_147009_r + 9));
        this.field_146292_n.add(new FilterButton(1, this.field_147003_i + 193 + 18, this.field_147009_r + 9));
        switch (this.getSetting()) {
            case 1: 
            case 2: {
                this.slotField = new GuiTextField(this.field_146289_q, 87, 8, 48, 18);
                this.slotField.func_146203_f(7);
                if (this.getSetting() == 1) {
                    this.slotField.func_146180_a("" + this.handler.targetSlot.getObject());
                    break;
                }
                if (this.getSetting() != 2) break;
                this.slotField.func_146180_a("" + this.handler.posSlot.getObject());
            }
        }
        this.searchField = new GuiTextField(this.field_146289_q, 141, 9, 49, 16);
        this.searchField.func_146203_f(20);
    }

    protected void func_146284_a(GuiButton button) {
        if (button != null) {
            if (button.field_146127_k == -1) {
                if ((Integer)this.handler.setting.getObject() == 4) {
                    this.handler.setting.setObject((Object)0);
                } else {
                    this.handler.setting.increaseBy(1);
                }
                SonarCore.network.sendToServer((IMessage)new PacketByteBufServer((IByteBufTile)this.handler, this.entity.field_145851_c, this.entity.field_145848_d, this.entity.field_145849_e, 0));
                this.switchState();
                this.reset();
            }
            if (button.field_146127_k == 0) {
                if ((Integer)this.handler.sortingOrder.getObject() == 1) {
                    this.handler.sortingOrder.setObject((Object)0);
                } else {
                    this.handler.sortingOrder.increaseBy(1);
                }
                SonarCore.network.sendToServer((IMessage)new PacketByteBufServer((IByteBufTile)this.handler, this.entity.field_145851_c, this.entity.field_145848_d, this.entity.field_145849_e, 3));
            }
            if (button.field_146127_k == 1) {
                if ((Integer)this.handler.sortingType.getObject() == 2) {
                    this.handler.sortingType.setObject((Object)0);
                } else {
                    this.handler.sortingType.increaseBy(1);
                }
                SonarCore.network.sendToServer((IMessage)new PacketByteBufServer((IByteBufTile)this.handler, this.entity.field_145851_c, this.entity.field_145848_d, this.entity.field_145849_e, 4));
            }
            if (button.field_146127_k == 0 || button.field_146127_k == 1) {
                ItemHelper.sortItemList(this.handler.cachedItems.items, ItemWrapper.SortingDirection.values()[(Integer)this.handler.sortingOrder.getObject()], ItemWrapper.SortingType.values()[(Integer)this.handler.sortingType.getObject()]);
            }
        }
    }

    public void switchState() {
        Logistics.network.sendToServer((IMessage)new PacketGuiChange(this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e, this.getSetting() == 0, 4));
        if (this.field_146297_k.field_71439_g.field_71070_bA instanceof ContainerInventoryReader) {
            ((ContainerInventoryReader)this.field_146297_k.field_71439_g.field_71070_bA).addSlots(this.handler, this.inventoryPlayer, this.getSetting() == 0);
        }
        this.field_147002_h = this.field_146297_k.field_71439_g.field_71070_bA;
    }

    @Override
    public void func_146979_b(int x, int y) {
        switch (this.getSetting()) {
            case 1: 
            case 2: {
                this.slotField.func_146194_f();
            }
        }
        this.searchField.func_146194_f();
        super.func_146979_b(x, y);
    }

    @Override
    protected void func_73864_a(int i, int j, int k) {
        super.func_73864_a(i, j, k);
        switch (this.getSetting()) {
            case 1: 
            case 2: {
                this.slotField.func_146192_a(i - this.field_147003_i, j - this.field_147009_r, k);
            }
        }
        if (k == 1) {
            this.searchField.func_146180_a("");
        }
        this.searchField.func_146192_a(i - this.field_147003_i, j - this.field_147009_r, k);
    }

    protected void func_73869_a(char c, int i) {
        if ((this.getSetting() == 1 || this.getSetting() == 2) && this.slotField.func_146206_l()) {
            if (c == '\r' || c == '\u001b') {
                this.slotField.func_146195_b(false);
            } else {
                FontHelper.addDigitsToString((GuiTextField)this.slotField, (char)c, (int)i);
                String text = this.slotField.func_146179_b();
                if (text.isEmpty() || text == "" || text == null) {
                    if (this.getSetting() == 1) {
                        this.setTargetSlot("0");
                    } else if (this.getSetting() == 2) {
                        this.setPosSlot("0");
                    }
                } else if (this.getSetting() == 1) {
                    this.setTargetSlot(text);
                } else if (this.getSetting() == 2) {
                    this.setPosSlot(text);
                }
            }
        } else if (this.searchField.func_146206_l()) {
            if (c == '\r' || c == '\u001b') {
                this.searchField.func_146195_b(false);
            } else {
                this.searchField.func_146201_a(c, i);
            }
        } else {
            super.func_73869_a(c, i);
        }
    }

    public void setTargetSlot(String string) {
        this.handler.targetSlot.setObject((Object)Integer.parseInt(string));
        SonarCore.network.sendToServer((IMessage)new PacketByteBufServer((IByteBufTile)this.handler, this.entity.field_145851_c, this.entity.field_145848_d, this.entity.field_145849_e, 1));
    }

    public void setPosSlot(String string) {
        this.handler.posSlot.setObject((Object)Integer.parseInt(string));
        SonarCore.network.sendToServer((IMessage)new PacketByteBufServer((IByteBufTile)this.handler, this.entity.field_145851_c, this.entity.field_145848_d, this.entity.field_145849_e, 2));
    }

    public String getSettingsString() {
        switch ((Integer)this.handler.setting.getObject()) {
            case 0: {
                return "Stack";
            }
            case 1: {
                return "Slot";
            }
            case 2: {
                return "Pos";
            }
            case 3: {
                return "Inventories";
            }
            case 4: {
                return "Storage";
            }
        }
        return "Inventories";
    }

    @Override
    public List<StoredItemStack> getGridList() {
        String search = this.searchField.func_146179_b();
        if (search == null || search.isEmpty() || search.equals(" ")) {
            return this.handler.cachedItems.items;
        }
        ArrayList<StoredItemStack> searchList = new ArrayList<StoredItemStack>();
        List currentList = (List)this.handler.cachedItems.items.clone();
        for (StoredItemStack stack : currentList) {
            if (stack == null || stack.item == null || !stack.item.func_82833_r().toLowerCase().contains(search.toLowerCase())) continue;
            searchList.add(stack);
        }
        return searchList;
    }

    @Override
    public void onGridClicked(StoredItemStack selection, int pos, int button, boolean empty) {
        if (Keyboard.isKeyDown((int)42)) {
            button = 2;
        }
        if (!empty) {
            Logistics.network.sendToServer((IMessage)new PacketInventoryReader(this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e, selection.item, button));
        } else {
            Logistics.network.sendToServer((IMessage)new PacketInventoryReader(this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e, null, button));
        }
    }

    @Override
    public void renderStrings(int x, int y) {
    }

    @Override
    public void renderSelection(StoredItemStack selection, int x, int y) {
        ItemStack stack = selection.item;
        stack.field_77994_a = (int)selection.stored;
        RenderItem.getInstance().func_82406_b(this.field_146289_q, this.field_146297_k.func_110434_K(), stack, 13 + x * 18, 32 + y * 18);
        RenderHelper.renderStoredItemStackOverlay((FontRenderer)this.field_146289_q, (TextureManager)this.field_146297_k.func_110434_K(), (ItemStack)stack, (long)selection.stored, (int)(13 + x * 18), (int)(32 + y * 18), null);
    }

    @Override
    public void renderToolTip(StoredItemStack selection, int x, int y) {
        List list = selection.item.func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, this.field_146297_k.field_71474_y.field_82882_x);
        list.add(1, "Stored: " + selection.stored);
        for (int k = 0; k < list.size(); ++k) {
            if (k == 0) {
                list.set(k, selection.item.func_77953_t().field_77937_e + (String)list.get(k));
                continue;
            }
            list.set(k, EnumChatFormatting.GRAY + (String)list.get(k));
        }
        FontRenderer font = selection.item.func_77973_b().getFontRenderer(selection.item);
        this.drawHoveringText(list, x, y, font == null ? this.field_146289_q : font);
    }

    @Override
    public ResourceLocation getBackground() {
        if (this.getSetting() == 0) {
            return stackBGround;
        }
        return clearBGround;
    }

    @SideOnly(value=Side.CLIENT)
    public class FilterButton
    extends SonarButtons.AnimatedButton {
        public int field_146127_k;

        public FilterButton(int id, int x, int y) {
            super(id, x, y, GuiSelectionGrid.sorting_icons, 15, 15);
            this.field_146127_k = id;
        }

        public void func_146111_b(int x, int y) {
            String text = "BUTTON TEXT";
            switch (this.field_146127_k) {
                case 0: {
                    text = "Sorting Direction";
                    break;
                }
                case 1: {
                    text = (Integer)((GuiInventoryReader)GuiInventoryReader.this).handler.sortingType.getObject() == 0 ? "Items Stored" : ((Integer)((GuiInventoryReader)GuiInventoryReader.this).handler.sortingType.getObject() == 1 ? "Item Name" : "Mod");
                }
            }
            GuiInventoryReader.this.func_146279_a(text, x, y);
        }

        public void onClicked() {
        }

        public int getTextureX() {
            switch (this.field_146127_k) {
                case 0: {
                    return 0 + (Integer)((GuiInventoryReader)GuiInventoryReader.this).handler.sortingOrder.getObject() * 16;
                }
                case 1: {
                    return 32 + (Integer)((GuiInventoryReader)GuiInventoryReader.this).handler.sortingType.getObject() * 16;
                }
            }
            return 0;
        }

        public int getTextureY() {
            return 0;
        }
    }
}

