/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.client.gui;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;
import sonar.core.SonarCore;
import sonar.core.api.StoredFluidStack;
import sonar.core.helpers.FontHelper;
import sonar.core.inventory.SonarButtons;
import sonar.core.network.PacketByteBufServer;
import sonar.core.network.utils.IByteBufTile;
import sonar.logistics.Logistics;
import sonar.logistics.client.gui.GuiSelectionGrid;
import sonar.logistics.common.containers.ContainerFluidReader;
import sonar.logistics.common.handlers.FluidReaderHandler;
import sonar.logistics.network.packets.PacketFluidReader;
import sonar.logistics.network.packets.PacketGuiChange;

public class GuiFluidReader
extends GuiSelectionGrid<StoredFluidStack> {
    public static final ResourceLocation stackBGround = new ResourceLocation("PracticalLogistics:textures/gui/inventoryReader_stack.png");
    public static final ResourceLocation clearBGround = new ResourceLocation("PracticalLogistics:textures/gui/inventoryReader_clear.png");
    public FluidReaderHandler handler;
    private GuiTextField slotField;
    private GuiTextField searchField;
    public static final int STACK = 0;
    public static final int POS = 1;
    public static final int INV = 2;
    public static final int STORAGE = 3;
    public InventoryPlayer inventoryPlayer;

    public GuiFluidReader(FluidReaderHandler handler, TileEntity entity, InventoryPlayer inventoryPlayer) {
        super((Container)new ContainerFluidReader(handler, entity, inventoryPlayer), entity);
        this.handler = handler;
        this.inventoryPlayer = inventoryPlayer;
    }

    public int getSetting() {
        return (Integer)this.handler.setting.getObject();
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.add(new GuiButton(-1, this.field_147003_i + 120 - 108, this.field_147009_r + 7, 68, 20, this.getSettingsString()){

            public void func_146111_b(int x, int y) {
                GuiFluidReader.this.func_146279_a(GuiFluidReader.this.getSettingsHover(), x, y);
            }
        });
        this.field_146292_n.add(new FilterButton(0, this.field_147003_i + 193, this.field_147009_r + 9));
        this.field_146292_n.add(new FilterButton(1, this.field_147003_i + 193 + 18, this.field_147009_r + 9));
        switch (this.getSetting()) {
            case 1: {
                this.slotField = new GuiTextField(this.field_146289_q, 87, 8, 48, 18);
                this.slotField.func_146203_f(7);
                this.slotField.func_146180_a("" + this.handler.posSlot.getObject());
            }
        }
        this.searchField = new GuiTextField(this.field_146289_q, 141, 9, 49, 16);
        this.searchField.func_146203_f(20);
    }

    protected void func_146284_a(GuiButton button) {
        if (button != null) {
            if (button.field_146127_k == -1) {
                if ((Integer)this.handler.setting.getObject() == 3) {
                    this.handler.setting.setObject((Object)0);
                } else {
                    this.handler.setting.increaseBy(1);
                }
                SonarCore.network.sendToServer((IMessage)new PacketByteBufServer((IByteBufTile)this.handler, this.entity.field_145851_c, this.entity.field_145848_d, this.entity.field_145849_e, 0));
                this.switchState();
                this.reset();
            }
            if (button.field_146127_k == 0) {
                if ((Integer)this.handler.sortingOrder.getObject() == 1) {
                    this.handler.sortingOrder.setObject((Object)0);
                } else {
                    this.handler.sortingOrder.increaseBy(1);
                }
                SonarCore.network.sendToServer((IMessage)new PacketByteBufServer((IByteBufTile)this.handler, this.entity.field_145851_c, this.entity.field_145848_d, this.entity.field_145849_e, 3));
            }
            if (button.field_146127_k == 1) {
                if ((Integer)this.handler.sortingType.getObject() == 2) {
                    this.handler.sortingType.setObject((Object)0);
                } else {
                    this.handler.sortingType.increaseBy(1);
                }
                SonarCore.network.sendToServer((IMessage)new PacketByteBufServer((IByteBufTile)this.handler, this.entity.field_145851_c, this.entity.field_145848_d, this.entity.field_145849_e, 4));
            }
        }
    }

    public void switchState() {
        Logistics.network.sendToServer((IMessage)new PacketGuiChange(this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e, this.getSetting() == 0, 10));
        if (this.field_146297_k.field_71439_g.field_71070_bA instanceof ContainerFluidReader) {
            ((ContainerFluidReader)this.field_146297_k.field_71439_g.field_71070_bA).addSlots(this.handler, this.inventoryPlayer, this.getSetting() == 0);
        }
        this.field_147002_h = this.field_146297_k.field_71439_g.field_71070_bA;
    }

    @Override
    public void func_146979_b(int x, int y) {
        this.searchField.func_146194_f();
        switch (this.getSetting()) {
            case 0: {
                FluidStack storedStack;
                if (x - this.field_147003_i < 103 || x - this.field_147003_i > 119 || y - this.field_147009_r < 9 || y - this.field_147009_r > 25 || (storedStack = this.handler.current) == null) break;
                GL11.glDisable((int)2929);
                GL11.glDisable((int)2896);
                ArrayList<String> list = new ArrayList<String>();
                list.add(storedStack.getLocalizedName());
                this.drawHoveringText(list, x - this.field_147003_i, y - this.field_147009_r, this.field_146289_q);
                GL11.glEnable((int)2896);
                GL11.glEnable((int)2929);
                RenderHelper.func_74520_c();
                break;
            }
            case 1: {
                this.slotField.func_146194_f();
            }
        }
        super.func_146979_b(x, y);
    }

    @Override
    protected void func_73864_a(int i, int j, int k) {
        super.func_73864_a(i, j, k);
        switch (this.getSetting()) {
            case 1: {
                this.slotField.func_146192_a(i - this.field_147003_i, j - this.field_147009_r, k);
            }
        }
        if (k == 1) {
            this.searchField.func_146180_a("");
        }
        this.searchField.func_146192_a(i - this.field_147003_i, j - this.field_147009_r, k);
    }

    protected void func_73869_a(char c, int i) {
        if (this.getSetting() == 1 && this.slotField.func_146206_l()) {
            if (c == '\r' || c == '\u001b') {
                this.slotField.func_146195_b(false);
            } else {
                FontHelper.addDigitsToString((GuiTextField)this.slotField, (char)c, (int)i);
                String text = this.slotField.func_146179_b();
                if (text.isEmpty() || text == "" || text == null) {
                    this.setPosSlot("0");
                } else {
                    this.setPosSlot(text);
                }
            }
        } else if (this.searchField.func_146206_l()) {
            if (c == '\r' || c == '\u001b') {
                this.searchField.func_146195_b(false);
            } else {
                this.searchField.func_146201_a(c, i);
            }
        } else {
            super.func_73869_a(c, i);
        }
    }

    public void setPosSlot(String string) {
        this.handler.posSlot.setObject((Object)Integer.parseInt(string));
        SonarCore.network.sendToServer((IMessage)new PacketByteBufServer((IByteBufTile)this.handler, this.entity.field_145851_c, this.entity.field_145848_d, this.entity.field_145849_e, 1));
    }

    public String getSettingsHover() {
        switch ((Integer)this.handler.setting.getObject()) {
            case 0: {
                return "Selected Fluid";
            }
            case 1: {
                return "Fluid at the given position";
            }
            case 2: {
                return "List of Fluids";
            }
            case 3: {
                return "Current Tank Usage";
            }
        }
        return "ERROR";
    }

    public String getSettingsString() {
        switch ((Integer)this.handler.setting.getObject()) {
            case 0: {
                return "Fluid";
            }
            case 1: {
                return "Pos";
            }
            case 2: {
                return "Tanks";
            }
            case 3: {
                return "Storage";
            }
        }
        return "ERROR";
    }

    @Override
    public List<StoredFluidStack> getGridList() {
        if (this.searchField.func_146179_b() == null || this.searchField.func_146179_b().isEmpty() || this.searchField.func_146179_b().equals(" ")) {
            return this.handler.cachedFluids.fluids;
        }
        ArrayList<StoredFluidStack> searchList = new ArrayList<StoredFluidStack>();
        List currentList = (List)this.handler.cachedFluids.fluids.clone();
        for (StoredFluidStack stack : currentList) {
            if (!stack.fluid.getLocalizedName().toLowerCase().contains(this.searchField.func_146179_b().toLowerCase())) continue;
            searchList.add(stack);
        }
        return searchList;
    }

    @Override
    public void onGridClicked(StoredFluidStack selection, int pos, int button, boolean empty) {
        if (empty) {
            return;
        }
        if (this.getSetting() == 0) {
            Logistics.network.sendToServer((IMessage)new PacketFluidReader(this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e, selection.fluid));
        }
        if (this.getSetting() == 1) {
            List currentList = (List)this.handler.cachedFluids.fluids.clone();
            int position = 0;
            for (StoredFluidStack stack : currentList) {
                if (stack != null && stack.equals((Object)selection)) {
                    String posString = String.valueOf(position);
                    this.slotField.func_146180_a(posString);
                    this.setPosSlot(posString);
                }
                ++position;
            }
        }
    }

    @Override
    public void renderStrings(int x, int y) {
    }

    @Override
    public void preRender() {
        if (this.getGridList() != null) {
            int br = 0x1000100;
            int var11 = 256;
            int var12 = 256;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)204.8f, (float)204.8f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @Override
    public void postRender() {
        if (this.handler.current != null) {
            int br = 0x1000100;
            int var11 = 256;
            int var12 = 256;
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
            if (0 == (Integer)this.handler.setting.getObject()) {
                RenderItem.getInstance().func_94149_a(103, 9, this.handler.current.getFluid().getIcon(), 16, 16);
            }
        }
    }

    @Override
    public void renderSelection(StoredFluidStack selection, int x, int y) {
        if (selection.fluid != null) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
            RenderItem.getInstance().func_94149_a(13 + x * 18, 32 + y * 18, selection.fluid.getFluid().getIcon(), 16, 16);
        }
    }

    @Override
    public void renderToolTip(StoredFluidStack selection, int x, int y) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(selection.fluid.getFluid().getLocalizedName(selection.fluid));
        if (selection.stored != 0L) {
            list.add(EnumChatFormatting.GRAY + "Stored: " + selection.stored + " mB");
        }
        this.drawHoveringText(list, x, y, this.field_146289_q);
    }

    @Override
    public ResourceLocation getBackground() {
        if (this.getSetting() == 0) {
            return stackBGround;
        }
        return clearBGround;
    }

    @SideOnly(value=Side.CLIENT)
    public class FilterButton
    extends SonarButtons.AnimatedButton {
        public int field_146127_k;

        public FilterButton(int id, int x, int y) {
            super(id, x, y, GuiSelectionGrid.sorting_icons, 15, 15);
            this.field_146127_k = id;
        }

        public void func_146111_b(int x, int y) {
            String text = "BUTTON TEXT";
            switch (this.field_146127_k) {
                case 0: {
                    text = "Sorting Direction";
                    break;
                }
                case 1: {
                    text = (Integer)GuiFluidReader.this.handler.sortingType.getObject() == 0 ? "Amount Stored" : ((Integer)GuiFluidReader.this.handler.sortingType.getObject() == 1 ? "Fluid Name" : "Temperature");
                }
            }
            GuiFluidReader.this.func_146279_a(text, x, y);
        }

        public void onClicked() {
        }

        public int getTextureX() {
            switch (this.field_146127_k) {
                case 0: {
                    return 0 + (Integer)GuiFluidReader.this.handler.sortingOrder.getObject() * 16;
                }
                case 1: {
                    if ((Integer)GuiFluidReader.this.handler.sortingType.getObject() == 2) {
                        return 80;
                    }
                    return 32 + (Integer)GuiFluidReader.this.handler.sortingType.getObject() * 16;
                }
            }
            return 0;
        }

        public int getTextureY() {
            return 0;
        }
    }
}

