/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.client.gui;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.NBTHelper;
import sonar.core.helpers.RenderHelper;
import sonar.core.utils.IBufObject;
import sonar.logistics.Logistics;
import sonar.logistics.client.gui.GuiSelectionList;
import sonar.logistics.common.containers.ContainerEmptySync;
import sonar.logistics.common.handlers.EnergyReaderHandler;
import sonar.logistics.info.types.StoredEnergyInfo;
import sonar.logistics.network.packets.PacketInfoBlock;

public class GuiEnergyReader
extends GuiSelectionList<StoredEnergyInfo> {
    public static final ResourceLocation bground = new ResourceLocation("PracticalLogistics:textures/gui/channelSelection.png");
    public TileEntity tile;
    public EnergyReaderHandler handler;

    public GuiEnergyReader(TileEntity tile, EnergyReaderHandler handler, InventoryPlayer inventory) {
        super((Container)new ContainerEmptySync(tile), tile);
        this.tile = tile;
        this.handler = handler;
    }

    @Override
    public List<StoredEnergyInfo> getSelectionList() {
        return this.handler.stacks;
    }

    @Override
    public StoredEnergyInfo getCurrentSelection() {
        return (StoredEnergyInfo)this.handler.primaryInfo.getObject();
    }

    @Override
    public boolean isEqualSelection(StoredEnergyInfo selection, StoredEnergyInfo current) {
        return selection.isMatchingInfo(current) && selection.isMatchingData(current) != NBTHelper.SyncType.SAVE;
    }

    @Override
    public void renderStrings(int x, int y) {
        FontHelper.textCentre((String)StatCollector.func_74838_a((String)"tile.EnergyReader.name"), (int)this.field_146999_f, (int)6, (int)1);
        FontHelper.textCentre((String)"Select the Energy Info you wish to display", (int)this.field_146999_f, (int)18, (int)0);
    }

    @Override
    public void renderSelection(StoredEnergyInfo selection, boolean isSelected, int pos) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("PracticalLogistics:textures/model/progressBar.png"));
        if (selection.stack.capacity != 0L) {
            int l = (int)(selection.stack.stored * 207L / selection.stack.capacity);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_73729_b(25, 32 + this.getSelectionHeight() * pos, 176, 10, l, 16);
        }
        if (selection.coords != null) {
            String string = selection.coords.block != null ? selection.coords.block.func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, this.field_146297_k.field_71474_y.field_82882_x).get(0).toString() : selection.coords.coordString;
            int offsetTop = 29;
            if (this.getViewableSize() == 7) {
                offsetTop += 2;
            }
            FontHelper.text((String)(string + ": " + selection.stack.stored + " " + selection.stack.energyType.getStorageSuffix()), (int)28, (int)(offsetTop + 5 + this.getSelectionHeight() * pos), (int)Color.WHITE.getRGB());
            if (selection.coords.block != null) {
                GL11.glEnable((int)2929);
                RenderItem.getInstance().func_82406_b(this.field_146289_q, this.field_146297_k.func_110434_K(), selection.coords.block, 8, offsetTop + 1 + this.getSelectionHeight() * pos);
                RenderHelper.renderStoredItemStackOverlay((FontRenderer)this.field_146289_q, (TextureManager)this.field_146297_k.func_110434_K(), (ItemStack)selection.coords.block, (long)0L, (int)8, (int)(offsetTop + 1 + this.getSelectionHeight() * pos), null);
            }
        }
    }

    @Override
    public void drawSelectionBackground(int offsetTop, int i, int pos) {
        this.func_73729_b(this.field_147003_i + 7, this.field_147009_r + offsetTop + this.getSelectionHeight() * i, 0, i == pos ? 166 + this.getSelectionHeight() : 166, 226, this.getSelectionHeight());
        this.func_73729_b(this.field_147003_i + 7, this.field_147009_r + offsetTop + this.getSelectionHeight() * i, 0, 166, 226, this.getSelectionHeight());
        if (i == pos) {
            this.func_73729_b(this.field_147003_i + 7, this.field_147009_r + offsetTop + this.getSelectionHeight() * i, 0, 166 + this.getSelectionHeight(), 18, this.getSelectionHeight());
        }
    }

    @Override
    public void sendPacket(StoredEnergyInfo selection) {
        Logistics.network.sendToServer((IMessage)new PacketInfoBlock(this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e, selection, true));
        this.handler.primaryInfo.setObject((IBufObject)selection);
    }

    @Override
    public ResourceLocation getBackground() {
        return bground;
    }

    @Override
    public int getViewableSize() {
        return 7;
    }

    @Override
    public int getSelectionHeight() {
        return 18;
    }
}

