/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.client.gui;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.awt.Color;
import java.util.List;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;
import sonar.core.SonarCore;
import sonar.core.api.BlockCoords;
import sonar.core.helpers.FontHelper;
import sonar.core.network.PacketByteBufServer;
import sonar.core.network.utils.IByteBufTile;
import sonar.logistics.api.utils.ExternalCoords;
import sonar.logistics.api.utils.IdentifiedCoords;
import sonar.logistics.client.gui.GuiSelectionList;
import sonar.logistics.common.containers.ContainerDataReceiver;
import sonar.logistics.common.tileentity.TileEntityDataReceiver;

public class GuiDataReceiver
extends GuiSelectionList<IdentifiedCoords> {
    public TileEntityDataReceiver tile;

    public GuiDataReceiver(InventoryPlayer inventory, TileEntityDataReceiver tile) {
        super((Container)new ContainerDataReceiver(tile, inventory), (TileEntity)tile);
        this.tile = tile;
    }

    @Override
    public List<IdentifiedCoords> getSelectionList() {
        return this.tile.emitters;
    }

    @Override
    public IdentifiedCoords getCurrentSelection() {
        ExternalCoords channel = this.tile.getChannel();
        if (channel != null) {
            return this.tile.getChannel().getIdentifiedCoords();
        }
        return null;
    }

    @Override
    public boolean isEqualSelection(IdentifiedCoords selection, IdentifiedCoords current) {
        return BlockCoords.equalCoords((BlockCoords)selection.blockCoords, (BlockCoords)current.blockCoords);
    }

    @Override
    public void renderStrings(int x, int y) {
        FontHelper.textCentre((String)StatCollector.func_74838_a((String)"tile.DataReceiver.name"), (int)this.field_146999_f, (int)6, (int)1);
        FontHelper.textCentre((String)"Select the emitter you wish to connect to", (int)this.field_146999_f, (int)18, (int)0);
    }

    @Override
    public void renderSelection(IdentifiedCoords selection, boolean isSelected, int pos) {
        FontHelper.text((String)selection.coordString, (int)10, (int)(31 + 12 * pos), (int)(isSelected ? Color.GREEN.getRGB() : Color.WHITE.getRGB()));
        GL11.glPushMatrix();
        GL11.glScaled((double)0.75, (double)0.75, (double)0.75);
        FontHelper.text((String)selection.blockCoords.toString(), (int)174, (int)(43 + 16 * pos), (int)(isSelected ? Color.GREEN.getRGB() : Color.WHITE.getRGB()));
        GL11.glPopMatrix();
    }

    @Override
    public void sendPacket(IdentifiedCoords selection) {
        this.tile.selected = selection;
        SonarCore.network.sendToServer((IMessage)new PacketByteBufServer((IByteBufTile)this.tile, this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e, 0));
    }
}

