/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.client.gui;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.RenderHelper;
import sonar.core.network.utils.ISyncTile;
import sonar.logistics.Logistics;
import sonar.logistics.api.utils.ExternalCoords;
import sonar.logistics.client.gui.GuiSelectionList;
import sonar.logistics.common.containers.ContainerEmptySync;
import sonar.logistics.common.handlers.ChannelSelectorHandler;
import sonar.logistics.network.packets.PacketCoordsSelection;

public class GuiChannelSelector
extends GuiSelectionList<ExternalCoords> {
    public static final ResourceLocation bground = new ResourceLocation("PracticalLogistics:textures/gui/channelSelection.png");
    public TileEntity tile;
    public ChannelSelectorHandler handler;

    public GuiChannelSelector(TileEntity tile, ChannelSelectorHandler handler, InventoryPlayer inventory) {
        super((Container)new ContainerEmptySync((ISyncTile)handler, tile), tile);
        this.tile = tile;
        this.handler = handler;
    }

    @Override
    public List<ExternalCoords> getSelectionList() {
        return this.handler.channels;
    }

    @Override
    public ExternalCoords getCurrentSelection() {
        return this.handler.channel.getCoords();
    }

    @Override
    public boolean isEqualSelection(ExternalCoords selection, ExternalCoords current) {
        return selection.equals(current);
    }

    @Override
    public void renderStrings(int x, int y) {
        FontHelper.textCentre((String)StatCollector.func_74838_a((String)"tile.ChannelSelector.name"), (int)this.field_146999_f, (int)6, (int)1);
        FontHelper.textCentre((String)"Select the channel you wish to default to", (int)this.field_146999_f, (int)18, (int)0);
    }

    @Override
    public void renderSelection(ExternalCoords selection, boolean isSelected, int pos) {
        String string = selection.block != null ? selection.block.func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, this.field_146297_k.field_71474_y.field_82882_x).get(0).toString() : selection.coordString;
        int offsetTop = 29;
        if (this.getViewableSize() == 7) {
            offsetTop += 2;
        }
        FontHelper.text((String)string.substring(0, Math.min(17, string.length())), (int)28, (int)(offsetTop + 5 + this.getSelectionHeight() * pos), (int)Color.WHITE.getRGB());
        GL11.glPushMatrix();
        GL11.glScaled((double)0.75, (double)0.75, (double)0.75);
        FontHelper.text((String)(selection.coordString.isEmpty() ? selection.blockCoords.toString() : selection.coordString), (int)174, (int)(offsetTop + 18 + (this.getSelectionHeight() + 6) * pos), (int)Color.WHITE.getRGB());
        GL11.glPopMatrix();
        if (selection.block != null) {
            GL11.glEnable((int)2929);
            RenderItem.getInstance().func_82406_b(this.field_146289_q, this.field_146297_k.func_110434_K(), selection.block, 8, offsetTop + 1 + this.getSelectionHeight() * pos);
            RenderHelper.renderStoredItemStackOverlay((FontRenderer)this.field_146289_q, (TextureManager)this.field_146297_k.func_110434_K(), (ItemStack)selection.block, (long)0L, (int)8, (int)(offsetTop + 1 + this.getSelectionHeight() * pos), null);
            GL11.glDisable((int)2929);
        }
    }

    @Override
    public void sendPacket(ExternalCoords selection) {
        Logistics.network.sendToServer((IMessage)new PacketCoordsSelection(this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e, selection));
    }

    @Override
    public ResourceLocation getBackground() {
        return bground;
    }

    @Override
    public int getViewableSize() {
        return 7;
    }

    @Override
    public int getSelectionHeight() {
        return 18;
    }
}

