/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.cache;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.SonarCore;
import sonar.core.api.BlockCoords;
import sonar.core.api.FluidHandler;
import sonar.core.api.InventoryHandler;
import sonar.core.api.SonarAPI;
import sonar.core.api.StoredFluidStack;
import sonar.core.api.StoredItemStack;
import sonar.logistics.api.LogisticsAPI;
import sonar.logistics.api.cache.CacheTypes;
import sonar.logistics.api.cache.IStorageCache;
import sonar.logistics.api.connecting.IEntityNode;
import sonar.logistics.api.wrappers.FluidWrapper;
import sonar.logistics.api.wrappers.ItemWrapper;

public abstract class StorageCache
implements IStorageCache {
    public ItemWrapper.StorageItems getCachedItems(ArrayList<StoredItemStack> last) {
        ArrayList<StoredItemStack> storedStacks = new ArrayList<StoredItemStack>();
        InventoryHandler.StorageSize storage = new InventoryHandler.StorageSize(0L, 0L);
        LinkedHashMap<BlockCoords, ForgeDirection> blocks = this.getExternalBlocks(true);
        if (!blocks.isEmpty()) {
            storage = LogisticsAPI.getItemHelper().getTileInventory(storedStacks, storage, blocks);
        } else {
            TileEntity tile = this.getFirstTileEntity(CacheTypes.ENTITY_NODES);
            if (tile != null && tile instanceof IEntityNode) {
                storage = LogisticsAPI.getItemHelper().getEntityInventory(storedStacks, storage, ((IEntityNode)tile).getEntities());
            }
        }
        ArrayList changed = (ArrayList)storedStacks.clone();
        ArrayList removed = (ArrayList)last.clone();
        if (last != null) {
            changed.removeAll(last);
        }
        for (StoredItemStack r : (ArrayList)removed.clone()) {
            for (StoredItemStack c : (ArrayList)storedStacks.clone()) {
                if (!r.equalStack(c.getItemStack())) continue;
                removed.remove(r);
            }
        }
        return new ItemWrapper.StorageItems(storedStacks, storage, changed, removed);
    }

    public FluidWrapper.StorageFluids getCachedFluids(ArrayList<StoredFluidStack> fluids) {
        ArrayList<StoredFluidStack> fluidList = new ArrayList<StoredFluidStack>();
        InventoryHandler.StorageSize storage = new InventoryHandler.StorageSize(0L, 0L);
        List providers = SonarCore.fluidProviders.getObjects();
        LinkedHashMap<BlockCoords, ForgeDirection> blocks = this.getExternalBlocks(true);
        for (FluidHandler provider : providers) {
            for (Map.Entry<BlockCoords, ForgeDirection> entry : blocks.entrySet()) {
                TileEntity fluidTile = entry.getKey().getTileEntity();
                if (fluidTile == null || !provider.canHandleFluids(fluidTile, entry.getValue())) continue;
                ArrayList info = new ArrayList();
                InventoryHandler.StorageSize size = provider.getFluids(info, fluidTile, entry.getValue());
                storage.addItems(size.getStoredFluids());
                storage.addStorage(size.getMaxFluids());
                for (StoredFluidStack fluid : info) {
                    SonarAPI.getFluidHelper().addFluidToList(fluidList, fluid);
                }
            }
        }
        ArrayList changed = (ArrayList)fluidList.clone();
        ArrayList removed = (ArrayList)fluids.clone();
        if (fluids != null) {
            changed.removeAll(fluids);
        }
        for (StoredFluidStack r : (ArrayList)removed.clone()) {
            for (StoredFluidStack c : (ArrayList)fluidList.clone()) {
                if (!r.equalStack(c.getFullStack())) continue;
                removed.remove(r);
            }
        }
        return new FluidWrapper.StorageFluids(fluidList, storage, changed, removed);
    }
}

