/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.cache;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.api.BlockCoords;
import sonar.core.integration.fmp.FMPHelper;
import sonar.logistics.api.cache.CacheTypes;
import sonar.logistics.api.cache.INetworkCache;
import sonar.logistics.api.cache.IRefreshCache;
import sonar.logistics.api.connecting.IChannelProvider;
import sonar.logistics.api.connecting.IConnectionNode;
import sonar.logistics.api.connecting.IEntityNode;
import sonar.logistics.api.connecting.IInfoEmitter;
import sonar.logistics.api.connecting.ILogicTile;
import sonar.logistics.api.wrappers.FluidWrapper;
import sonar.logistics.api.wrappers.ItemWrapper;
import sonar.logistics.cache.StorageCache;
import sonar.logistics.registries.CableRegistry;
import sonar.logistics.registries.CacheRegistry;

public class NetworkCache
extends StorageCache
implements IRefreshCache {
    public int networkID = -1;
    private final ArrayList<BlockCoords> entityCache = new ArrayList();
    private final ArrayList<BlockCoords> nodeCache = new ArrayList();
    private final ArrayList<BlockCoords> emitterCache = new ArrayList();
    private final ArrayList<BlockCoords> networkCache = new ArrayList();
    private final ArrayList<BlockCoords> channelCache = new ArrayList();
    private final LinkedHashMap<BlockCoords, ForgeDirection> blockCache = new LinkedHashMap();
    private final LinkedHashMap<BlockCoords, ForgeDirection> networkedCache = new LinkedHashMap();
    private ItemWrapper.StorageItems cachedItems = ItemWrapper.StorageItems.EMPTY;
    private FluidWrapper.StorageFluids cachedFluids = FluidWrapper.StorageFluids.EMPTY;

    @Override
    public Map.Entry<BlockCoords, ForgeDirection> getExternalBlock(boolean includeChannels) {
        for (BlockCoords coords : this.nodeCache) {
            Object tile = FMPHelper.checkObject((Object)coords.getTileEntity());
            if (tile == null || !(tile instanceof IConnectionNode)) continue;
            LinkedHashMap<BlockCoords, ForgeDirection> map = new LinkedHashMap<BlockCoords, ForgeDirection>();
            ((IConnectionNode)tile).addConnections(map);
            Iterator<Map.Entry<BlockCoords, ForgeDirection>> iterator = map.entrySet().iterator();
            if (!iterator.hasNext()) continue;
            Map.Entry<BlockCoords, ForgeDirection> set = iterator.next();
            return set;
        }
        return null;
    }

    @Override
    public ArrayList<BlockCoords> getConnections(CacheTypes type, boolean includeChannels) {
        ArrayList<BlockCoords> list = new ArrayList();
        switch (type) {
            case CHANNELLED: {
                list = this.channelCache;
                break;
            }
            case EMITTER: {
                list = this.emitterCache;
                break;
            }
            case ENTITY_NODES: {
                list = this.entityCache;
                break;
            }
            case NODES: {
                list = this.nodeCache;
                break;
            }
            case NETWORK: {
                list = this.networkCache;
                break;
            }
        }
        if (includeChannels) {
            ArrayList<Integer> networks = this.getFinalNetworkList();
            for (Integer id : networks) {
                INetworkCache network = CacheRegistry.getCache(id);
                ArrayList<BlockCoords> blocks = network.getConnections(type, false);
                for (BlockCoords coord : blocks) {
                    if (coord.contains(list)) continue;
                    list.add(coord);
                }
            }
        }
        return list;
    }

    @Override
    public LinkedHashMap<BlockCoords, ForgeDirection> getExternalBlocks(boolean includeChannels) {
        if (includeChannels) {
            return this.networkedCache;
        }
        return this.blockCache;
    }

    @Override
    public void refreshCache(int networkID) {
        this.networkID = networkID;
        ArrayList coords = (ArrayList)CableRegistry.getConnections(networkID).clone();
        Iterator iterator = coords.iterator();
        LinkedHashMap blockCache = new LinkedHashMap();
        ArrayList<BlockCoords> entityCache = new ArrayList<BlockCoords>();
        ArrayList<BlockCoords> nodeCache = new ArrayList<BlockCoords>();
        ArrayList<BlockCoords> emitterCache = new ArrayList<BlockCoords>();
        ArrayList<BlockCoords> networkCache = new ArrayList<BlockCoords>();
        ArrayList<BlockCoords> channelCache = new ArrayList<BlockCoords>();
        while (iterator.hasNext()) {
            Object tile;
            BlockCoords coord = (BlockCoords)iterator.next();
            World world = coord.getWorld();
            Block target = coord.getBlock(coord.getWorld());
            if (target == null || target.isAir((IBlockAccess)world, coord.getX(), coord.getY(), coord.getZ()) || (tile = FMPHelper.checkObject((Object)coord.getTileEntity())) == null) continue;
            if (tile instanceof IChannelProvider) {
                if (coord.contains(channelCache)) continue;
                channelCache.add(coord);
                continue;
            }
            if (tile instanceof ILogicTile && !coord.contains(networkCache)) {
                networkCache.add(coord);
            }
            if (tile instanceof IInfoEmitter && !coord.contains(emitterCache)) {
                emitterCache.add(coord);
            }
            if (tile instanceof IEntityNode && !coord.contains(entityCache)) {
                entityCache.add(coord);
            }
            if (!(tile instanceof IConnectionNode) || coord.contains(nodeCache)) continue;
            nodeCache.add(coord);
        }
        this.entityCache.clear();
        this.entityCache.addAll(entityCache);
        this.nodeCache.clear();
        this.nodeCache.addAll(nodeCache);
        this.emitterCache.clear();
        this.emitterCache.addAll(emitterCache);
        this.networkCache.clear();
        this.networkCache.addAll(networkCache);
        this.channelCache.clear();
        this.channelCache.addAll(channelCache);
    }

    @Override
    public BlockCoords getFirstConnection(CacheTypes type) {
        ArrayList<BlockCoords> coords = this.getConnections(type, true);
        if (coords.isEmpty()) {
            return null;
        }
        return coords.get(0);
    }

    @Override
    public Block getFirstBlock(CacheTypes type) {
        BlockCoords connection = this.getFirstConnection(type);
        if (connection == null) {
            return null;
        }
        return connection.getBlock();
    }

    @Override
    public TileEntity getFirstTileEntity(CacheTypes type) {
        BlockCoords connection = this.getFirstConnection(type);
        if (connection == null) {
            return null;
        }
        return connection.getTileEntity();
    }

    @Override
    public int getNetworkID() {
        return this.networkID;
    }

    @Override
    public ArrayList<Integer> getConnectedNetworks(ArrayList<Integer> networks) {
        for (BlockCoords coord : this.channelCache) {
            IChannelProvider provider;
            INetworkCache network;
            int id;
            Object tile = FMPHelper.checkObject((Object)coord.getTileEntity());
            if (tile == null || !(tile instanceof IChannelProvider) || (id = (network = (provider = (IChannelProvider)tile).getNetwork()).getNetworkID()) == -1 || networks.contains(id)) continue;
            networks.add(id);
        }
        return networks;
    }

    public ArrayList<Integer> getFinalNetworkList() {
        ArrayList<Integer> networks = this.getConnectedNetworks(new ArrayList<Integer>());
        for (Integer id : (ArrayList)networks.clone()) {
            if (!networks.contains(id)) {
                networks.add(id);
            }
            CacheRegistry.getCache(this.networkID).getConnectedNetworks(networks);
        }
        return networks;
    }

    @Override
    public void updateNetwork(int networkID) {
        if (networkID != this.getNetworkID()) {
            this.refreshCache(networkID);
        }
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        for (BlockCoords coords : this.nodeCache) {
            Object tile = FMPHelper.checkObject((Object)coords.getTileEntity());
            if (!(tile instanceof IConnectionNode)) continue;
            LinkedHashMap<BlockCoords, ForgeDirection> connections = new LinkedHashMap<BlockCoords, ForgeDirection>();
            ((IConnectionNode)tile).addConnections(connections);
            for (Map.Entry<BlockCoords, ForgeDirection> set : connections.entrySet()) {
                if (set.getKey().contains(map)) continue;
                map.put(set.getKey(), set.getValue());
            }
        }
        this.blockCache.clear();
        this.blockCache.putAll(map);
        ArrayList<Integer> networks = this.getFinalNetworkList();
        for (Integer id : networks) {
            INetworkCache network = CacheRegistry.getCache(id);
            LinkedHashMap blocks = (LinkedHashMap)network.getExternalBlocks(false).clone();
            for (Map.Entry set : blocks.entrySet()) {
                if (((BlockCoords)set.getKey()).contains(map)) continue;
                map.put(set.getKey(), set.getValue());
            }
        }
        this.networkedCache.clear();
        this.networkedCache.putAll(map);
        this.cachedItems = this.getCachedItems(this.cachedItems.items);
        this.cachedFluids = this.getCachedFluids(this.cachedFluids.fluids);
    }

    @Override
    public ItemWrapper.StorageItems getStoredItems() {
        return this.cachedItems;
    }

    @Override
    public FluidWrapper.StorageFluids getStoredFluids() {
        return this.cachedFluids;
    }
}

