/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.cache;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.api.BlockCoords;
import sonar.logistics.api.cache.CacheTypes;
import sonar.logistics.api.cache.INetworkCache;
import sonar.logistics.api.cache.IStorageCache;
import sonar.logistics.api.connecting.IChannelProvider;
import sonar.logistics.api.connecting.IConnectionNode;
import sonar.logistics.api.connecting.IEntityNode;
import sonar.logistics.api.connecting.IInfoEmitter;
import sonar.logistics.api.connecting.ILogicTile;
import sonar.logistics.api.wrappers.FluidWrapper;
import sonar.logistics.api.wrappers.ItemWrapper;
import sonar.logistics.cache.StorageCache;

public class LocalNetworkCache
extends StorageCache {
    public final ILogicTile tile;
    private ItemWrapper.StorageItems cachedItems = ItemWrapper.StorageItems.EMPTY;
    private FluidWrapper.StorageFluids cachedFluids = FluidWrapper.StorageFluids.EMPTY;

    public LocalNetworkCache(ILogicTile tile) {
        this.tile = tile;
    }

    @Override
    public Map.Entry<BlockCoords, ForgeDirection> getExternalBlock(boolean includeChannels) {
        if (this.tile instanceof IConnectionNode) {
            LinkedHashMap<BlockCoords, ForgeDirection> map = new LinkedHashMap<BlockCoords, ForgeDirection>();
            ((IConnectionNode)this.tile).addConnections(map);
            for (Map.Entry<BlockCoords, ForgeDirection> entry : map.entrySet()) {
                if (entry.getKey().getBlock(entry.getKey().getWorld()) == null) continue;
                return entry;
            }
        }
        if (this.tile instanceof IChannelProvider) {
            IChannelProvider provider = (IChannelProvider)this.tile;
            return provider.getNetwork().getExternalBlock(includeChannels);
        }
        return null;
    }

    @Override
    public LinkedHashMap<BlockCoords, ForgeDirection> getExternalBlocks(boolean includeChannels) {
        LinkedHashMap<BlockCoords, ForgeDirection> map = new LinkedHashMap<BlockCoords, ForgeDirection>();
        if (this.tile instanceof IConnectionNode) {
            LinkedHashMap<BlockCoords, ForgeDirection> connections = new LinkedHashMap<BlockCoords, ForgeDirection>();
            ((IConnectionNode)this.tile).addConnections(connections);
            for (Map.Entry<BlockCoords, ForgeDirection> set : connections.entrySet()) {
                if (map.containsKey(set.getKey())) continue;
                map.put(set.getKey(), set.getValue());
            }
        }
        if (this.tile instanceof IChannelProvider) {
            IChannelProvider provider = (IChannelProvider)this.tile;
            return provider.getNetwork().getExternalBlocks(includeChannels);
        }
        return map;
    }

    @Override
    public ArrayList<BlockCoords> getConnections(CacheTypes type, boolean includeChannels) {
        ArrayList<BlockCoords> array = new ArrayList<BlockCoords>();
        if (this.tile instanceof IChannelProvider) {
            IChannelProvider provider = (IChannelProvider)this.tile;
            return provider.getNetwork().getConnections(type, includeChannels);
        }
        switch (type) {
            case ENTITY_NODES: {
                if (!(this.tile instanceof IEntityNode)) break;
                array.add(this.tile.getCoords());
                break;
            }
            case NODES: {
                if (!(this.tile instanceof IConnectionNode)) break;
                array.add(this.tile.getCoords());
                break;
            }
            case EMITTER: {
                if (!(this.tile instanceof IInfoEmitter)) break;
                array.add(this.tile.getCoords());
                break;
            }
            case NETWORK: {
                if (!(this.tile instanceof ILogicTile)) break;
                array.add(this.tile.getCoords());
                break;
            }
        }
        return array;
    }

    @Override
    public BlockCoords getFirstConnection(CacheTypes type) {
        ArrayList<BlockCoords> coords = this.getConnections(type, true);
        if (coords.isEmpty()) {
            return null;
        }
        return coords.get(0);
    }

    @Override
    public Block getFirstBlock(CacheTypes type) {
        BlockCoords connection = this.getFirstConnection(type);
        if (connection == null) {
            return null;
        }
        return connection.getBlock();
    }

    @Override
    public TileEntity getFirstTileEntity(CacheTypes type) {
        BlockCoords connection = this.getFirstConnection(type);
        if (connection == null) {
            return null;
        }
        return connection.getTileEntity();
    }

    @Override
    public int getNetworkID() {
        if (this.tile instanceof IChannelProvider) {
            IChannelProvider provider = (IChannelProvider)this.tile;
            return provider.getNetwork().getNetworkID();
        }
        return -1;
    }

    @Override
    public ArrayList<Integer> getConnectedNetworks(ArrayList<Integer> networks) {
        return networks;
    }

    @Override
    public ItemWrapper.StorageItems getStoredItems() {
        IChannelProvider provider;
        INetworkCache cache;
        if (this.tile instanceof IChannelProvider && (cache = (provider = (IChannelProvider)this.tile).getNetwork()) != null && cache instanceof IStorageCache) {
            return ((IStorageCache)cache).getStoredItems();
        }
        return this.getCachedItems(this.cachedItems.items);
    }

    @Override
    public FluidWrapper.StorageFluids getStoredFluids() {
        IChannelProvider provider;
        INetworkCache cache;
        if (this.tile instanceof IChannelProvider && (cache = (provider = (IChannelProvider)this.tile).getNetwork()) != null && cache instanceof IStorageCache) {
            return ((IStorageCache)cache).getStoredFluids();
        }
        return this.getCachedFluids(this.cachedFluids.fluids);
    }
}

