/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.api.utils;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import sonar.core.api.BlockCoords;

public class IdentifiedCoords {
    public String coordString = "";
    public ItemStack block;
    public BlockCoords blockCoords;

    public IdentifiedCoords(String name, ItemStack block, BlockCoords coords) {
        this.coordString = name == null ? "" : name;
        this.block = block;
        this.blockCoords = coords;
    }

    public static IdentifiedCoords readFromNBT(NBTTagCompound tag) {
        if (tag.func_74767_n("b")) {
            return new IdentifiedCoords(tag.func_74779_i("clientName"), tag.func_74764_b("block") ? ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("block")) : null, BlockCoords.readFromNBT((NBTTagCompound)tag));
        }
        return null;
    }

    public static void writeToNBT(NBTTagCompound tag, IdentifiedCoords coords) {
        if (coords != null) {
            tag.func_74757_a("b", true);
            tag.func_74778_a("clientName", coords.coordString);
            if (coords.block != null) {
                NBTTagCompound block = new NBTTagCompound();
                coords.block.func_77955_b(block);
                tag.func_74782_a("block", (NBTBase)block);
            }
            BlockCoords.writeToNBT((NBTTagCompound)tag, (BlockCoords)coords.blockCoords);
        } else {
            tag.func_74757_a("b", false);
        }
    }

    public static IdentifiedCoords readCoords(ByteBuf buf) {
        if (buf.readBoolean()) {
            String name = ByteBufUtils.readUTF8String((ByteBuf)buf);
            ItemStack block = null;
            if (buf.readBoolean()) {
                block = ByteBufUtils.readItemStack((ByteBuf)buf);
            }
            BlockCoords coords = BlockCoords.readFromBuf((ByteBuf)buf);
            return new IdentifiedCoords(name, block, coords);
        }
        return null;
    }

    public static void writeCoords(ByteBuf buf, IdentifiedCoords coords) {
        if (coords != null) {
            buf.writeBoolean(true);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)coords.coordString);
            if (coords.block != null) {
                buf.writeBoolean(true);
                ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)coords.block);
            } else {
                buf.writeBoolean(false);
            }
            BlockCoords.writeToBuf((ByteBuf)buf, (BlockCoords)coords.blockCoords);
        } else {
            buf.writeBoolean(false);
        }
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof IdentifiedCoords) {
            IdentifiedCoords coords = (IdentifiedCoords)obj;
            return this.coordString.equals(coords.coordString) && coords.blockCoords.equals((Object)this.blockCoords);
        }
        return false;
    }
}

