/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.api.utils;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.api.BlockCoords;
import sonar.logistics.api.utils.IdentifiedCoords;

public class ExternalCoords {
    public String coordString = "";
    public ItemStack block;
    public BlockCoords blockCoords;
    public ForgeDirection dir;

    public ExternalCoords(String name, ItemStack block, BlockCoords coords, ForgeDirection dir) {
        this.coordString = name == null ? "" : name;
        this.block = block;
        this.blockCoords = coords;
        this.dir = dir;
    }

    public ExternalCoords(IdentifiedCoords coords, ForgeDirection dir) {
        this.coordString = coords.coordString;
        this.block = coords.block;
        this.blockCoords = coords.blockCoords;
        this.dir = dir;
    }

    public IdentifiedCoords getIdentifiedCoords() {
        return new IdentifiedCoords(this.coordString, this.block, this.blockCoords);
    }

    public static ExternalCoords readFromNBT(NBTTagCompound tag) {
        if (tag.func_74767_n("b")) {
            return new ExternalCoords(tag.func_74779_i("clientName"), tag.func_74764_b("block") ? ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("block")) : null, BlockCoords.readFromNBT((NBTTagCompound)tag), ForgeDirection.valueOf((String)tag.func_74779_i("dir")));
        }
        return null;
    }

    public static void writeToNBT(NBTTagCompound tag, ExternalCoords coords) {
        if (coords != null) {
            tag.func_74757_a("b", true);
            tag.func_74778_a("clientName", coords.coordString);
            if (coords.block != null) {
                NBTTagCompound block = new NBTTagCompound();
                coords.block.func_77955_b(block);
                tag.func_74782_a("block", (NBTBase)block);
            }
            BlockCoords.writeToNBT((NBTTagCompound)tag, (BlockCoords)coords.blockCoords);
            tag.func_74778_a("dir", coords.dir.name());
        } else {
            tag.func_74757_a("b", false);
        }
    }

    public static ExternalCoords readCoords(ByteBuf buf) {
        if (buf.readBoolean()) {
            String name = ByteBufUtils.readUTF8String((ByteBuf)buf);
            ItemStack block = null;
            if (buf.readBoolean()) {
                block = ByteBufUtils.readItemStack((ByteBuf)buf);
            }
            BlockCoords coords = BlockCoords.readFromBuf((ByteBuf)buf);
            ForgeDirection dir = ForgeDirection.valueOf((String)ByteBufUtils.readUTF8String((ByteBuf)buf));
            return new ExternalCoords(name, block, coords, dir);
        }
        return null;
    }

    public static void writeCoords(ByteBuf buf, ExternalCoords coords) {
        if (coords != null) {
            buf.writeBoolean(true);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)coords.coordString);
            if (coords.block != null) {
                buf.writeBoolean(true);
                ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)coords.block);
            } else {
                buf.writeBoolean(false);
            }
            BlockCoords.writeToBuf((ByteBuf)buf, (BlockCoords)coords.blockCoords);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)coords.dir.name());
        } else {
            buf.writeBoolean(false);
        }
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof ExternalCoords) {
            ExternalCoords coords = (ExternalCoords)obj;
            return this.coordString.equals(coords.coordString) && coords.blockCoords.equals((Object)this.blockCoords) && coords.dir.name().equals(this.dir.name());
        }
        return false;
    }
}

