/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.api.signals;

import net.minecraft.nbt.NBTTagCompound;
import sonar.logistics.api.info.ILogicInfo;
import sonar.logistics.api.signals.IntegerStatement;
import sonar.logistics.api.signals.StringStatement;

public abstract class SignallerStatement {
    public static final int number = 0;
    public static final int string = 1;
    public boolean invert;

    public abstract int getType();

    public abstract boolean canSignal(ILogicInfo var1);

    public void invertSignal() {
        this.invert = !this.invert;
    }

    public static void writeToNBT(NBTTagCompound tag, SignallerStatement statement) {
        tag.func_74768_a("t", statement.getType());
        tag.func_74757_a("in", statement.invert);
        switch (statement.getType()) {
            case 0: {
                IntegerStatement integer = (IntegerStatement)statement;
                tag.func_74768_a("emit", ((Integer)integer.emitType.getObject()).intValue());
                tag.func_74772_a("target", ((Long)integer.target.getObject()).longValue());
                break;
            }
            case 1: {
                StringStatement string = (StringStatement)statement;
                tag.func_74778_a("word", (String)string.target.getObject());
            }
        }
    }

    public static SignallerStatement readFromNBT(NBTTagCompound tag) {
        int type = tag.func_74762_e("t");
        SignallerStatement statement = null;
        switch (type) {
            case 0: {
                statement = new IntegerStatement(tag.func_74762_e("emit"), tag.func_74763_f("target"));
                break;
            }
            case 1: {
                statement = new StringStatement(tag.func_74779_i("word"));
            }
        }
        if (statement != null) {
            statement.invert = tag.func_74767_n("in");
        }
        return statement;
    }
}

