/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.api.info;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import sonar.core.helpers.NBTHelper;
import sonar.logistics.api.LogisticsAPI;
import sonar.logistics.api.info.ILogicInfo;
import sonar.logistics.api.providers.ICategoryProvider;

public class LogicInfo<T extends LogicInfo>
extends ILogicInfo<T> {
    public boolean emptyData;
    public boolean entity = false;
    public String category = "ERROR";
    public String subCategory = "ERROR";
    public String data = "";
    public String suffix = "";
    public int dataType;
    public int providerID = -1;
    public int catID = -1;
    public int subCatID = -1;

    public LogicInfo() {
    }

    public LogicInfo(int providerID, int category, int subCategory, Object data) {
        this.providerID = providerID;
        this.catID = category;
        this.subCatID = subCategory;
        this.data = data.toString();
        this.dataType = data instanceof Long || data instanceof Integer || data instanceof Short ? 0 : 1;
    }

    public LogicInfo(int providerID, String category, String subCategory, Object data) {
        this.providerID = providerID;
        this.category = category;
        this.subCategory = subCategory;
        this.data = data.toString();
        this.dataType = data instanceof Long || data instanceof Integer || data instanceof Short ? 0 : 1;
    }

    public LogicInfo addSuffix(String suffix) {
        this.suffix = suffix;
        return this;
    }

    public LogicInfo isEntityData(boolean bool) {
        this.entity = bool;
        return this;
    }

    @Override
    public String getName() {
        return "Standard";
    }

    @Override
    public int getProviderID() {
        return this.providerID;
    }

    @Override
    public String getCategory() {
        ICategoryProvider provider = this.getRegistryObject();
        if (this.providerID != -1 && provider == null) {
            return "UNLOADED MOD";
        }
        return this.catID == -1 || this.providerID == -1 ? this.category : provider.getCategory(this.catID);
    }

    @Override
    public String getSubCategory() {
        ICategoryProvider provider = this.getRegistryObject();
        if (this.providerID != -1 && provider == null) {
            return "ERROR";
        }
        return this.subCatID == -1 || this.providerID == -1 ? this.subCategory : provider.getSubCategory(this.subCatID);
    }

    public ICategoryProvider getRegistryObject() {
        if (this.entity) {
            return LogisticsAPI.getRegistry().getEntityProvider(this.providerID);
        }
        return LogisticsAPI.getRegistry().getTileProvider(this.providerID);
    }

    @Override
    public String getData() {
        return !this.emptyData ? this.data : (this.dataType == 1 ? "NO DATA" : String.valueOf(0));
    }

    @Override
    public String getDisplayableData() {
        if (this.suffix != null) {
            return this.getData() + " " + this.suffix;
        }
        return this.getData();
    }

    @Override
    public int getDataType() {
        return this.dataType;
    }

    @Override
    public void readFromBuf(ByteBuf buf) {
        this.entity = buf.readBoolean();
        this.providerID = buf.readInt();
        if (buf.readBoolean()) {
            this.catID = buf.readInt();
        } else {
            this.category = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }
        if (buf.readBoolean()) {
            this.subCatID = buf.readInt();
        } else {
            this.subCategory = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }
        this.data = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.dataType = buf.readInt();
        this.emptyData = buf.readBoolean();
        if (buf.readBoolean()) {
            this.suffix = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }
    }

    @Override
    public void writeToBuf(ByteBuf buf) {
        buf.writeBoolean(this.entity);
        buf.writeInt(this.providerID);
        if (this.catID != -1) {
            buf.writeBoolean(true);
            buf.writeInt(this.catID);
        } else {
            buf.writeBoolean(false);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.category);
        }
        if (this.subCatID != -1) {
            buf.writeBoolean(true);
            buf.writeInt(this.subCatID);
        } else {
            buf.writeBoolean(false);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.subCategory);
        }
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.data);
        buf.writeInt(this.dataType);
        buf.writeBoolean(this.emptyData);
        if (this.suffix != null) {
            buf.writeBoolean(true);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.suffix);
        } else {
            buf.writeBoolean(false);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.entity = tag.func_74767_n("e");
        this.providerID = tag.func_74762_e("prov");
        if (tag.func_74767_n("BcatID")) {
            this.catID = tag.func_74762_e("catID");
        } else {
            this.category = tag.func_74779_i("category");
        }
        if (tag.func_74767_n("BsubCatID")) {
            this.subCatID = tag.func_74762_e("subCatID");
        } else {
            this.subCategory = tag.func_74779_i("subCategory");
        }
        this.data = tag.func_74779_i("data");
        this.dataType = tag.func_74762_e("dataType");
        this.emptyData = tag.func_74767_n("emptyData");
        if (tag.func_74767_n("hasSuffix")) {
            this.suffix = tag.func_74779_i("suffix");
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74757_a("e", this.entity);
        tag.func_74768_a("prov", this.providerID);
        if (this.catID != -1) {
            tag.func_74757_a("BcatID", true);
            tag.func_74768_a("catID", this.catID);
        } else {
            tag.func_74757_a("BcatID", false);
            tag.func_74778_a("category", this.category);
        }
        if (this.subCatID != -1) {
            tag.func_74757_a("BsubCatID", true);
            tag.func_74768_a("subCatID", this.subCatID);
        } else {
            tag.func_74757_a("BsubCatID", false);
            tag.func_74778_a("subCategory", this.subCategory);
        }
        tag.func_74778_a("data", this.data);
        tag.func_74768_a("dataType", this.dataType);
        tag.func_74757_a("emptyData", this.emptyData);
        if (this.suffix != null) {
            tag.func_74757_a("hasSuffix", true);
            tag.func_74778_a("suffix", this.suffix);
        } else {
            tag.func_74757_a("hasSuffix", false);
        }
    }

    public LogicInfo instance() {
        return new LogicInfo<T>();
    }

    public void setData(String string) {
        this.data = string;
    }

    @Override
    public void writeUpdate(LogicInfo currentInfo, NBTTagCompound tag) {
        if (currentInfo.entity != this.entity) {
            this.entity = currentInfo.entity;
            tag.func_74757_a("e", this.entity);
        }
        if (currentInfo.providerID != this.providerID) {
            this.providerID = currentInfo.providerID;
            tag.func_74768_a("id", this.providerID);
        }
        if (currentInfo.dataType != this.dataType) {
            this.dataType = currentInfo.dataType;
            tag.func_74768_a("dT", this.dataType);
        }
        if (currentInfo.catID == -1 && !currentInfo.category.equals(this.category)) {
            this.category = currentInfo.category;
            tag.func_74778_a("c", this.category);
        } else if (currentInfo.catID != -1 && currentInfo.catID != this.catID) {
            this.catID = currentInfo.catID;
            tag.func_74768_a("cI", this.catID);
        }
        if (currentInfo.subCatID == -1 && !currentInfo.subCategory.equals(this.subCategory)) {
            this.subCategory = currentInfo.subCategory;
            tag.func_74778_a("sC", this.subCategory);
        } else if (currentInfo.subCatID != -1 && currentInfo.subCatID != this.subCatID) {
            this.subCatID = currentInfo.subCatID;
            tag.func_74768_a("sCI", this.subCatID);
        }
        if (!currentInfo.data.equals(this.data)) {
            this.data = currentInfo.data;
            tag.func_74778_a("d", this.data);
        }
        if (currentInfo.suffix != null && !currentInfo.suffix.equals(this.suffix)) {
            this.suffix = currentInfo.suffix;
            tag.func_74778_a("s", this.suffix);
        }
    }

    @Override
    public void readUpdate(NBTTagCompound tag) {
        if (tag.func_74764_b("e")) {
            this.entity = tag.func_74767_n("e");
        }
        if (tag.func_74764_b("id")) {
            this.providerID = tag.func_74762_e("id");
        }
        if (tag.func_74764_b("dT")) {
            this.dataType = tag.func_74762_e("dT");
        }
        if (tag.func_74764_b("c")) {
            this.category = tag.func_74779_i("c");
        }
        if (tag.func_74764_b("cI")) {
            this.catID = tag.func_74762_e("cI");
        }
        if (tag.func_74764_b("sC")) {
            this.subCategory = tag.func_74779_i("sC");
        }
        if (tag.func_74764_b("sCI")) {
            this.subCatID = tag.func_74762_e("sCI");
        }
        if (tag.func_74764_b("d")) {
            this.data = tag.func_74779_i("d");
        }
        if (tag.func_74764_b("s")) {
            this.suffix = tag.func_74779_i("s");
        }
    }

    @Override
    public NBTHelper.SyncType isMatchingData(T currentInfo) {
        if (((LogicInfo)currentInfo).getProviderID() != this.providerID || ((LogicInfo)currentInfo).dataType != this.dataType || !((LogicInfo)currentInfo).category.equals(this.category) || !((LogicInfo)currentInfo).subCategory.equals(this.subCategory) || ((LogicInfo)currentInfo).catID != this.catID || ((LogicInfo)currentInfo).subCatID != this.subCatID) {
            return NBTHelper.SyncType.SAVE;
        }
        if (!((LogicInfo)currentInfo).data.equals(this.data) || !((LogicInfo)currentInfo).suffix.equals(this.suffix)) {
            return NBTHelper.SyncType.SYNC;
        }
        return null;
    }
}

