/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.api.info;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import sonar.core.helpers.NBTHelper;
import sonar.core.utils.IBufObject;
import sonar.core.utils.INBTObject;
import sonar.logistics.api.LogisticsAPI;
import sonar.logistics.api.render.ScreenType;

public abstract class ILogicInfo<T extends ILogicInfo>
implements INBTObject,
IBufObject {
    public int updateTime = 1;

    public ILogicInfo setUpdateTime(int time) {
        this.updateTime = time;
        return this;
    }

    public abstract String getName();

    public abstract int getProviderID();

    public abstract String getCategory();

    public abstract String getSubCategory();

    public abstract String getData();

    public abstract String getDisplayableData();

    public abstract int getDataType();

    public abstract void readFromBuf(ByteBuf var1);

    public abstract void writeToBuf(ByteBuf var1);

    public abstract void readFromNBT(NBTTagCompound var1);

    public abstract void writeToNBT(NBTTagCompound var1);

    public abstract void writeUpdate(T var1, NBTTagCompound var2);

    public abstract void readUpdate(NBTTagCompound var1);

    public abstract NBTHelper.SyncType isMatchingData(T var1);

    public final NBTHelper.SyncType getNextSyncType(T currentInfo) {
        if (currentInfo == null || !this.checkInfoTypes(currentInfo)) {
            return NBTHelper.SyncType.SAVE;
        }
        return this.isMatchingData(currentInfo);
    }

    public final boolean checkInfoTypes(T info) {
        return info == null ? false : ((ILogicInfo)info).getName().equals(this.getName()) && this.getProviderID() == ((ILogicInfo)info).getProviderID();
    }

    public final boolean isMatchingInfo(T currentInfo) {
        NBTHelper.SyncType match = this.getNextSyncType(currentInfo);
        return match == null || match == NBTHelper.SyncType.SYNC;
    }

    public final boolean equals(Object obj) {
        ILogicInfo target;
        if (obj instanceof ILogicInfo && (target = (ILogicInfo)obj) instanceof ILogicInfo && this.checkInfoTypes(target)) {
            return this.isMatchingData(target) == null;
        }
        return false;
    }

    public void renderInfo(Tessellator tess, TileEntity tile, float minX, float minY, float maxX, float maxY, float zOffset, ScreenType type) {
        LogisticsAPI.getInfoRenderer().renderStandardInfo(this, minX, minY, maxX, maxY, zOffset, type);
    }

    public int updateTicks() {
        return this.updateTime;
    }

    public boolean isLoadable() {
        return true;
    }
}

