/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.testing.tile;

import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.lib.transform.vector.Pos;
import com.builtbroken.mc.testing.junit.AbstractTest;
import com.builtbroken.mc.testing.junit.world.FakeWorld;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import org.junit.Test;

public abstract class AbstractTileEntityTest<T extends TileEntity, B extends Block>
extends AbstractTest {
    protected Class<T> tileClazz;
    protected B block;

    public AbstractTileEntityTest() {
    }

    public AbstractTileEntityTest(B block, Class<T> tileClazz) {
        this.block = block;
        this.tileClazz = tileClazz;
    }

    public AbstractTileEntityTest(B block, String name, Class<T> tileClazz) {
        this(block, tileClazz);
        try {
            TileEntity.func_145826_a(tileClazz, (String)name);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void setUpForEntireClass() {
        super.setUpForEntireClass();
        if (this.tileClazz == null) {
            throw new IllegalArgumentException("TileClass can not be null");
        }
        if (this.block == null) {
            throw new IllegalArgumentException("Block can not be null");
        }
        if (Engine.instance == null) {
            Engine.instance = new Engine();
            Engine.instance.packetHandler.init();
        }
    }

    protected T newTile() {
        try {
            return (T)((TileEntity)this.tileClazz.newInstance());
        }
        catch (InstantiationException e) {
            AbstractTileEntityTest.fail((String)"Could create a new instance, need a constructor with zero arguments for default newTile method");
        }
        catch (IllegalAccessException e) {
            AbstractTileEntityTest.fail((String)"Couldn't access constructor for tile, need a public constructor for default newTile method");
        }
        return null;
    }

    @Test
    public void testPlacement() {
        FakeWorld world = FakeWorld.newWorld((String)"testGetBlockMetadata");
        for (int i = 0; i < 16; ++i) {
            int placement_meta = this.block.func_149692_a(i);
            world.func_147465_d(10, 10, 10, this.block, placement_meta, 3);
            AbstractTileEntityTest.assertTrue((world.func_147439_a(10, 10, 10) == this.block ? 1 : 0) != 0);
            AbstractTileEntityTest.assertTrue((world.func_147438_o(10, 10, 10).getClass() == this.tileClazz ? 1 : 0) != 0);
            world.func_147438_o(10, 10, 10).func_70296_d();
            int meta = world.func_72805_g(10, 10, 10);
            int placed_meta = world.func_147438_o(10, 10, 10).func_145832_p();
            AbstractTileEntityTest.assertTrue((String)("World meta = " + meta + " Tile meta = " + placed_meta), (placed_meta == meta ? 1 : 0) != 0);
        }
    }

    @Test
    public void testWorldObj() {
        T tile = this.newTile();
        FakeWorld world = FakeWorld.newWorld((String)"testGetWorldObj");
        AbstractTileEntityTest.assertNull((Object)tile.func_145831_w());
        tile.func_145834_a((World)world);
        AbstractTileEntityTest.assertNotNull((Object)tile.func_145831_w());
    }

    @Test
    public void testWriteToNBT() {
        T tile = this.newTile();
        ((TileEntity)tile).field_145851_c = 10;
        ((TileEntity)tile).field_145848_d = 11;
        ((TileEntity)tile).field_145849_e = 3;
        FakeWorld world = FakeWorld.newWorld((String)"testWriteToNBT");
        tile.func_145834_a((World)world);
        NBTTagCompound nbt = new NBTTagCompound();
        AbstractTileEntityTest.assertTrue((String)"NBT should have not tags on init", (boolean)nbt.func_82582_d());
        tile.func_145841_b(nbt);
        AbstractTileEntityTest.assertTrue((String)"NBT should have saved something", (!nbt.func_82582_d() ? 1 : 0) != 0);
        AbstractTileEntityTest.assertTrue((String)"X coord should have saved", (boolean)nbt.func_74764_b("x"));
        AbstractTileEntityTest.assertTrue((String)"X should equal tile xCoord", (nbt.func_74762_e("x") == ((TileEntity)tile).field_145851_c ? 1 : 0) != 0);
        AbstractTileEntityTest.assertTrue((String)"Y coord should have saved", (boolean)nbt.func_74764_b("y"));
        AbstractTileEntityTest.assertTrue((String)"Y should equal tile yCoord", (nbt.func_74762_e("y") == ((TileEntity)tile).field_145848_d ? 1 : 0) != 0);
        AbstractTileEntityTest.assertTrue((String)"Z coord should have saved", (boolean)nbt.func_74764_b("z"));
        AbstractTileEntityTest.assertTrue((String)"Z should equal tile zCoord", (nbt.func_74762_e("z") == ((TileEntity)tile).field_145849_e ? 1 : 0) != 0);
        AbstractTileEntityTest.assertTrue((String)"ID tag should have saved", (boolean)nbt.func_74764_b("id"));
    }

    @Test
    public void testReadFromNBT() {
        T tile = this.newTile();
        ((TileEntity)tile).field_145851_c = 10;
        ((TileEntity)tile).field_145848_d = 11;
        ((TileEntity)tile).field_145849_e = 3;
        FakeWorld world = FakeWorld.newWorld((String)"testReadFromNBT");
        tile.func_145834_a((World)world);
        NBTTagCompound nbt = new NBTTagCompound();
        AbstractTileEntityTest.assertTrue((String)"NBT should have not tags on init", (boolean)nbt.func_82582_d());
        tile.func_145841_b(nbt);
        AbstractTileEntityTest.assertTrue((String)"NBT should have saved something", (!nbt.func_82582_d() ? 1 : 0) != 0);
        tile = this.newTile();
        world = FakeWorld.newWorld((String)"testReadFromNBT2");
        tile.func_145834_a((World)world);
        tile.func_145839_a(nbt);
        AbstractTileEntityTest.assertTrue((((TileEntity)tile).field_145851_c == 10 ? 1 : 0) != 0);
        AbstractTileEntityTest.assertTrue((((TileEntity)tile).field_145848_d == 11 ? 1 : 0) != 0);
        AbstractTileEntityTest.assertTrue((((TileEntity)tile).field_145849_e == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testUpdateEntity() {
        FakeWorld world = FakeWorld.newWorld((String)"testUpdateEntity");
        world.func_147449_b(10, 11, 12, this.block);
        TileEntity tile = world.func_147438_o(10, 11, 12);
        for (int i = 0; i < 1000; ++i) {
            tile.func_145845_h();
        }
    }

    @Test
    public void testMarkDirty() {
        FakeWorld world = FakeWorld.newWorld((String)"testMarkDirty");
        world.func_147449_b(10, 11, 12, this.block);
        world.func_147438_o(10, 11, 12).func_70296_d();
    }

    @Test
    public void testGetBlockMetadata() {
        FakeWorld world = FakeWorld.newWorld((String)"testGetBlockMetadata");
        world.func_147449_b(10, 11, 12, this.block);
        world.func_147438_o(10, 11, 12).func_70296_d();
        int meta = world.func_72805_g(10, 11, 12);
        AbstractTileEntityTest.assertTrue((world.func_147438_o(10, 11, 12).func_145832_p() == meta ? 1 : 0) != 0);
    }

    @Test
    public void testGetDistanceFrom() {
        T tile = this.newTile();
        FakeWorld world = FakeWorld.newWorld((String)"testGetDistanceFrom");
        tile.func_145834_a((World)world);
        double distance = tile.func_145835_a(10.0, 14.0, 15.0);
        double distance2 = ((Pos)new Pos(0.5).sub(10.0, 14.0, 15.0)).magnitudeSquared();
        AbstractTileEntityTest.assertTrue((String)("Distance = " + distance + "  Distance2 = " + distance2), (Math.abs(distance - distance2) < 0.01 ? 1 : 0) != 0);
    }

    @Test
    public void testGetMaxRenderDistanceSquared() {
        FakeWorld world = FakeWorld.newWorld((String)"testGetMaxRenderDistanceSquared");
        world.func_147449_b(10, 11, 12, this.block);
        double d = world.func_147438_o(10, 11, 12).func_145833_n();
        AbstractTileEntityTest.assertTrue((d >= 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetBlockType() {
        FakeWorld world = FakeWorld.newWorld((String)"testGetBlockType");
        world.func_147449_b(10, 11, 12, this.block);
        AbstractTileEntityTest.assertTrue((world.func_147438_o(10, 11, 12).func_145838_q() == this.block ? 1 : 0) != 0);
    }

    @Test
    public void testGetDescriptionPacket() {
    }

    @Test
    public void testIsInvalid() {
        FakeWorld world = FakeWorld.newWorld((String)"testIsInvalid");
        world.func_147449_b(10, 11, 12, this.block);
        world.func_147438_o(10, 11, 12).func_145837_r();
    }

    @Test
    public void testInvalidate() {
        FakeWorld world = FakeWorld.newWorld((String)"testInvalidate");
        world.func_147449_b(10, 11, 12, this.block);
        TileEntity tile = world.func_147438_o(10, 11, 12);
        tile.func_145843_s();
        AbstractTileEntityTest.assertTrue((boolean)tile.func_145837_r());
    }

    @Test
    public void testValidate() {
        FakeWorld world = FakeWorld.newWorld((String)"testValidate");
        world.func_147449_b(10, 11, 12, this.block);
        TileEntity tile = world.func_147438_o(10, 11, 12);
        tile.func_145829_t();
        AbstractTileEntityTest.assertTrue((!tile.func_145837_r() ? 1 : 0) != 0);
    }

    @Test
    public void testReceiveClientEvent() {
        FakeWorld world = FakeWorld.newWorld((String)"testReceiveClientEvent");
        world.func_147449_b(10, 11, 12, this.block);
        AbstractTileEntityTest.assertFalse((String)"Might want to implement a test for this if you return true", (boolean)world.func_147438_o(10, 11, 12).func_145842_c(0, 0));
    }

    @Test
    public void testUpdateContainingBlockInfo() {
        FakeWorld world = FakeWorld.newWorld((String)"testUpdateContainingBlockInfo");
        world.func_147449_b(10, 11, 12, this.block);
        world.func_147438_o(10, 11, 12).func_145836_u();
    }

    @Test
    public void testCanUpdate() {
        FakeWorld world = FakeWorld.newWorld((String)"testCanUpdate");
        world.func_147449_b(10, 11, 12, this.block);
        world.func_147438_o(10, 11, 12).canUpdate();
    }

    @Test
    public void testOnDataPacket() {
        FakeWorld world = FakeWorld.newWorld((String)"testOnDataPacket");
        world.func_147449_b(10, 11, 12, this.block);
        world.func_147438_o(10, 11, 12).onDataPacket(null, null);
    }

    @Test
    public void testOnChunkUnload() {
        FakeWorld world = FakeWorld.newWorld((String)"testOnChunkUnload");
        world.func_147449_b(10, 11, 12, this.block);
        world.func_147438_o(10, 11, 12).onChunkUnload();
    }

    @Test
    public void testShouldRefresh() {
        FakeWorld world = FakeWorld.newWorld((String)"testShouldRefresh");
        world.func_147449_b(10, 11, 12, this.block);
        world.func_147438_o(10, 11, 12).shouldRefresh(this.block, this.block, world.func_72805_g(10, 11, 12), world.func_72805_g(10, 11, 12), (World)world, 10, 11, 12);
    }

    @Test
    public void testShouldRenderInPass() {
        FakeWorld world = FakeWorld.newWorld((String)"testShouldRenderInPass");
        world.func_147449_b(10, 11, 12, this.block);
        world.func_147438_o(10, 11, 12).shouldRenderInPass(0);
    }

    @Test
    public void testGetRenderBoundingBox() {
        FakeWorld world = FakeWorld.newWorld((String)"testGetRenderBoundingBox");
        world.func_147449_b(10, 11, 12, this.block);
        AxisAlignedBB bounds = world.func_147438_o(10, 11, 12).getRenderBoundingBox();
        if (bounds != null) {
            AbstractTileEntityTest.assertFalse((bounds.field_72340_a > bounds.field_72336_d ? 1 : 0) != 0);
            AbstractTileEntityTest.assertFalse((bounds.field_72338_b > bounds.field_72337_e ? 1 : 0) != 0);
            AbstractTileEntityTest.assertFalse((bounds.field_72339_c > bounds.field_72334_f ? 1 : 0) != 0);
            AbstractTileEntityTest.assertFalse((bounds.field_72339_c == bounds.field_72334_f && bounds.field_72338_b == bounds.field_72337_e && bounds.field_72339_c == bounds.field_72334_f ? 1 : 0) != 0);
        }
    }
}

