/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.prefab.tile;

import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.jlib.data.vector.Pos3D;
import com.builtbroken.mc.api.IWorldPosition;
import com.builtbroken.mc.api.event.tile.TileEvent;
import com.builtbroken.mc.api.items.ISimpleItemRenderer;
import com.builtbroken.mc.api.tile.IPlayerUsing;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.core.network.packet.AbstractPacket;
import com.builtbroken.mc.core.registry.implement.IRegistryInit;
import com.builtbroken.mc.lib.helper.MathUtility;
import com.builtbroken.mc.lib.helper.WrenchUtility;
import com.builtbroken.mc.lib.render.block.BlockRenderHandler;
import com.builtbroken.mc.lib.render.block.RenderTileDummy;
import com.builtbroken.mc.lib.transform.region.Cube;
import com.builtbroken.mc.lib.transform.vector.Location;
import com.builtbroken.mc.lib.transform.vector.Pos;
import com.builtbroken.mc.prefab.tile.BlockTile;
import com.builtbroken.mc.prefab.tile.entity.TileEntityBase;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public abstract class Tile
extends TileEntityBase
implements IWorldPosition,
IPlayerUsing,
IRegistryInit {
    public BlockTile block = null;
    private IBlockAccess access = null;
    public String domain;
    public String name;
    public CreativeTabs creativeTab;
    public Material material = Material.field_151571_B;
    public float hardness = 1.0f;
    public float resistance = 1.0f;
    public boolean canEmmitRedstone = false;
    public boolean isOpaque = false;
    public Block.SoundType stepSound = Block.field_149769_e;
    public Class<? extends ItemBlock> itemBlock = ItemBlock.class;
    protected Cube bounds = new Cube(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    @SideOnly(value=Side.CLIENT)
    protected HashMap<String, IIcon> icons;
    protected boolean useSidedTextures = false;
    protected String textureName;
    public boolean dynamicRendererCrashed = false;
    public boolean renderNormalBlock = true;
    public boolean renderTileEntity = true;
    public int renderType = BlockRenderHandler.ID;
    public long ticks = 0L;
    protected int nextCleanupTick = 200;
    protected final Set<EntityPlayer> playersUsing = new HashSet<EntityPlayer>();
    protected UUID owner;
    protected String username;

    public Tile(String name, Material material) {
        this.name = name;
        this.material = material;
    }

    public Tile() {
    }

    public abstract Tile newTile();

    public Tile newTile(World world, int meta) {
        return this.newTile();
    }

    public final void func_145845_h() {
        if (this.ticks == 0L) {
            this.firstTick();
        } else {
            this.update();
        }
        if (this.ticks >= Long.MAX_VALUE) {
            this.ticks = 0L;
        }
        ++this.ticks;
        if (this.ticks % (long)this.nextCleanupTick == 0L) {
            this.doCleanupCheck();
            this.nextCleanupTick = this.getNextCleanupTick();
        }
        if (this.getPlayersUsing().size() > 0) {
            this.doUpdateGuiUsers();
        }
    }

    public void func_145843_s() {
        this.field_145846_f = true;
        if (this.isServer()) {
            TileEvent.onUnLoad(this);
        }
    }

    public void func_145829_t() {
        this.field_145846_f = false;
        if (this.isServer()) {
            TileEvent.onLoad(this);
        }
    }

    protected int getNextCleanupTick() {
        return 100 + (int)(this.world().field_73012_v.nextFloat() * 2000.0f);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("tileOwnerMostSigBit") && nbt.func_74764_b("tileOwnerLeastSigBit")) {
            this.owner = new UUID(nbt.func_74763_f("tileOwnerMostSigBit"), nbt.func_74763_f("tileOwnerLeastSigBit"));
        }
        if (nbt.func_74764_b("tileOwnerUsername")) {
            this.username = nbt.func_74779_i("tileOwnerUsername");
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.owner != null) {
            nbt.func_74772_a("tileOwnerMostSigBit", this.owner.getMostSignificantBits());
            nbt.func_74772_a("tileOwnerLeastSigBit", this.owner.getLeastSignificantBits());
        }
        if (this.username != null && !this.username.isEmpty()) {
            nbt.func_74778_a("tileOwnerUsername", this.username);
        }
    }

    public void blockUpdate() {
        this.update();
    }

    public void firstTick() {
    }

    public void update() {
    }

    public void doUpdateGuiUsers() {
    }

    public void doCleanupCheck() {
    }

    public boolean onPlayerLeftClick(EntityPlayer player) {
        return false;
    }

    public boolean onPlayerActivated(EntityPlayer player, int side, Pos hit) {
        if (WrenchUtility.isUsableWrench(player, player.field_71071_by.func_70448_g(), this.xi(), this.yi(), this.zi())) {
            if (this.onPlayerRightClickWrench(player, side, hit)) {
                WrenchUtility.damageWrench(player, player.field_71071_by.func_70448_g(), this.xi(), this.yi(), this.zi());
                return true;
            }
            return false;
        }
        return this.onPlayerRightClick(player, side, hit);
    }

    protected boolean onPlayerRightClick(EntityPlayer player, int side, Pos hit) {
        return false;
    }

    protected boolean onPlayerRightClickWrench(EntityPlayer player, int side, Pos hit) {
        return false;
    }

    public void openGui(EntityPlayer player, Object mod) {
        this.openGui(player, 0, mod);
    }

    public void openGui(EntityPlayer player, int gui, Object mod) {
        if (this.isServer()) {
            player.openGui(mod, gui, this.world(), this.xi(), this.yi(), this.zi());
        }
    }

    public ArrayList<ItemStack> getDrops(int metadata, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (this.func_145838_q() != null) {
            drops.add(new ItemStack(this.func_145838_q(), this.quantityDropped(metadata, fortune), this.metadataDropped(metadata, fortune)));
        }
        return drops;
    }

    public Block func_145838_q() {
        if (this.getAccess() != null && this.block == null) {
            Block b = this.getAccess().func_147439_a(this.xi(), this.yi(), this.zi());
            if (b instanceof BlockTile) {
                this.block = (BlockTile)b;
            } else {
                Engine.error("Block at tile location " + this.toLocation() + " is not an instance of BlockTile. Destroying block " + b + " to prevent errors.");
                this.func_145843_s();
                this.world().func_147468_f(this.xi(), this.yi(), this.zi());
            }
        }
        return this.block;
    }

    public BlockTile getTileBlock() {
        return (BlockTile)this.func_145838_q();
    }

    public int quantityDropped(int meta, int fortune) {
        return 1;
    }

    public int metadataDropped(int meta, int fortune) {
        return 0;
    }

    public void getSubBlocks(Item item, CreativeTabs creativeTabs, List list) {
        list.add(new ItemStack(item, 1, 0));
    }

    public ItemStack getPickBlock(MovingObjectPosition target) {
        return this.toItemStack();
    }

    public ItemStack toItemStack() {
        return new ItemStack(this.func_145838_q(), 1, this.metadataDropped(this.func_145832_p(), 0));
    }

    @Override
    public double z() {
        return this.field_145849_e;
    }

    public int zi() {
        return this.field_145849_e;
    }

    @Override
    public double x() {
        return this.field_145851_c;
    }

    public int xi() {
        return this.field_145851_c;
    }

    @Override
    public double y() {
        return this.field_145848_d;
    }

    public int yi() {
        return this.field_145848_d;
    }

    @Override
    public World world() {
        return this.func_145831_w();
    }

    public void setBlock(BlockTile block) {
        this.block = block;
    }

    public void setAccess(IBlockAccess access) {
        this.access = access;
    }

    public IBlockAccess getAccess() {
        return this.world() != null ? this.world() : this.access;
    }

    @Deprecated
    public Pos toVector3() {
        return new Pos(this.x(), this.y(), this.z());
    }

    public Pos toPos() {
        return new Pos(this.x(), this.y(), this.z());
    }

    @Deprecated
    public Location toVectorWorld() {
        return new Location(this.world(), this.x(), this.y(), this.z());
    }

    public Location toLocation() {
        return new Location(this.world(), this.x(), this.y(), this.z());
    }

    @Override
    public void onRegistered() {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onClientRegistered() {
    }

    public void onAdded() {
        this.onWorldJoin();
    }

    public void onWorldJoin() {
    }

    public void onPlaced(EntityLivingBase entityLiving, ItemStack itemStack) {
        if (entityLiving instanceof EntityPlayer) {
            this.setOwner((EntityPlayer)entityLiving);
        }
    }

    public void onPostPlaced(int metadata) {
    }

    public void onRemove(Block block, int par6) {
        this.onWorldSeparate();
    }

    public void onWorldSeparate() {
    }

    public void onDestroyedByExplosion(Explosion ex) {
    }

    public void onNeighborChanged(Block block) {
    }

    public void onNeighborChanged(Pos pos) {
    }

    public void onCollide(Entity entity) {
    }

    public void onFillRain() {
    }

    public void notifyBlocksOfNeighborChange() {
        this.world().func_147459_d(this.xi(), this.yi(), this.zi(), this.func_145838_q());
    }

    protected void markRender() {
        this.world().func_147479_m(this.xi(), this.yi(), this.zi());
    }

    protected void markUpdate() {
        this.world().func_147471_g(this.xi(), this.yi(), this.zi());
    }

    protected void updateLight() {
        this.world().func_147451_t(this.xi(), this.yi(), this.zi());
    }

    protected void scheduleTick(int delay) {
        this.world().func_147464_a(this.xi(), this.yi(), this.zi(), this.func_145838_q(), delay);
    }

    public int getLightValue() {
        return 0;
    }

    public Iterable<Cube> getCollisionBoxes(Cube intersect, Entity entity) {
        ArrayList<Cube> boxes = new ArrayList<Cube>();
        boxes.add(this.getCollisionBounds());
        return boxes;
    }

    public Cube getSelectBounds() {
        return this.bounds;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return this.getCollisionBounds().clone().add(this.x(), this.y(), this.z()).toAABB();
    }

    public Cube getCollisionBounds() {
        return this.bounds;
    }

    public int getMetadata() {
        if (this.getAccess() != null) {
            return this.getAccess().func_72805_g(this.xi(), this.yi(), this.zi());
        }
        return 0;
    }

    public int func_145832_p() {
        if (this.world() == null) {
            return 0;
        }
        return super.func_145832_p();
    }

    public Set<EntityPlayer> getPlayersUsing() {
        return this.playersUsing;
    }

    public boolean shouldSideBeRendered(int side) {
        return this.bounds == null || side == 0 && this.bounds.min().y() > 0.0 || side == 1 && this.bounds.max().y() < 1.0 || side == 2 && this.bounds.min().z() > 0.0 || side == 3 && this.bounds.max().z() < 1.0 || side == 4 && this.bounds.min().x() > 0.0 || side == 5 && this.bounds.max().x() < 1.0 || !this.isOpaque;
    }

    public boolean isIndirectlyPowered() {
        return this.world().func_72864_z(this.xi(), this.yi(), this.zi());
    }

    public int getStrongestIndirectPower() {
        return this.world().func_94572_D(this.xi(), this.yi(), this.zi());
    }

    public int getWeakRedstonePower(int side) {
        return this.getStrongRedstonePower(side);
    }

    public int getStrongRedstonePower(int side) {
        return 0;
    }

    public void setBlockBoundsBasedOnState() {
    }

    public boolean isSolid(int side) {
        return this.material.func_76220_a();
    }

    public int getRenderBlockPass() {
        return 0;
    }

    public int tickRate() {
        return 20;
    }

    public boolean canSilkHarvest(EntityPlayer player, int metadata) {
        return false;
    }

    public boolean canPlaceBlockAt() {
        return this.world() != null ? this.world().func_147439_a(this.xi(), this.yi(), this.zi()).isReplaceable((IBlockAccess)this.world(), this.xi(), this.yi(), this.zi()) : false;
    }

    public boolean removeByPlayer(EntityPlayer player, boolean willHarvest) {
        return this.world().func_147468_f(this.xi(), this.yi(), this.zi());
    }

    public boolean canPlaceBlockOnSide(ForgeDirection side) {
        return this.canPlaceBlockAt();
    }

    public float getExplosionResistance(Entity entity, Pos explosionPosition) {
        return this.getExplosionResistance(entity);
    }

    public float getExplosionResistance(Entity entity) {
        return this.resistance / 5.0f;
    }

    public boolean isClient() {
        return this.world().field_72995_K;
    }

    public boolean isServer() {
        return !this.world().field_72995_K;
    }

    public UUID getOwnerID() {
        return this.owner;
    }

    public String getOwnerName() {
        GameProfile profile = this.getOwnerProfile();
        if (profile != null) {
            return profile.getName();
        }
        return null;
    }

    public GameProfile getOwnerProfile() {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return null;
        }
        return MinecraftServer.func_71276_C().func_152358_ax().func_152652_a(this.owner);
    }

    public void setOwnerID(UUID id) {
        this.owner = id;
    }

    public void setOwner(EntityPlayer player) {
        if (player != null) {
            this.setOwnerID(player.func_146103_bH().getId());
            this.username = player.func_70005_c_();
        } else {
            this.setOwnerID(null);
            this.username = null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        if (this.useSidedTextures) {
            if (side == 0) {
                return this.getTopIcon(meta);
            }
            if (side == 1) {
                return this.getBottomIcon(meta);
            }
            return this.getSideIcon(meta, side);
        }
        return this.getIcon(side);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side) {
        return this.getIcon();
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon() {
        return this.getIcon(this.getTextureName());
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(String name) {
        if (this.icons != null && this.icons.containsKey(name)) {
            return this.icons.get(name);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    protected String getTextureName() {
        if (this.textureName == null) {
            return "MISSING_ICON_TILE_" + Block.func_149682_b((Block)this.block) + "_" + this.name;
        }
        return this.block.staticTile.domain + this.textureName;
    }

    @SideOnly(value=Side.CLIENT)
    protected IIcon getTopIcon(int meta) {
        IIcon icon = this.icons.get(this.getTextureName() + "_top");
        if (icon == null) {
            icon = this.icons.get(this.getTextureName());
        }
        return icon;
    }

    @SideOnly(value=Side.CLIENT)
    protected IIcon getBottomIcon(int meta) {
        IIcon icon = this.icons.get(this.getTextureName() + "_bottom");
        if (icon == null) {
            icon = this.icons.get(this.getTextureName());
        }
        return icon;
    }

    @SideOnly(value=Side.CLIENT)
    protected IIcon getSideIcon(int meta) {
        return this.getSideIcon(meta, 0);
    }

    @SideOnly(value=Side.CLIENT)
    protected IIcon getSideIcon(int meta, int side) {
        if (this.icons != null) {
            IIcon icon = this.icons.get(this.getTextureName() + "_side");
            if (icon == null) {
                icon = this.icons.get(this.getTextureName());
            }
            return icon;
        }
        return null;
    }

    public void setTextureName(String value) {
        this.textureName = value;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        this.icons = new HashMap();
        if (this.useSidedTextures) {
            this.registerSideTextureSet(iconRegister);
        } else {
            this.icons.put(this.getTextureName(), iconRegister.func_94245_a(this.getTextureName()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerSideTextureSet(IIconRegister iconRegister) {
        if (this.icons == null) {
            this.icons = new HashMap();
        }
        this.icons.put(this.getTextureName(), iconRegister.func_94245_a(this.getTextureName() + "_top"));
        this.icons.put(this.getTextureName(), iconRegister.func_94245_a(this.getTextureName() + "_side"));
        this.icons.put(this.getTextureName(), iconRegister.func_94245_a(this.getTextureName() + "_bottom"));
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorMultiplier() {
        return 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBlockColor() {
        return 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderColor(int p_149741_1_) {
        return 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean renderStatic(RenderBlocks renderer, Pos pos, int pass) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasSpecialRenderer() {
        return this.getSpecialRenderer() != null;
    }

    @SideOnly(value=Side.CLIENT)
    public TileEntitySpecialRenderer getSpecialRenderer() {
        return TileEntityRendererDispatcher.field_147556_a.func_147546_a(this.getClass());
    }

    @SideOnly(value=Side.CLIENT)
    public void renderInventory(ItemStack itemStack) {
        TileEntitySpecialRenderer tesr = this.getSpecialRenderer();
        if (!(tesr instanceof RenderTileDummy)) {
            if (tesr instanceof ISimpleItemRenderer) {
                ((ISimpleItemRenderer)tesr).renderInventoryItem(IItemRenderer.ItemRenderType.INVENTORY, itemStack, new Object[0]);
            }
            if (!this.dynamicRendererCrashed) {
                try {
                    this.renderDynamic(new Pos(-0.5, -0.5, -0.5), 0.0f, 0);
                }
                catch (Exception e) {
                    this.dynamicRendererCrashed = true;
                    this.renderNormalBlock = true;
                    System.out.println("A tile has failed to render dynamically as an item. Suppressing renderer to prevent future crashes.");
                    e.printStackTrace();
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(Pos pos, float frame, int pass) {
        TileEntitySpecialRenderer tesr = this.getSpecialRenderer();
        if (tesr != null && !(tesr instanceof RenderTileDummy)) {
            GL11.glEnable((int)32826);
            GL11.glPushAttrib((int)262144);
            GL11.glPushMatrix();
            GL11.glTranslated((double)-0.5, (double)-0.5, (double)-0.5);
            tesr.func_147500_a((TileEntity)this, 0.0, 0.0, 0.0, 0.0f);
            GL11.glPopMatrix();
            GL11.glPopAttrib();
        }
    }

    public void randomDisplayTick() {
    }

    public double distance(Entity entity) {
        return this.distance(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
    }

    public double distance(IPos3D pos) {
        if (pos instanceof Pos3D) {
            return ((Pos3D)pos).distance(this.x() + 0.5, this.y() + 0.5, this.z() + 0.5);
        }
        return this.distance(pos.x(), pos.y(), pos.z());
    }

    public double distance(double x, double y, double z) {
        double xx = this.x() + 0.5 - x;
        double yy = this.y() + 0.5 - y;
        double zz = this.z() + 0.5 - z;
        return Math.sqrt(xx * xx + yy * yy + zz * zz);
    }

    public void setMeta(int meta) {
        this.world().func_72921_c(this.xi(), this.yi(), this.zi(), meta, 3);
    }

    public NBTTagCompound getSaveData() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return tag;
    }

    public final Packet func_145844_m() {
        return Engine.instance.packetHandler.toMCPacket(this.getDescPacket());
    }

    public AbstractPacket getDescPacket() {
        return null;
    }

    public void sendDescPacket() {
        this.sendPacket(this.getDescPacket());
    }

    public void sendPacket(AbstractPacket packet) {
        this.sendPacket(packet, 64.0);
    }

    public void sendPacket(AbstractPacket packet, double distance) {
        if (this.isServer()) {
            Engine.instance.packetHandler.sendToAllAround(packet, this.world(), this.xi(), this.yi(), this.zi(), distance);
        }
    }

    public void sendPacketToServer(AbstractPacket packet) {
        if (this.isClient()) {
            Engine.instance.packetHandler.sendToServer(packet);
        }
    }

    public void sendPacketToGuiUsers(AbstractPacket packet) {
        for (EntityPlayer player : this.getPlayersUsing()) {
            if (!(player instanceof EntityPlayerMP)) continue;
            Engine.instance.packetHandler.sendToPlayer(packet, (EntityPlayerMP)player);
        }
    }

    public byte determineOrientation(EntityLivingBase entityLiving) {
        if (entityLiving != null) {
            int rotation;
            if ((float)MathUtility.func_154353_e(entityLiving.field_70165_t - this.x()) < 2.0f && (float)MathUtility.func_154353_e(entityLiving.field_70161_v - this.z()) < 2.0f) {
                double var5 = entityLiving.field_70163_u + 1.82 - (double)entityLiving.field_70129_M;
                if (var5 - this.y() > 2.0) {
                    return 1;
                }
                if (this.y() - var5 > 0.0) {
                    return 0;
                }
            }
            if ((rotation = MathHelper.func_76128_c((double)((double)(entityLiving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3) == 0) {
                return 2;
            }
            if (rotation == 1) {
                return 5;
            }
            if (rotation == 2) {
                return 3;
            }
            if (rotation == 3) {
                return 4;
            }
            return 0;
        }
        return 0;
    }

    public ForgeDirection determineForgeDirection(EntityLivingBase entityLiving) {
        return ForgeDirection.getOrientation((int)this.determineOrientation(entityLiving));
    }
}

