/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.prefab.tile;

import com.builtbroken.mc.lib.transform.region.Cube;
import com.builtbroken.mc.lib.transform.vector.Point;
import com.builtbroken.mc.lib.transform.vector.Pos;
import com.builtbroken.mc.prefab.inventory.InventoryUtility;
import com.builtbroken.mc.prefab.tile.Tile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockTile
extends BlockContainer {
    public Tile staticTile = null;
    private boolean hasTile = false;

    public BlockTile(Tile tile, String prefix, CreativeTabs tab) {
        super(tile.material);
        this.staticTile = tile;
        this.staticTile.setBlock(this);
        this.field_149787_q = this.func_149662_c();
        this.func_149676_a((float)this.staticTile.bounds.min().x(), (float)this.staticTile.bounds.min().y(), (float)this.staticTile.bounds.min().z(), (float)this.staticTile.bounds.max().x(), (float)this.staticTile.bounds.max().y(), (float)this.staticTile.bounds.max().z());
        this.func_149663_c(prefix + this.staticTile.name);
        this.func_149658_d(prefix + this.staticTile.textureName);
        this.func_149647_a(this.staticTile.creativeTab == null ? tab : this.staticTile.creativeTab);
        this.func_149713_g(this.func_149662_c() ? 255 : 0);
        this.func_149711_c(this.staticTile.hardness);
        this.func_149752_b(this.staticTile.resistance);
        this.func_149672_a(this.staticTile.stepSound);
    }

    public TileEntity createTileEntity(World world, int meta) {
        return this.staticTile.newTile(world, meta);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return this.staticTile.newTile(world, meta);
    }

    public void func_149639_l(World world, int x, int y, int z) {
        Tile tile = this.inject((IBlockAccess)world, x, y, z);
        tile.onFillRain();
        this.eject();
    }

    public float func_149638_a(Entity entity) {
        return this.staticTile.getExplosionResistance(entity);
    }

    public float getExplosionResistance(Entity entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        Tile tile = this.inject((IBlockAccess)world, x, y, z);
        float resistance = tile.getExplosionResistance(entity, new Pos(explosionX, explosionY, explosionZ));
        this.eject();
        return resistance;
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        Tile tile = this.inject((IBlockAccess)world, x, y, z);
        tile.onPlayerLeftClick(player);
        this.eject();
    }

    public void func_149726_b(World world, int x, int y, int z) {
        Tile tile = this.inject((IBlockAccess)world, x, y, z);
        tile.onAdded();
        this.eject();
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        Tile tile = this.inject((IBlockAccess)world, x, y, z);
        tile.onPlaced(entityLiving, itemStack);
        this.eject();
    }

    public void func_149714_e(World world, int x, int y, int z, int metadata) {
        Tile tile = this.inject((IBlockAccess)world, x, y, z);
        tile.onPostPlaced(metadata);
        this.eject();
    }

    public void func_149723_a(World world, int x, int y, int z, Explosion ex) {
        Tile tile = this.inject((IBlockAccess)world, x, y, z);
        tile.onDestroyedByExplosion(ex);
        this.eject();
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int par6) {
        Tile tile = this.inject((IBlockAccess)world, x, y, z);
        tile.onRemove(block, par6);
        this.eject();
        super.func_149749_a(world, x, y, z, block, par6);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        Tile tile = this.inject((IBlockAccess)world, x, y, z);
        boolean b = tile.removeByPlayer(player, willHarvest);
        this.eject();
        return b;
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        return this.staticTile.quantityDropped(meta, fortune);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        Tile tile = this.inject((IBlockAccess)world, x, y, z);
        tile.onNeighborChanged(block);
        this.eject();
    }

    public boolean func_149707_d(World world, int x, int y, int z, int side) {
        Tile tile = this.inject((IBlockAccess)world, x, y, z);
        boolean b = tile.canPlaceBlockOnSide(ForgeDirection.getOrientation((int)side));
        this.eject();
        return b;
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        Tile tile = this.inject((IBlockAccess)world, x, y, z);
        boolean b = tile.canPlaceBlockAt();
        this.eject();
        return b;
    }

    public void onNeighborChange(IBlockAccess world, int x, int y, int z, int tileX, int tileY, int tileZ) {
        if (!(world instanceof World) || !((World)world).field_72995_K) {
            Tile tile = this.inject(world, x, y, z);
            tile.onNeighborChanged(new Pos(tileX, tileY, tileZ));
            this.eject();
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        Tile tile = this.inject((IBlockAccess)world, x, y, z);
        boolean value = tile.onPlayerActivated(player, side, new Pos(hitX, hitY, hitZ));
        this.eject();
        return value;
    }

    public void func_149674_a(World world, int x, int y, int z, Random par5Random) {
        Tile tile = this.inject((IBlockAccess)world, x, y, z);
        tile.blockUpdate();
        this.eject();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random par5Random) {
        Tile tile = this.inject((IBlockAccess)world, x, y, z);
        tile.randomDisplayTick();
        this.eject();
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        Tile tile = this.inject((IBlockAccess)world, x, y, z);
        tile.onCollide(entity);
        this.eject();
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB aabb, List list, Entity entity) {
        Tile tile = this.inject((IBlockAccess)world, x, y, z);
        Iterable<Cube> bounds = tile.getCollisionBoxes(new Cube(aabb).subtract(new Pos(x, y, z)), entity);
        this.eject();
        if (bounds != null) {
            for (Cube cuboid : bounds) {
                AxisAlignedBB bb = cuboid.toAABB().func_72317_d((double)x, (double)y, (double)z);
                if (!aabb.func_72326_a(bb)) continue;
                list.add(bb);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        Tile tile = this.inject((IBlockAccess)world, x, y, z);
        AxisAlignedBB value = tile.getSelectBounds().clone().add(tile.x(), tile.y(), tile.z()).toAABB();
        this.eject();
        return value;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        Tile tile = this.inject((IBlockAccess)world, x, y, z);
        AxisAlignedBB value = tile.getCollisionBounds().clone().add(tile.x(), tile.y(), tile.z()).toAABB();
        this.eject();
        return value;
    }

    public boolean func_149646_a(IBlockAccess access, int x, int y, int z, int side) {
        Tile tile = this.inject(access, x, y, z);
        boolean value = this.staticTile.shouldSideBeRendered(side);
        this.eject();
        return value;
    }

    public boolean func_149747_d(IBlockAccess access, int x, int y, int z, int side) {
        Tile tile = this.inject(access, x, y, z);
        boolean value = tile.isSolid(side);
        this.eject();
        return value;
    }

    public int getLightValue(IBlockAccess access, int x, int y, int z) {
        int value = 0;
        if (access != null) {
            Tile tile = this.inject(access, x, y, z);
            value = tile.getLightValue();
            this.eject();
        }
        return value;
    }

    public boolean func_149740_M() {
        return false;
    }

    public boolean func_149662_c() {
        return this.staticTile == null || this.staticTile.isOpaque;
    }

    public boolean func_149686_d() {
        return this.staticTile.renderNormalBlock;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149645_b() {
        return this.staticTile.renderNormalBlock ? 0 : this.staticTile.renderType;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess access, int x, int y, int z, int side) {
        Tile tile = this.inject(access, x, y, z);
        IIcon value = tile.getIcon(side, access.func_72805_g(x, y, z));
        this.eject();
        return value;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.staticTile.getIcon(side, meta);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.staticTile.registerIcons(iconRegister);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess access, int x, int y, int z) {
        Tile tile = this.inject(access, x, y, z);
        int value = tile.getColorMultiplier();
        this.eject();
        return value;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149635_D() {
        return this.staticTile.getBlockColor();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149741_i(int i) {
        return this.staticTile.getRenderColor(i);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        Tile tile = this.inject((IBlockAccess)world, x, y, z);
        ItemStack value = tile.getPickBlock(target);
        this.eject();
        return value;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        Tile tile = this.inject((IBlockAccess)world, x, y, z);
        ArrayList value = tile.getDrops(metadata, fortune);
        this.eject();
        return value != null ? value : new ArrayList();
    }

    public void func_149666_a(Item item, CreativeTabs creativeTabs, List list) {
        this.staticTile.getSubBlocks(item, creativeTabs, list);
    }

    public boolean func_149744_f() {
        return this.staticTile.canEmmitRedstone;
    }

    public int func_149709_b(IBlockAccess access, int x, int y, int z, int side) {
        Tile tile = this.inject(access, x, y, z);
        int value = tile.getWeakRedstonePower(side);
        this.eject();
        return value;
    }

    public int func_149748_c(IBlockAccess access, int x, int y, int z, int side) {
        Tile tile = this.inject(access, x, y, z);
        int value = tile.getStrongRedstonePower(side);
        this.eject();
        return value;
    }

    public void func_149719_a(IBlockAccess access, int x, int y, int z) {
        Tile tile = this.inject(access, x, y, z);
        tile.setBlockBoundsBasedOnState();
        this.eject();
    }

    protected void func_149642_a(World world, int x, int y, int z, ItemStack itemStack) {
        if (!world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops")) {
            InventoryUtility.dropItemStack(world, new Pos(x, y, z), itemStack);
        }
    }

    public int func_149701_w() {
        return this.staticTile.getRenderBlockPass();
    }

    public int func_149738_a(World world) {
        Tile tile = this.inject((IBlockAccess)world, 0, 0, 0);
        int t = this.staticTile.tickRate();
        this.eject();
        return t;
    }

    public static Point getClickedFace(Byte hitSide, float hitX, float hitY, float hitZ) {
        switch (hitSide) {
            case 0: {
                return new Point(1.0f - hitX, hitZ);
            }
            case 1: {
                return new Point(hitX, hitZ);
            }
            case 2: {
                return new Point(1.0f - hitX, 1.0f - hitY);
            }
            case 3: {
                return new Point(hitX, 1.0f - hitY);
            }
            case 4: {
                return new Point(hitZ, 1.0f - hitY);
            }
            case 5: {
                return new Point(1.0f - hitZ, 1.0f - hitY);
            }
        }
        return new Point(0.5, 0.5);
    }

    public Tile inject(IBlockAccess access, int x, int y, int z) {
        if (access instanceof World) {
            this.staticTile.func_145834_a((World)access);
        }
        this.staticTile.setAccess(access);
        this.staticTile.field_145851_c = x;
        this.staticTile.field_145848_d = y;
        this.staticTile.field_145849_e = z;
        TileEntity tileEntity = access.func_147438_o(x, y, z);
        if (tileEntity instanceof Tile) {
            ((Tile)tileEntity).setBlock(this);
        }
        return tileEntity instanceof Tile ? (Tile)tileEntity : this.staticTile;
    }

    public void eject() {
        this.staticTile.func_145834_a(null);
        this.staticTile.field_145851_c = 0;
        this.staticTile.field_145848_d = 0;
        this.staticTile.field_145849_e = 0;
    }
}

