/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.prefab.recipe.extend;

import com.builtbroken.mc.api.recipe.IMachineRecipe;
import com.builtbroken.mc.api.recipe.MachineRecipeType;
import com.builtbroken.mc.prefab.items.ItemStackWrapper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public abstract class MachineRecipe<O, I>
implements IMachineRecipe<O, I> {
    protected final String type;
    protected List<I> inputs = new ArrayList<I>();

    public MachineRecipe(String type) {
        this.type = type;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public MachineRecipe addInputOption(I input) {
        if (!this.inputs.contains(input)) {
            this.inputs.add(input);
        }
        return this;
    }

    @Override
    public List<I> getValidInputs() {
        return this.inputs;
    }

    public String toString() {
        String clazzName = this.getClass().getSimpleName();
        clazzName = clazzName.replaceFirst("MR", "MachineRecipe");
        return clazzName + "[" + this.getOutput() + "]";
    }

    public boolean equals(Object object) {
        IMachineRecipe other;
        if (object instanceof IMachineRecipe && (other = (IMachineRecipe)object).getType() == this.getType() && this.isOutputEqual(other.getOutput())) {
            return other.getValidInputs().equals(this.getValidInputs());
        }
        return false;
    }

    public boolean isOutputEqual(Object out) {
        return out == this.getOutput();
    }

    public boolean isItem(Object object) {
        return object instanceof Block || object instanceof Item || object instanceof ItemStack || object instanceof ItemStackWrapper;
    }

    public ItemStackWrapper wrapToItemStack(Object object) {
        if (object instanceof ItemStackWrapper) {
            return (ItemStackWrapper)object;
        }
        ItemStack stack = MachineRecipeType.toItemStack(object);
        if (stack != null) {
            return new ItemStackWrapper(stack);
        }
        return null;
    }

    public boolean isFluid(Object object) {
        return object instanceof FluidStack || object instanceof Fluid;
    }

    public FluidStack toFluidStack(Object object) {
        if (object instanceof FluidStack) {
            return (FluidStack)object;
        }
        if (object instanceof Fluid) {
            return new FluidStack((Fluid)object, 1000);
        }
        return null;
    }
}

