/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.prefab.json.block.processor;

import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.lib.mod.loadable.ILoadable;
import com.builtbroken.mc.prefab.json.block.BlockJson;
import com.builtbroken.mc.prefab.json.block.meta.MetaData;
import com.builtbroken.mc.prefab.json.block.processor.JsonBlockSubProcessor;
import com.builtbroken.mc.prefab.json.recipe.smelting.SmeltingRecipe;
import com.builtbroken.mc.prefab.json.recipe.smelting.SmeltingRecipeJson;
import com.builtbroken.mc.prefab.json.recipe.smelting.SmeltingRecipeText;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;

public class JsonBlockSmeltingProcessor
extends JsonBlockSubProcessor
implements ILoadable {
    private List<SmeltingRecipe> recipes = new ArrayList<SmeltingRecipe>();

    @Override
    public void process(BlockJson block, JsonElement element) {
        try {
            SmeltingRecipe recipe = this.process(block, element.getAsJsonObject());
            this.recipes.add(recipe);
        }
        catch (Exception e) {
            Engine.logger().error("JsonBlockSmeltingProcessor: Failed to process recipe data for " + block, (Throwable)e);
        }
    }

    @Override
    public void processMeta(MetaData meta, BlockJson block, JsonElement element) {
        try {
            SmeltingRecipe recipe = this.process(block, element.getAsJsonObject());
            recipe.inputMeta = meta.index;
            this.recipes.add(recipe);
        }
        catch (Exception e) {
            Engine.logger().error("JsonBlockSmeltingProcessor: Failed to process recipe data for " + block + " @ " + meta, (Throwable)e);
        }
    }

    public SmeltingRecipe process(BlockJson block, JsonObject json) {
        if (json.has("output")) {
            SmeltingRecipe recipe;
            JsonElement output = json.get("output");
            if (output.isJsonObject()) {
                JsonObject json2 = output.getAsJsonObject();
                if (!json2.has("item")) {
                    throw new IllegalArgumentException(this + " json data is missing a item entry used to figure out what to load.");
                }
                if (!json2.has("type")) {
                    throw new IllegalArgumentException(this + " json data is missing a type entry used to figure out what to load.");
                }
                recipe = new SmeltingRecipeJson(block, json2);
            } else {
                recipe = new SmeltingRecipeText(block, output.getAsString());
            }
            if (json.has("xp")) {
                recipe.xp = (float)json.get("xp").getAsDouble();
            }
        }
        throw new IllegalArgumentException(this + " json data is missing a item entry used to figure out what to load.");
    }

    @Override
    public void preInit() {
    }

    @Override
    public void init() {
    }

    @Override
    public void postInit() {
        this.recipes.forEach(SmeltingRecipe::register);
        this.recipes.clear();
    }
}

