/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.prefab.json.block.processor;

import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.lib.mod.loadable.ILoadable;
import com.builtbroken.mc.prefab.json.block.BlockJson;
import com.builtbroken.mc.prefab.json.block.meta.BlockJsonMeta;
import com.builtbroken.mc.prefab.json.block.meta.MetaData;
import com.builtbroken.mc.prefab.json.block.processor.JsonBlockSubProcessor;
import com.builtbroken.mc.prefab.json.processors.JsonProcessor;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;

public class JsonBlockProcessor
extends JsonProcessor<BlockJson> {
    public static final HashMap<String, JsonBlockSubProcessor> subProcessors = new HashMap();

    @Override
    public boolean canProcess(JsonElement element) {
        return element.isJsonObject() && element.getAsJsonObject().has("blockData");
    }

    @Override
    public BlockJson process(JsonElement element) {
        JsonObject object = element.getAsJsonObject();
        JsonObject blockData = object.get("blockData").getAsJsonObject();
        if (blockData.has("name") && blockData.has("material")) {
            BlockJson block;
            if (object.has("subtypes")) {
                block = new BlockJsonMeta(blockData.get("name").getAsString(), blockData.get("material").getAsString());
                this.readMeta((BlockJsonMeta)block, object.get("subtypes").getAsJsonArray());
            } else {
                block = new BlockJson(blockData.get("name").getAsString(), blockData.get("material").getAsString());
            }
            return block;
        }
        throw new IllegalArgumentException("JsonBlockProcessor: BlockData requires a name and a material value");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void readMeta(BlockJsonMeta block, JsonArray array) {
        for (int i = 0; i < array.size() && i < 16; ++i) {
            MetaData meta = new MetaData();
            JsonObject json = array.get(i).getAsJsonObject();
            int m = this.readMetaEntry(block, meta, json);
            if (m == -1) throw new IllegalArgumentException("JsonBlockProcessor: Each meta entry requires the value 'meta':int");
            if (m < 0 || m >= 16) throw new IllegalArgumentException("JsonBlockProcessor: Meta values are restricted from 0 to 15");
            if (block.meta[m] != null) {
                throw new IllegalArgumentException("JsonBlockProcessor: Meta value[" + m + "] was overridden inside the same file for block " + block.name);
            }
            meta.index = m;
            block.meta[m] = meta;
        }
    }

    public int readMetaEntry(BlockJson block, MetaData data, JsonObject json) {
        int meta = -1;
        for (Map.Entry entry : json.entrySet()) {
            if (((String)entry.getKey()).equalsIgnoreCase("localization")) {
                data.localization = ((JsonElement)entry.getValue()).getAsString();
                continue;
            }
            if (((String)entry.getKey()).equalsIgnoreCase("oreName")) {
                data.addOreName(((JsonElement)entry.getValue()).getAsString());
                continue;
            }
            if (((String)entry.getKey()).equalsIgnoreCase("meta")) {
                meta = ((JsonElement)entry.getValue()).getAsInt();
                continue;
            }
            this.processUnknownEntry((String)entry.getKey(), (JsonElement)entry.getValue(), block, data);
        }
        return meta;
    }

    public void processUnknownEntry(String name, JsonElement element, BlockJson block, MetaData data) {
        if (subProcessors.containsKey(name)) {
            if (subProcessors.get(name).canProcess(element)) {
                if (data != null) {
                    subProcessors.get(name).processMeta(data, block, element);
                } else {
                    subProcessors.get(name).process(block, element);
                }
            } else {
                Engine.logger().error("JsonBlockProcessor: Error processing data for block " + block.name + ", processor rejected entry[" + name + "]=" + element);
            }
        } else {
            Engine.logger().error("JsonBlockProcessor: Error processing data for block " + block.name + ", no processor found for entry[" + name + "]=" + element);
        }
    }

    public void addSubProcessor(String entryName, JsonBlockSubProcessor processor) {
        if (subProcessors.containsKey(entryName) && subProcessors.get(entryName) != null) {
            Engine.logger().error("JsonBlockProcessor: Error sub process " + entryName + " is being overridden by " + processor);
        }
        subProcessors.put(entryName, processor);
        if (subProcessors instanceof ILoadable) {
            Engine.instance.loader.applyModule((ILoadable)((Object)subProcessors));
        }
    }
}

