/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.prefab.json;

import com.builtbroken.mc.core.registry.implement.IPostInit;
import com.builtbroken.mc.core.registry.implement.IRecipeContainer;
import com.builtbroken.mc.core.registry.implement.IRegistryInit;
import com.builtbroken.mc.lib.mod.loadable.AbstractLoadable;
import com.builtbroken.mc.prefab.json.block.processor.JsonBlockProcessor;
import com.builtbroken.mc.prefab.json.block.processor.JsonBlockSmeltingProcessor;
import com.builtbroken.mc.prefab.json.block.processor.JsonBlockWorldGenProcessor;
import com.builtbroken.mc.prefab.json.imp.IJsonGenObject;
import com.builtbroken.mc.prefab.json.processors.JsonProcessor;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import li.cil.oc.common.block.Item;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;

public class JsonContentLoader
extends AbstractLoadable {
    List<String> resources = new ArrayList<String>();
    List<JsonProcessor> processors = new ArrayList<JsonProcessor>();
    List<IJsonGenObject> generatedObjects = new ArrayList<IJsonGenObject>();
    public JsonBlockProcessor blockProcessor;

    @Override
    public void preInit() {
        this.blockProcessor = new JsonBlockProcessor();
        this.processors.add(this.blockProcessor);
        this.blockProcessor.addSubProcessor("smeltingRecipe", new JsonBlockSmeltingProcessor());
        this.blockProcessor.addSubProcessor("worldGenerator", new JsonBlockWorldGenProcessor());
    }

    @Override
    public void init() {
        block2: for (String resource : this.resources) {
            try {
                JsonElement element = JsonContentLoader.loadJsonFileFromResources(resource);
                for (JsonProcessor processor : this.processors) {
                    if (!processor.canProcess(element)) continue;
                    Object data = processor.process(element);
                    data.register();
                    if (!(data instanceof IRegistryInit)) continue block2;
                    ((IRegistryInit)data).onRegistered();
                    continue block2;
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load resource " + resource, e);
            }
        }
    }

    public static JsonElement loadJsonFileFromResources(String resource) throws IOException {
        URL url = JsonContentLoader.class.getClassLoader().getResource(resource);
        InputStream stream = url.openStream();
        JsonReader jsonReader = new JsonReader((Reader)new BufferedReader(new InputStreamReader(stream)));
        JsonElement element = Streams.parse((JsonReader)jsonReader);
        stream.close();
        return element;
    }

    @Override
    public void postInit() {
        for (IJsonGenObject obj : this.generatedObjects) {
            if (obj instanceof IPostInit) {
                ((IPostInit)((Object)obj)).onPostInit();
            }
            if (!(obj instanceof IRecipeContainer)) continue;
            ArrayList<IRecipe> recipes = new ArrayList<IRecipe>();
            ((IRecipeContainer)((Object)obj)).genRecipes(recipes);
            for (IRecipe recipe : recipes) {
                if (recipe == null || recipe.func_77571_b() == null) continue;
                GameRegistry.addRecipe((IRecipe)recipe);
            }
        }
    }

    public static ItemStack fromString(String string) {
        if (string.startsWith("item[") || string.startsWith("block[")) {
            Object obj;
            String out = string.substring(string.indexOf("[") + 1, string.length() - 1);
            int meta = -1;
            if (out.contains("@")) {
                String[] split = out.split("@");
                out = split[0];
                try {
                    meta = Integer.parseInt(split[1]);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException();
                }
            }
            if (!out.contains(":")) {
                out = "minecraft:" + out;
            }
            if (string.startsWith("item[")) {
                obj = Item.field_150901_e.func_82594_a(out);
                if (obj instanceof Item) {
                    if (meta > -1) {
                        return new ItemStack((net.minecraft.item.Item)((Item)obj));
                    }
                    return new ItemStack((net.minecraft.item.Item)((Item)obj), 1, meta);
                }
            } else {
                obj = Block.field_149771_c.func_82594_a(out);
                if (obj instanceof Block) {
                    if (meta > -1) {
                        return new ItemStack((Block)obj);
                    }
                    return new ItemStack((Block)obj, 1, meta);
                }
            }
        } else if (OreDictionary.doesOreNameExist((String)string)) {
            ArrayList ores = OreDictionary.getOres((String)string);
            for (ItemStack stack : ores) {
                if (stack == null) continue;
                return stack;
            }
        }
        return null;
    }

    public static ItemStack fromJson(JsonObject json) {
        ItemStack output;
        block9: {
            Object obj;
            int meta;
            String item;
            String type;
            block8: {
                output = null;
                type = json.get("type").getAsString();
                item = json.get("item").getAsString();
                meta = -1;
                if (json.has("meta")) {
                    meta = json.get("meta").getAsInt();
                }
                if (!type.equalsIgnoreCase("block")) break block8;
                obj = Item.field_150901_e.func_82594_a(item);
                if (!(obj instanceof Block)) break block9;
                output = meta > -1 ? new ItemStack((Block)obj) : new ItemStack((Block)obj, 1, meta);
                break block9;
            }
            if (type.equalsIgnoreCase("item")) {
                obj = Item.field_150901_e.func_82594_a(item);
                if (obj instanceof Item) {
                    if (meta > -1) {
                        return new ItemStack((net.minecraft.item.Item)((Item)obj));
                    }
                    return new ItemStack((net.minecraft.item.Item)((Item)obj), 1, meta);
                }
            } else if (type.equalsIgnoreCase("dict")) {
                ArrayList ores = OreDictionary.getOres((String)item);
                for (ItemStack stack : ores) {
                    if (stack == null) continue;
                    output = stack;
                    break;
                }
            }
        }
        if (output != null && json.has("nbt")) {
            NBTTagCompound tag = new NBTTagCompound();
            JsonContentLoader.processNBTTagCompound(json.getAsJsonObject("nbt"), tag);
        }
        return output;
    }

    public static void processNBTTagCompound(JsonObject json, NBTTagCompound tag) {
        for (Map.Entry entry : json.entrySet()) {
            if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                JsonPrimitive primitive = ((JsonElement)entry.getValue()).getAsJsonPrimitive();
                if (primitive.isBoolean()) {
                    tag.func_74757_a((String)entry.getKey(), primitive.getAsBoolean());
                    continue;
                }
                if (primitive.isNumber()) {
                    tag.func_74768_a((String)entry.getKey(), primitive.getAsInt());
                    continue;
                }
                if (!primitive.isString()) continue;
                tag.func_74778_a((String)entry.getKey(), primitive.getAsString());
                continue;
            }
            if (!((JsonElement)entry.getValue()).isJsonObject()) continue;
            JsonObject object = ((JsonElement)entry.getValue()).getAsJsonObject();
            if (object.has("type")) {
                String type = object.get("type").getAsString();
                if (type.equalsIgnoreCase("tagCompound")) {
                    NBTTagCompound nbt = new NBTTagCompound();
                    JsonContentLoader.processNBTTagCompound(object, nbt);
                    tag.func_74782_a((String)entry.getKey(), (NBTBase)nbt);
                    continue;
                }
                if (type.equalsIgnoreCase("int")) {
                    tag.func_74768_a((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsInt());
                    continue;
                }
                if (type.equalsIgnoreCase("double")) {
                    tag.func_74780_a((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsDouble());
                    continue;
                }
                if (type.equalsIgnoreCase("float")) {
                    tag.func_74776_a((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsFloat());
                    continue;
                }
                if (type.equalsIgnoreCase("byte")) {
                    tag.func_74774_a((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsByte());
                    continue;
                }
                if (type.equalsIgnoreCase("short")) {
                    tag.func_74777_a((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsShort());
                    continue;
                }
                if (!type.equalsIgnoreCase("long")) continue;
                tag.func_74772_a((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsLong());
                continue;
            }
            NBTTagCompound nbt = new NBTTagCompound();
            JsonContentLoader.processNBTTagCompound(object, nbt);
            tag.func_74782_a((String)entry.getKey(), (NBTBase)nbt);
        }
    }
}

