/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.prefab.inventory;

import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.jlib.lang.StringHelpers;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.lib.helper.DummyPlayer;
import com.builtbroken.mc.lib.helper.NBTUtility;
import com.builtbroken.mc.lib.transform.vector.Location;
import com.builtbroken.mc.lib.transform.vector.Pos;
import com.builtbroken.mc.prefab.items.ItemStackWrapper;
import cpw.mods.fml.common.registry.FMLControlledNamespacedRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;

public class InventoryUtility {
    private static final HashMap<String, List<Item>> MOD_TO_ITEMS = new HashMap();
    private static final HashMap<String, Object> NAME_TO_ITEM = new HashMap();
    private static final HashMap<Item, List<IRecipe>> ITEM_TO_RECIPES = new HashMap();
    private static final HashMap<ItemStackWrapper, List<IRecipe>> ITEMSTACK_TO_RECIPES = new HashMap();

    public static void mapItems() {
        MOD_TO_ITEMS.clear();
        NAME_TO_ITEM.clear();
        Engine.logger().info("Mapping item data...");
        long time = System.nanoTime();
        FMLControlledNamespacedRegistry registry = (FMLControlledNamespacedRegistry)Item.field_150901_e;
        Set set = registry.func_148742_b();
        Engine.logger().info("  " + set.size() + " entries detected");
        for (Object obj : set) {
            if (!(obj instanceof String)) continue;
            String name = (String)obj;
            String modID = name.substring(0, name.indexOf(":"));
            name = name.substring(name.indexOf(":") + 1, name.length()).toLowerCase();
            Object entry = registry.func_82594_a(obj);
            if (!(entry instanceof Item)) continue;
            Item item = (Item)entry;
            List<Item> items = MOD_TO_ITEMS.get(modID);
            if (items == null) {
                items = new ArrayList<Item>();
            }
            items.add(item);
            MOD_TO_ITEMS.put(modID, items);
            Object nameEntry = NAME_TO_ITEM.get(name);
            if (nameEntry != null) {
                if (nameEntry instanceof Item) {
                    ArrayList<Item> list = new ArrayList<Item>();
                    list.add(item);
                    list.add((Item)nameEntry);
                    NAME_TO_ITEM.put(name, list);
                    continue;
                }
                if (!(nameEntry instanceof List)) continue;
                ((List)nameEntry).add(item);
                NAME_TO_ITEM.put(name, nameEntry);
                continue;
            }
            NAME_TO_ITEM.put(name, item);
        }
        Engine.logger().info(" Done in.. " + StringHelpers.formatNanoTime((long)(System.nanoTime() - time)));
    }

    public static List<Item> getItemsForMod(String modid) {
        if (MOD_TO_ITEMS.isEmpty()) {
            InventoryUtility.mapItems();
        }
        return MOD_TO_ITEMS.get(modid);
    }

    public static void mapRecipes() {
        ITEMSTACK_TO_RECIPES.clear();
        ITEM_TO_RECIPES.clear();
        Engine.logger().info("Mapping basic recipe data...");
        Engine.logger().info("   " + CraftingManager.func_77594_a().func_77592_b().size() + " recipes detected.");
        long time = System.nanoTime();
        for (Object r : CraftingManager.func_77594_a().func_77592_b()) {
            if (!(r instanceof IRecipe) || ((IRecipe)r).func_77571_b() == null) continue;
            ItemStackWrapper wrapper = new ItemStackWrapper(((IRecipe)r).func_77571_b());
            List<IRecipe> list = ITEMSTACK_TO_RECIPES.get(wrapper);
            if (list == null) {
                list = new ArrayList<IRecipe>();
            }
            list.add((IRecipe)r);
            ITEMSTACK_TO_RECIPES.put(wrapper, list);
            ITEM_TO_RECIPES.put(((IRecipe)r).func_77571_b().func_77973_b(), list);
        }
        Engine.logger().info(" Done in.. " + StringHelpers.formatNanoTime((long)(System.nanoTime() - time)));
    }

    public static List<IRecipe> getRecipesWithOutput(Item item) {
        if (ITEM_TO_RECIPES.isEmpty()) {
            InventoryUtility.mapRecipes();
        }
        return ITEM_TO_RECIPES.get(item);
    }

    public static List<IRecipe> getRecipesWithOutput(ItemStack item) {
        if (ITEMSTACK_TO_RECIPES.isEmpty()) {
            InventoryUtility.mapRecipes();
        }
        return ITEMSTACK_TO_RECIPES.get(new ItemStackWrapper(item));
    }

    public static IInventory checkChestInv(IInventory inv) {
        if (inv instanceof TileEntityChest) {
            TileEntityChest main = (TileEntityChest)inv;
            TileEntityChest adj = null;
            if (main.field_145991_k != null) {
                adj = main.field_145991_k;
            } else if (main.field_145990_j != null) {
                adj = main.field_145990_j;
            } else if (main.field_145992_i != null) {
                adj = main.field_145992_i;
            } else if (main.field_145988_l != null) {
                adj = main.field_145988_l;
            }
            if (adj != null) {
                return new InventoryLargeChest("", (IInventory)main, (IInventory)adj);
            }
        }
        return inv;
    }

    public static ItemStack putStackInInventory(IInventory inventory, ItemStack toInsert, boolean ignoreIsValidForSlot) {
        if (inventory instanceof TileEntityChest) {
            inventory = InventoryUtility.checkChestInv(inventory);
        }
        for (int slot = 0; slot < inventory.func_70302_i_(); ++slot) {
            if (!ignoreIsValidForSlot && !inventory.func_94041_b(slot, toInsert)) continue;
            ItemStack slot_stack = inventory.func_70301_a(slot);
            if (slot_stack == null) {
                inventory.func_70299_a(slot, toInsert);
                return null;
            }
            if (!slot_stack.func_77969_a(toInsert) || slot_stack.field_77994_a >= slot_stack.func_77976_d()) continue;
            if (slot_stack.field_77994_a + toInsert.field_77994_a <= slot_stack.func_77976_d()) {
                ItemStack toSet = toInsert.func_77946_l();
                toSet.field_77994_a += slot_stack.field_77994_a;
                inventory.func_70299_a(slot, toSet);
                return null;
            }
            int rejects = slot_stack.field_77994_a + toInsert.field_77994_a - slot_stack.func_77976_d();
            ItemStack toSet = toInsert.func_77946_l();
            toSet.field_77994_a = slot_stack.func_77976_d();
            ItemStack remains = toInsert.func_77946_l();
            remains.field_77994_a = rejects;
            inventory.func_70299_a(slot, toSet);
            toInsert = remains;
        }
        return toInsert;
    }

    public static ItemStack insertStack(Location position, ItemStack toInsert, int side, boolean force) {
        return InventoryUtility.insertStack(position.getTileEntity(), toInsert, side, force);
    }

    public static ItemStack insertStack(TileEntity tile, ItemStack toInsert, int side, boolean force) {
        if (tile instanceof IInventory) {
            return InventoryUtility.putStackInInventory((IInventory)tile, toInsert, side, force);
        }
        return toInsert;
    }

    public static ItemStack putStackInInventory(IInventory inventory, ItemStack itemStack, int side, boolean force) {
        ItemStack toInsert;
        ItemStack itemStack2 = toInsert = itemStack != null ? itemStack.func_77946_l() : null;
        if (toInsert != null) {
            if (!(inventory instanceof ISidedInventory)) {
                return InventoryUtility.putStackInInventory(inventory, toInsert, force);
            }
            ISidedInventory sidedInventory = (ISidedInventory)inventory;
            int[] slots = sidedInventory.func_94128_d(side);
            if (slots != null && slots.length != 0) {
                for (int get = 0; get < slots.length; ++get) {
                    int slotID = slots[get];
                    if (!force && (!sidedInventory.func_94041_b(slotID, toInsert) || !sidedInventory.func_102007_a(slotID, toInsert, side))) continue;
                    ItemStack inSlot = inventory.func_70301_a(slotID);
                    if (inSlot == null) {
                        inventory.func_70299_a(slotID, toInsert);
                        return null;
                    }
                    if (!inSlot.func_77969_a(toInsert) || inSlot.field_77994_a >= inSlot.func_77976_d()) continue;
                    if (inSlot.field_77994_a + toInsert.field_77994_a <= inSlot.func_77976_d()) {
                        ItemStack toSet = toInsert.func_77946_l();
                        toSet.field_77994_a += inSlot.field_77994_a;
                        inventory.func_70299_a(slotID, toSet);
                        return null;
                    }
                    int rejects = inSlot.field_77994_a + toInsert.field_77994_a - inSlot.func_77976_d();
                    ItemStack toSet = toInsert.func_77946_l();
                    toSet.field_77994_a = inSlot.func_77976_d();
                    ItemStack remains = toInsert.func_77946_l();
                    remains.field_77994_a = rejects;
                    inventory.func_70299_a(slotID, toSet);
                    toInsert = remains;
                }
            }
        }
        return toInsert;
    }

    public static ItemStack putStackInInventory(IInventory inventory, ItemStack itemStack, int[] slots, boolean force) {
        ItemStack toInsert;
        ItemStack itemStack2 = toInsert = itemStack != null ? itemStack.func_77946_l() : null;
        if (toInsert != null) {
            ISidedInventory sidedInventory = (ISidedInventory)inventory;
            for (int get = 0; get < slots.length; ++get) {
                int slotID = slots[get];
                if (!force && !sidedInventory.func_94041_b(slotID, toInsert)) continue;
                ItemStack inSlot = inventory.func_70301_a(slotID);
                if (inSlot == null) {
                    inventory.func_70299_a(slotID, toInsert);
                    return null;
                }
                if (!InventoryUtility.stacksMatch(inSlot, toInsert) || inSlot.field_77994_a >= inSlot.func_77976_d()) continue;
                if (inSlot.field_77994_a + toInsert.field_77994_a <= inSlot.func_77976_d()) {
                    ItemStack toSet = toInsert.func_77946_l();
                    toSet.field_77994_a += inSlot.field_77994_a;
                    inventory.func_70299_a(slotID, toSet);
                    return null;
                }
                int rejects = inSlot.field_77994_a + toInsert.field_77994_a - inSlot.func_77976_d();
                ItemStack toSet = toInsert.func_77946_l();
                toSet.field_77994_a = inSlot.func_77976_d();
                ItemStack remains = toInsert.func_77946_l();
                remains.field_77994_a = rejects;
                inventory.func_70299_a(slotID, toSet);
                toInsert = remains;
            }
        }
        return toInsert;
    }

    public static ItemStack takeTopItemFromInventory(IInventory inventory, int side) {
        block3: {
            block2: {
                if (inventory instanceof ISidedInventory) break block2;
                for (int i = inventory.func_70302_i_() - 1; i >= 0; --i) {
                    if (inventory.func_70301_a(i) == null) continue;
                    ItemStack toSend = inventory.func_70301_a(i).func_77946_l();
                    toSend.field_77994_a = 1;
                    inventory.func_70298_a(i, 1);
                    return toSend;
                }
                break block3;
            }
            ISidedInventory sidedInventory = (ISidedInventory)inventory;
            int[] slots = sidedInventory.func_94128_d(side);
            if (slots == null) break block3;
            for (int get = slots.length - 1; get >= 0; --get) {
                int slotID = slots[get];
                if (sidedInventory.func_70301_a(slotID) == null) continue;
                ItemStack toSend = sidedInventory.func_70301_a(slotID);
                toSend.field_77994_a = 1;
                if (!sidedInventory.func_102008_b(slotID, toSend, side)) continue;
                sidedInventory.func_70298_a(slotID, 1);
                return toSend;
            }
        }
        return null;
    }

    public static ItemStack takeTopBlockFromInventory(IInventory inventory, int side) {
        block3: {
            block2: {
                if (inventory instanceof ISidedInventory) break block2;
                for (int i = inventory.func_70302_i_() - 1; i >= 0; --i) {
                    if (inventory.func_70301_a(i) == null || !(inventory.func_70301_a(i).func_77973_b() instanceof ItemBlock)) continue;
                    ItemStack toSend = inventory.func_70301_a(i).func_77946_l();
                    toSend.field_77994_a = 1;
                    inventory.func_70298_a(i, 1);
                    return toSend;
                }
                break block3;
            }
            ISidedInventory sidedInventory = (ISidedInventory)inventory;
            int[] slots = sidedInventory.func_94128_d(side);
            if (slots == null) break block3;
            for (int get = slots.length - 1; get >= 0; --get) {
                int slotID = slots[get];
                if (sidedInventory.func_70301_a(slotID) == null || !(inventory.func_70301_a(slotID).func_77973_b() instanceof ItemBlock)) continue;
                ItemStack toSend = sidedInventory.func_70301_a(slotID);
                toSend.field_77994_a = 1;
                if (!sidedInventory.func_102008_b(slotID, toSend, side)) continue;
                sidedInventory.func_70298_a(slotID, 1);
                return toSend;
            }
        }
        return null;
    }

    public static void dropBlockAsItem(World world, Pos position) {
        InventoryUtility.dropBlockAsItem(world, position.xi(), position.yi(), position.zi(), false);
    }

    public static void dropBlockAsItem(World world, int x, int y, int z, boolean destroy) {
        if (!world.field_72995_K) {
            Block block = world.func_147439_a(x, y, z);
            int meta = world.func_72805_g(x, y, z);
            if (block != null) {
                ArrayList items = block.getDrops(world, x, y, z, meta, 0);
                for (ItemStack itemStack : items) {
                    InventoryUtility.dropItemStack(world, new Pos(x, y, z), itemStack, 10);
                }
            }
            if (destroy) {
                world.func_147468_f(x, y, z);
            }
        }
    }

    public static void dropItemStack(Location position, ItemStack itemStack) {
        InventoryUtility.dropItemStack(position.world(), position, itemStack);
    }

    public static void dropItemStack(World world, IPos3D position, ItemStack itemStack) {
        InventoryUtility.dropItemStack(world, position, itemStack, 10);
    }

    public static void dropItemStack(World world, IPos3D position, ItemStack itemStack, int delay) {
        InventoryUtility.dropItemStack(world, position, itemStack, delay, 0.0f);
    }

    public static void dropItemStack(World world, IPos3D position, ItemStack itemStack, int delay, float randomAmount) {
        InventoryUtility.dropItemStack(world, position.x(), position.y(), position.z(), itemStack, delay, randomAmount);
    }

    public static void dropItemStack(World world, double x, double y, double z, ItemStack itemStack, int delay, float randomAmount) {
        if (!world.field_72995_K && itemStack != null) {
            double randomX = 0.0;
            double randomY = 0.0;
            double randomZ = 0.0;
            if (randomAmount > 0.0f) {
                randomX = (double)(world.field_73012_v.nextFloat() * randomAmount) + (double)(1.0f - randomAmount) * 0.5;
                randomY = (double)(world.field_73012_v.nextFloat() * randomAmount) + (double)(1.0f - randomAmount) * 0.5;
                randomZ = (double)(world.field_73012_v.nextFloat() * randomAmount) + (double)(1.0f - randomAmount) * 0.5;
            }
            EntityItem entityitem = new EntityItem(world, x + randomX, y + randomY, z + randomZ, itemStack);
            if (randomAmount <= 0.0f) {
                entityitem.field_70159_w = 0.0;
                entityitem.field_70181_x = 0.0;
                entityitem.field_70179_y = 0.0;
            }
            if (itemStack.func_77942_o()) {
                entityitem.func_92059_d().func_77982_d((NBTTagCompound)itemStack.func_77978_p().func_74737_b());
            }
            entityitem.field_145804_b = delay;
            world.func_72838_d((Entity)entityitem);
        }
    }

    public static boolean placeItemBlock(World world, int x, int y, int z, ItemStack itemStack, int side) {
        block4: {
            if (itemStack != null) {
                try {
                    Pos rightClickPos = new Pos(x, y, z);
                    if (world.func_147437_c(x, y, z)) {
                        rightClickPos.add(ForgeDirection.getOrientation((int)side));
                    }
                    return DummyPlayer.useItemAt(itemStack, world, x, y - 1, z, side ^= 1);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (world.func_147439_a(x, y, z) != ((ItemBlock)itemStack.func_77973_b()).field_150939_a) break block4;
                    return true;
                }
            }
        }
        return false;
    }

    public static ItemStack decrStackSize(ItemStack stack, int amount) {
        if (stack != null) {
            ItemStack itemStack = stack.func_77946_l();
            if (itemStack.field_77994_a <= amount) {
                return null;
            }
            itemStack.field_77994_a -= amount;
            if (itemStack.field_77994_a <= 0) {
                return null;
            }
            return itemStack;
        }
        return null;
    }

    public static void consumeHeldItem(EntityPlayer player) {
        if (!player.field_71075_bZ.field_75098_d) {
            ItemStack stack = player.field_71071_by.func_70448_g();
            if (player != null && stack != null) {
                if ((stack = stack.func_77946_l()).func_77973_b().hasContainerItem(stack)) {
                    if (stack.field_77994_a == 1) {
                        stack = stack.func_77973_b().getContainerItem(stack);
                    } else {
                        player.field_71071_by.func_70441_a(stack.func_77973_b().getContainerItem(stack.func_77979_a(1)));
                    }
                } else if (stack.field_77994_a == 1) {
                    stack = null;
                } else {
                    stack.func_77979_a(1);
                }
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, stack);
            }
        }
    }

    public static void consumeBucketInHand(EntityPlayer player) {
        if (!player.field_71075_bZ.field_75098_d) {
            ItemStack bucket = new ItemStack(Items.field_151133_ar);
            if (player.func_70694_bm().field_77994_a == 1) {
                player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = bucket;
            } else if (player.func_70694_bm().field_77994_a > 1) {
                --player.func_70694_bm().field_77994_a;
                if (!player.field_71071_by.func_70441_a(bucket)) {
                    InventoryUtility.dropItemStack(new Location((Entity)player), bucket);
                }
            }
            player.field_71069_bz.func_75142_b();
        }
    }

    public static ItemStack consumeStack(ItemStack stack) {
        if (stack.field_77994_a == 1) {
            if (stack.func_77973_b().hasContainerItem(stack)) {
                return stack.func_77973_b().getContainerItem(stack);
            }
        } else {
            return stack.func_77979_a(1);
        }
        return null;
    }

    public static boolean stacksMatchExact(ItemStack stackA, ItemStack stackB) {
        if (stackA != null && stackB != null) {
            return stackA.func_77969_a(stackB) && InventoryUtility.doesStackNBTMatch(stackA, stackB) && stackA.field_77994_a == stackB.field_77994_a;
        }
        return stackA == null && stackB == null;
    }

    public static boolean stacksMatch(ItemStack stackA, ItemStack stackB) {
        if (stackA != null && stackB != null) {
            return stackA.func_77969_a(stackB) && InventoryUtility.doesStackNBTMatch(stackA, stackB);
        }
        return stackA == null && stackB == null;
    }

    public static boolean stacksMatchWithOreNames(ItemStack stackA, ItemStack stackB) {
        if (InventoryUtility.stacksMatch(stackA, stackB)) {
            return true;
        }
        return InventoryUtility.stacksMatchWithOreNames2(stackA, stackB) != null;
    }

    public static String stacksMatchWithOreNames2(ItemStack stackA, ItemStack stackB) {
        if (stackA != null && stackB != null) {
            ArrayList<Integer> a = new ArrayList<Integer>();
            for (int i : OreDictionary.getOreIDs((ItemStack)stackA)) {
                a.add(i);
            }
            for (int i : OreDictionary.getOreIDs((ItemStack)stackB)) {
                if (!a.contains(i)) continue;
                return OreDictionary.getOreName((int)i);
            }
        }
        return null;
    }

    public static boolean doesStackNBTMatch(ItemStack stackA, ItemStack stackB) {
        return NBTUtility.doTagsMatch(stackA.func_77978_p(), stackB.func_77978_p());
    }

    public static int getStackCount(ItemStack stack, IInventory inv, int[] slots) {
        int count = 0;
        if (stack != null) {
            ArrayList<Integer> slot_list = new ArrayList<Integer>();
            if (slots != null & slots.length > 0) {
                for (int i = 0; i < slots.length; ++i) {
                    slot_list.add(slots[i]);
                }
            }
            for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
                if (!slot_list.isEmpty() && !slot_list.contains(slot) || inv.func_70301_a(slot) == null || !inv.func_70301_a(slot).func_77969_a(stack)) continue;
                count += inv.func_70301_a((int)slot).field_77994_a;
            }
        }
        return count;
    }

    public static int getStackCount(Class<?> compare, IInventory inv) {
        return InventoryUtility.getStackCount(compare, inv);
    }

    public static int getStackCount(Class<?> compare, IInventory inv, int[] slots) {
        int count = 0;
        if (compare != null) {
            ArrayList<Integer> slot_list = new ArrayList<Integer>();
            if (slots != null & slots.length > 0) {
                for (int i = 0; i < slots.length; ++i) {
                    slot_list.add(slots[i]);
                }
            }
            for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
                if (!slot_list.isEmpty() && !slot_list.contains(slot) || inv.func_70301_a(slot) == null || !compare.isInstance(inv.func_70301_a(slot).func_77973_b())) continue;
                count += inv.func_70301_a((int)slot).field_77994_a;
            }
        }
        return count;
    }

    public static ArrayList getAllItemsInPlayerInventory(EntityPlayer entity) {
        int slot;
        ArrayList<ItemStack> itemsToDrop = new ArrayList<ItemStack>();
        for (slot = 0; slot < entity.field_71071_by.field_70462_a.length; ++slot) {
            if (entity.field_71071_by.field_70462_a[slot] == null) continue;
            itemsToDrop.add(entity.field_71071_by.field_70462_a[slot]);
        }
        for (slot = 0; slot < entity.field_71071_by.field_70460_b.length; ++slot) {
            if (entity.field_71071_by.field_70460_b[slot] == null) continue;
            itemsToDrop.add(entity.field_71071_by.field_70460_b[slot]);
        }
        return itemsToDrop;
    }

    public static boolean handleSlot(EntityPlayer player, IInventory inv, int slot) {
        return InventoryUtility.handleSlot(player, inv, slot, -1);
    }

    public static boolean handleSlot(EntityPlayer player, IInventory inv, int slot, int items) {
        if (player != null && inv != null && slot >= 0 && slot < inv.func_70302_i_() && !InventoryUtility.addItemToSlot(player, inv, slot, items)) {
            return InventoryUtility.removeItemFromSlot(player, inv, slot, items);
        }
        return false;
    }

    public static boolean addItemToSlot(EntityPlayer player, IInventory inv, int slot) {
        return InventoryUtility.addItemToSlot(player, inv, slot, -1);
    }

    public static boolean addItemToSlot(EntityPlayer player, IInventory inv, int slot, int items) {
        if (player.func_70694_bm() != null && inv.func_94041_b(slot, player.func_70694_bm()) && (inv.func_70301_a(slot) == null || InventoryUtility.stacksMatch(player.func_70694_bm(), inv.func_70301_a(slot)))) {
            int roomLeftInSlot = InventoryUtility.roomLeftInSlotForStack(inv, player.func_70694_bm(), slot);
            int itemsToAdd = Math.min(roomLeftInSlot, Math.min(player.func_70694_bm().field_77994_a, items == -1 ? roomLeftInSlot : items));
            if (inv.func_70301_a(slot) != null) {
                itemsToAdd += inv.func_70301_a((int)slot).field_77994_a;
            }
            inv.func_70299_a(slot, player.func_70694_bm().func_77946_l());
            inv.func_70301_a((int)slot).field_77994_a = itemsToAdd;
            if (!player.field_71075_bZ.field_75098_d) {
                player.func_70694_bm().field_77994_a -= itemsToAdd;
                if (player.func_70694_bm().field_77994_a <= 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                }
                player.field_71069_bz.func_75142_b();
            }
            return true;
        }
        return false;
    }

    public static int roomLeftInSlot(IInventory inv, int slot) {
        if (inv.func_70301_a(slot) != null) {
            int maxSpace = Math.min(inv.func_70301_a(slot).func_77976_d(), inv.func_70297_j_());
            return maxSpace - inv.func_70301_a((int)slot).field_77994_a;
        }
        return inv.func_70297_j_();
    }

    public static int roomLeftInStack(ItemStack stack) {
        return stack.func_77976_d() - stack.field_77994_a;
    }

    public static int roomLeftInSlotForStack(IInventory inv, ItemStack stack, int slot) {
        int maxSpace = Math.min(stack.func_77976_d(), inv.func_70297_j_());
        if (inv.func_70301_a(slot) != null) {
            return maxSpace - inv.func_70301_a((int)slot).field_77994_a;
        }
        return maxSpace;
    }

    public static int spaceInPlayersHand(EntityPlayer player) {
        return player.func_70694_bm() == null ? player.field_71071_by.func_70297_j_() : Math.min(player.field_71071_by.func_70297_j_(), player.func_70694_bm().func_77976_d()) - player.func_70694_bm().field_77994_a;
    }

    public static boolean removeItemFromSlot(EntityPlayer player, IInventory inv, int slot) {
        return InventoryUtility.removeItemFromSlot(player, inv, slot, -1);
    }

    public static boolean removeItemFromSlot(EntityPlayer player, IInventory inv, int slot, int items) {
        if (inv.func_70301_a(slot) != null && items >= -1 && items != 0) {
            int spaceInHand = InventoryUtility.spaceInPlayersHand(player);
            int itemsToMove = Math.min(Math.min(spaceInHand, inv.func_70301_a(slot).func_77976_d()), items == -1 ? inv.func_70297_j_() : items);
            ItemStack stack = inv.func_70301_a(slot).func_77946_l();
            stack.field_77994_a = itemsToMove;
            if (player.func_70694_bm() == null) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, stack);
            } else if (spaceInHand > 0) {
                player.func_70694_bm().field_77994_a += itemsToMove;
            } else if (!player.field_71071_by.func_70441_a(stack)) {
                InventoryUtility.dropItemStack(new Location((Entity)player), stack);
            }
            if (itemsToMove >= inv.func_70301_a((int)slot).field_77994_a) {
                inv.func_70299_a(slot, null);
            } else {
                inv.func_70301_a((int)slot).field_77994_a -= itemsToMove;
            }
            player.field_71069_bz.func_75142_b();
            return true;
        }
        return false;
    }
}

