/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.prefab.inventory;

import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.api.tile.IExtendedStorage;
import com.builtbroken.mc.lib.transform.vector.Location;
import com.builtbroken.mc.lib.transform.vector.Pos;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class InternalInventoryHandler {
    public World world;
    IPos3D location;
    Set<ItemStack> filteredItems;
    boolean inverted;

    public InternalInventoryHandler(World world, IPos3D location, Set<ItemStack> filters, boolean inverted) {
        this.world = world;
        this.location = location;
        this.filteredItems = filters;
        if (this.filteredItems == null) {
            this.filteredItems = new HashSet<ItemStack>();
        }
        this.inverted = inverted;
    }

    public InternalInventoryHandler(Location location, Set<ItemStack> filters, boolean inverted) {
        this(location.world, location, filters, inverted);
    }

    public InternalInventoryHandler(TileEntity tile) {
        this(new Location(tile), null, false);
    }

    public void setFilter(Set<ItemStack> filters, boolean inverted) {
        this.filteredItems = filters;
        this.inverted = inverted;
    }

    public void throwItem(ForgeDirection direction, ItemStack items) {
        this.throwItem((Pos)((Object)new Pos(this.location).add(direction)), items);
    }

    public void throwItem(Pos outputPosition, ItemStack items) {
        if (!this.world.field_72995_K) {
            EntityItem entityItem = new EntityItem(this.world, outputPosition.x() + 0.5, outputPosition.y() + 0.8, outputPosition.z() + 0.5, items);
            entityItem.field_70159_w = 0.0;
            entityItem.field_70179_y = 0.0;
            entityItem.field_70181_x /= 5.0;
            entityItem.field_145804_b = 20;
            this.world.func_72838_d((Entity)entityItem);
        }
    }

    public ItemStack storeItem(ItemStack item, ForgeDirection ... directions) {
        if (item != null) {
            ItemStack remainingStack = item.func_77946_l();
            for (ForgeDirection direction : directions) {
                remainingStack = this.tryPlaceInPosition(remainingStack, (Pos)((Object)new Pos(this.location).add(direction)), direction.getOpposite());
            }
            return remainingStack;
        }
        return item;
    }

    public ItemStack tryPlaceInPosition(ItemStack itemStack, Pos position, ForgeDirection dir) {
        TileEntity tileEntity = position.getTileEntity((IBlockAccess)this.world);
        ForgeDirection direction = dir.getOpposite();
        if (tileEntity != null && itemStack != null) {
            if (tileEntity instanceof TileEntityChest) {
                TileEntityChest[] chests = new TileEntityChest[]{(TileEntityChest)tileEntity, null};
                for (int i = 2; i < 6; ++i) {
                    ForgeDirection searchDirection = ForgeDirection.getOrientation((int)i);
                    Pos searchPosition = (Pos)position.clone();
                    searchPosition.add(searchDirection);
                    if (searchPosition.getTileEntity((IBlockAccess)this.world) == null || searchPosition.getTileEntity((IBlockAccess)this.world).getClass() != chests[0].getClass()) continue;
                    chests[1] = (TileEntityChest)searchPosition.getTileEntity((IBlockAccess)this.world);
                    break;
                }
                for (TileEntityChest chest : chests) {
                    if (chest == null) continue;
                    for (int i = 0; i < chest.func_70302_i_(); ++i) {
                        if ((itemStack = this.addStackToInventory(i, (IInventory)chest, itemStack)) != null) continue;
                        return null;
                    }
                }
            } else {
                if (tileEntity instanceof IExtendedStorage) {
                    return ((IExtendedStorage)tileEntity).addStackToStorage(itemStack);
                }
                if (tileEntity instanceof ISidedInventory) {
                    ISidedInventory inventory = (ISidedInventory)tileEntity;
                    int[] slots = inventory.func_94128_d(direction.ordinal());
                    for (int i = 0; i < slots.length; ++i) {
                        if (inventory.func_102007_a(slots[i], itemStack, direction.ordinal())) {
                            itemStack = this.addStackToInventory(slots[i], (IInventory)inventory, itemStack);
                        }
                        if (itemStack != null) continue;
                        return null;
                    }
                } else if (tileEntity instanceof IInventory) {
                    IInventory inventory = (IInventory)tileEntity;
                    for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                        if ((itemStack = this.addStackToInventory(i, inventory, itemStack)) != null) continue;
                        return null;
                    }
                }
            }
        }
        if (itemStack == null || itemStack.field_77994_a <= 0) {
            return null;
        }
        return itemStack;
    }

    public ItemStack addStackToInventory(int slotIndex, IInventory inventory, ItemStack itemStack) {
        if (inventory.func_70302_i_() > slotIndex) {
            ItemStack stackInInventory = inventory.func_70301_a(slotIndex);
            if (stackInInventory == null) {
                inventory.func_70299_a(slotIndex, itemStack);
                if (inventory.func_70301_a(slotIndex) == null) {
                    return itemStack;
                }
                return null;
            }
            if (stackInInventory.func_77969_a(itemStack) && stackInInventory.func_77985_e()) {
                stackInInventory = stackInInventory.func_77946_l();
                int stackLim = Math.min(inventory.func_70297_j_(), itemStack.func_77976_d());
                int rejectedAmount = Math.max(stackInInventory.field_77994_a + itemStack.field_77994_a - stackLim, 0);
                stackInInventory.field_77994_a = Math.min(Math.max(stackInInventory.field_77994_a + itemStack.field_77994_a - rejectedAmount, 0), inventory.func_70297_j_());
                itemStack.field_77994_a = rejectedAmount;
                inventory.func_70299_a(slotIndex, stackInInventory);
            }
        }
        if (itemStack.field_77994_a <= 0) {
            return null;
        }
        return itemStack;
    }

    public ItemStack tryGrabFromPosition(Pos position, ForgeDirection dir, int ammount) {
        ItemStack returnStack;
        block5: {
            TileEntity tileEntity;
            block7: {
                ForgeDirection direction;
                block6: {
                    returnStack = null;
                    tileEntity = position.getTileEntity((IBlockAccess)this.world);
                    direction = dir.getOpposite();
                    if (tileEntity == null) break block5;
                    if (tileEntity.getClass() != TileEntityChest.class) break block6;
                    TileEntityChest[] chests = new TileEntityChest[]{(TileEntityChest)tileEntity, null};
                    for (int i = 2; i < 6; ++i) {
                        ForgeDirection searchDirection = ForgeDirection.getOrientation((int)i);
                        Pos searchPosition = (Pos)position.clone();
                        searchPosition.add(searchDirection);
                        if (searchPosition.getTileEntity((IBlockAccess)this.world) == null || searchPosition.getTileEntity((IBlockAccess)this.world).getClass() != chests[0].getClass()) continue;
                        chests[1] = (TileEntityChest)searchPosition.getTileEntity((IBlockAccess)this.world);
                        break;
                    }
                    for (TileEntityChest chest : chests) {
                        if (chest == null) continue;
                        for (int i = 0; i < chest.func_70302_i_(); ++i) {
                            ItemStack itemStack = this.removeStackFromInventory(i, (IInventory)chest, ammount);
                            if (itemStack == null) continue;
                            returnStack = itemStack;
                            break block5;
                        }
                    }
                    break block5;
                }
                if (!(tileEntity instanceof ISidedInventory)) break block7;
                ISidedInventory inventory = (ISidedInventory)tileEntity;
                int[] slots = inventory.func_94128_d(direction.ordinal());
                for (int i = 0; i < slots.length; ++i) {
                    ItemStack itemStack;
                    int slot = slots[i];
                    ItemStack slotStack = inventory.func_70301_a(slot);
                    if (!inventory.func_102008_b(slot, slotStack, direction.ordinal()) || (itemStack = this.removeStackFromInventory(slot, (IInventory)inventory, ammount)) == null) continue;
                    returnStack = itemStack;
                    break block5;
                }
                break block5;
            }
            if (!(tileEntity instanceof IInventory)) break block5;
            IInventory inventory = (IInventory)tileEntity;
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack itemStack = this.removeStackFromInventory(i, inventory, ammount);
                if (itemStack == null) continue;
                returnStack = itemStack;
                break;
            }
        }
        return returnStack;
    }

    public ItemStack tryGrabFromPosition(ForgeDirection dir, int ammount) {
        return this.tryGrabFromPosition(new Pos(this.location), dir, ammount);
    }

    public ItemStack removeStackFromInventory(int slotIndex, IInventory inventory, int amount) {
        if (inventory.func_70301_a(slotIndex) != null) {
            ItemStack itemStack = inventory.func_70301_a(slotIndex).func_77946_l();
            if (this.getFilters().size() == 0 || this.isFiltering(itemStack)) {
                itemStack.field_77994_a = amount = Math.min(amount, itemStack.field_77994_a);
                inventory.func_70298_a(slotIndex, amount);
                return itemStack;
            }
        }
        return null;
    }

    public boolean isFiltering(ItemStack itemStack) {
        if (this.getFilters() != null && itemStack != null) {
            for (ItemStack filterStack : this.getFilters()) {
                if (filterStack == null || !filterStack.func_77969_a(itemStack)) continue;
                return !this.inverted;
            }
        }
        return this.inverted;
    }

    public Set<ItemStack> getFilters() {
        if (this.filteredItems == null) {
            this.filteredItems = new HashSet<ItemStack>();
        }
        return this.filteredItems;
    }
}

