/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.prefab.explosive.blast;

import com.builtbroken.mc.api.edit.IWorldChangeLayeredAction;
import com.builtbroken.mc.api.edit.IWorldEdit;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.lib.transform.vector.Location;
import com.builtbroken.mc.lib.world.edit.BlockEdit;
import com.builtbroken.mc.prefab.explosive.blast.Blast;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.IGrowable;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class BlastSimplePath<B extends BlastSimplePath>
extends Blast<B>
implements IWorldChangeLayeredAction {
    protected long lastUpdate = -1L;
    protected List<Location> pathed_locations = new ArrayList<Location>();
    public Location center;
    public boolean recursive = false;
    protected Queue<Location> stack = new LinkedList<Location>();
    protected int layers = 1;
    protected int blocksPerLayer = 500;

    public BlastSimplePath() {
    }

    public BlastSimplePath(World world, int x, int y, int z, int size) {
        super(world, x, y, z, size);
    }

    @Override
    public void getEffectedBlocks(List<IWorldEdit> list) {
        Location c = new Location(this.world(), (int)this.x(), (int)this.y(), (int)this.z());
        this.center = (Location)c.add(0.5);
        if (this.shouldPath(c)) {
            if (this.recursive) {
                this.pathNext(c, list);
            } else {
                this.pathEntire(c, list);
            }
        } else {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                Location location = (Location)this.center.add(dir);
                if (!this.shouldPath(location)) continue;
                if (this.recursive) {
                    this.pathNext(location, list);
                    continue;
                }
                this.pathEntire(location, list);
            }
        }
        ArrayList<BlockEdit> additions = new ArrayList<BlockEdit>();
        for (IWorldEdit vec : list) {
            BlockEdit edit;
            Block block;
            if (vec == null || !(vec.getBlock() instanceof BlockFarmland) || !(block = vec.world().func_147439_a((int)vec.x(), (int)vec.y() + 1, (int)vec.z())).func_149718_j(vec.world(), (int)vec.x(), (int)vec.y() + 1, (int)vec.z()) && !(block instanceof IPlantable) && !(block instanceof IGrowable) || list.contains(edit = new BlockEdit(vec.world(), (int)vec.x(), (int)vec.y() + 1, (int)vec.z()))) continue;
            additions.add(edit);
        }
        list.addAll(additions);
    }

    @Override
    public B setYield(double size) {
        double prev = this.size;
        super.setYield(size);
        if (prev != size) {
            this.calculateLayers();
        }
        return (B)this;
    }

    public final void calculateLayers() {
        double volume = Math.PI * this.size * this.size * this.size;
        int i = (int)(volume / (double)this.blocksPerLayer);
        this.layers = i > 0 ? i : 1;
    }

    @Override
    public int getLayers() {
        return this.layers;
    }

    @Override
    public boolean shouldContinueAction(int layer) {
        return layer == 0 || !this.stack.isEmpty();
    }

    public void pathEntire(Location startNode, List<IWorldEdit> list) {
        this.pathEntire(startNode, list, this.blocksPerLayer);
    }

    public void pathEntire(Location startNode, List<IWorldEdit> list, int count) {
        if (this.shouldPath(startNode)) {
            if (this.stack.isEmpty()) {
                list.add(this.changeBlock(startNode));
                this.stack.offer(startNode);
                this.pathed_locations.add(startNode);
            }
            int currentCount = 0;
            boolean shouldExit = false;
            while (!this.stack.isEmpty() && !shouldExit && currentCount < count) {
                long time;
                shouldExit = this.shouldKillAction();
                ++currentCount;
                if (this.lastUpdate != -1L && (double)((time = System.nanoTime()) - this.lastUpdate) > 1.0E8) {
                    this.lastUpdate = time;
                    Engine.instance.logger().info("PathEntireUpdate: " + list.size() + " entries added, " + this.stack.size() + " in stack, " + this.pathed_locations.size() + " nodes pathed.");
                }
                Location currentNode = this.stack.poll();
                for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                    Location nextNode = (Location)currentNode.add(dir);
                    if (!this.shouldPathTo(currentNode, nextNode)) continue;
                    if (this.shouldPath(nextNode)) {
                        this.stack.offer(nextNode);
                        IWorldEdit edit = this.changeBlock(nextNode);
                        if (edit != null && !list.contains(edit) && edit.hasChanged()) {
                            list.add(edit);
                        }
                    }
                    this.pathed_locations.add(nextNode);
                }
            }
        }
    }

    public void pathNext(Location node, List<IWorldEdit> list) {
        if (!this.shouldKillAction()) {
            if (!this.pathed_locations.contains(node)) {
                this.pathed_locations.add(node);
            }
            if (this.shouldPath(node)) {
                IWorldEdit edit = this.changeBlock(node);
                if (edit != null && !list.contains(edit) && edit.hasChanged()) {
                    list.add(edit);
                }
                for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                    Location next = (Location)node.add(dir);
                    if (!this.shouldPathTo(node, next)) continue;
                    this.pathNext(next, list);
                }
            }
        }
    }

    public abstract IWorldEdit changeBlock(Location var1);

    public boolean shouldPath(Location location) {
        return this.center.distance((double)location.xi() + 0.5, (double)location.yi() + 0.5, (double)location.zi() + 0.5) <= this.size;
    }

    public boolean shouldPathTo(Location last, Location next) {
        return next.y() >= 0.0 && next.y() <= 255.0 && !this.pathed_locations.contains(next);
    }
}

